/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionItem;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionTask;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.util.Exceptions;

final class JavadocCompletionQuery
extends AsyncCompletionQuery {
    private final int queryType;
    private int caretOffset;
    private List<CompletionItem> items;
    private JTextComponent component;

    public JavadocCompletionQuery(int queryType) {
        this.queryType = queryType;
    }

    protected void prepareQuery(JTextComponent component) {
        this.component = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
        try {
            this.caretOffset = caretOffset;
            this.items = null;
            Source source = Source.create((Document)doc);
            if (source != null && (this.queryType & 1) != 0) {
                JavadocCompletionTask<CompletionItem> task = JavadocCompletionTask.create(caretOffset, new JavadocCompletionItem.Factory(), this.queryType == 9, () -> ((JavadocCompletionQuery)this).isTaskCancelled());
                this.setCompletionHack(true);
                ParserManager.parse(Collections.singletonList(source), task);
                this.setCompletionHack(false);
                this.items = task.getResults();
                if (this.items != null) {
                    resultSet.addAllItems(this.items);
                }
                resultSet.setHasAdditionalItems(task.hasAdditionalItems());
                int anchorOffset = task.getAnchorOffset();
                if (anchorOffset > -1) {
                    resultSet.setAnchorOffset(anchorOffset);
                }
            }
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            resultSet.finish();
        }
    }

    protected boolean canFilter(JTextComponent component) {
        int newOffset = component.getSelectionStart();
        Document doc = component.getDocument();
        if (newOffset > this.caretOffset && this.items != null && !this.items.isEmpty()) {
            try {
                String prefix = doc.getText(this.caretOffset, newOffset - this.caretOffset);
                if (!this.isJavaIdentifierPart(prefix)) {
                    Completion.get().hideDocumentation();
                    Completion.get().hideCompletion();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isJavaIdentifierPart(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void setCompletionHack(boolean flag) {
        if (this.component != null) {
            this.component.putClientProperty("completion-active", flag);
        }
    }

    static List<CompletionItem> runCompletionQuery(int queryType, Document doc, int caret) {
        JavadocCompletionTask<CompletionItem> task = JavadocCompletionTask.create(caret, new JavadocCompletionItem.Factory(), queryType == 9, null);
        Source source = Source.create((Document)doc);
        if (source != null) {
            try {
                ParserManager.parse(Collections.singletonList(source), task);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return task.getResults();
    }
}

