/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.binary.JSAddNode;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.nodes.cast.JSToOperandNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import com.oracle.truffle.js.runtime.objects.OperatorSet;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class JSOverloadedBinaryNode
extends JavaScriptBaseNode {
    private final TruffleString overloadedOperatorName;
    private final boolean numeric;
    private final JSToPrimitiveNode.Hint hint;
    private final boolean leftToRight;

    protected JSOverloadedBinaryNode(TruffleString overloadedOperatorName, boolean numeric, JSToPrimitiveNode.Hint hint, boolean leftToRight) {
        this.overloadedOperatorName = overloadedOperatorName;
        this.numeric = numeric;
        this.hint = hint;
        this.leftToRight = leftToRight;
    }

    @NeverDefault
    public static JSOverloadedBinaryNode create(TruffleString overloadedOperatorName, JSToPrimitiveNode.Hint hint) {
        return JSOverloadedBinaryNodeGen.create(overloadedOperatorName, false, hint, true);
    }

    @NeverDefault
    public static JSOverloadedBinaryNode createHintDefault(TruffleString overloadedOperatorName) {
        return JSOverloadedBinaryNodeGen.create(overloadedOperatorName, false, JSToPrimitiveNode.Hint.Default, true);
    }

    @NeverDefault
    public static JSOverloadedBinaryNode createHintNumber(TruffleString overloadedOperatorName) {
        return JSOverloadedBinaryNodeGen.create(overloadedOperatorName, false, JSToPrimitiveNode.Hint.Number, true);
    }

    @NeverDefault
    public static JSOverloadedBinaryNode createHintNumberLeftToRight(TruffleString overloadedOperatorName) {
        return JSOverloadedBinaryNodeGen.create(overloadedOperatorName, false, JSToPrimitiveNode.Hint.Number, true);
    }

    @NeverDefault
    public static JSOverloadedBinaryNode createHintNumberRightToLeft(TruffleString overloadedOperatorName) {
        return JSOverloadedBinaryNodeGen.create(overloadedOperatorName, false, JSToPrimitiveNode.Hint.Number, false);
    }

    @NeverDefault
    public static JSOverloadedBinaryNode createHintString(TruffleString overloadedOperatorName) {
        return JSOverloadedBinaryNodeGen.create(overloadedOperatorName, false, JSToPrimitiveNode.Hint.String, true);
    }

    @NeverDefault
    public static JSOverloadedBinaryNode createNumeric(TruffleString overloadedOperatorName) {
        return JSOverloadedBinaryNodeGen.create(overloadedOperatorName, true, null, true);
    }

    public abstract Object execute(Object var1, Object var2);

    @Specialization(guards={"!isNumeric()", "!isAddition()"})
    protected Object doToOperandGeneric(Object left, Object right, @Cached(value="create(getHint(), !isEquality())") JSToOperandNode toOperandLeftNode, @Cached(value="create(getHint(), !isEquality())") JSToOperandNode toOperandRightNode, @Cached(value="create(getOverloadedOperatorName())") @Cached.Shared(value="dispatchBinaryOperator") DispatchBinaryOperatorNode dispatchBinaryOperatorNode) {
        Object rightOperand;
        Object leftOperand;
        if (this.leftToRight) {
            leftOperand = toOperandLeftNode.execute(left);
            rightOperand = toOperandRightNode.execute(right);
        } else {
            rightOperand = toOperandRightNode.execute(right);
            leftOperand = toOperandLeftNode.execute(left);
        }
        return dispatchBinaryOperatorNode.execute(leftOperand, rightOperand);
    }

    @Specialization(guards={"!isNumeric()", "isAddition()"})
    protected Object doToOperandAddition(Object left, Object right, @Bind(value="this") Node node, @Cached(value="create(getHint())") JSToOperandNode toOperandLeftNode, @Cached(value="create(getHint())") JSToOperandNode toOperandRightNode, @Cached(value="create(getOverloadedOperatorName())") @Cached.Shared(value="dispatchBinaryOperator") DispatchBinaryOperatorNode dispatchBinaryOperatorNode, @Cached JSToStringNode toStringLeftNode, @Cached JSToStringNode toStringRightNode, @Cached InlinedConditionProfile leftStringProfile, @Cached InlinedConditionProfile rightStringProfile, @Cached(value="createUnoptimized()") JSAddNode addNode) {
        Object rightOperand;
        Object leftOperand;
        if (this.leftToRight) {
            leftOperand = toOperandLeftNode.execute(left);
            rightOperand = toOperandRightNode.execute(right);
        } else {
            rightOperand = toOperandRightNode.execute(right);
            leftOperand = toOperandLeftNode.execute(left);
        }
        if (leftStringProfile.profile(node, JSGuards.isString(leftOperand))) {
            return addNode.execute(leftOperand, toStringRightNode.executeString(rightOperand));
        }
        if (rightStringProfile.profile(node, JSGuards.isString(rightOperand))) {
            return addNode.execute(toStringLeftNode.executeString(leftOperand), rightOperand);
        }
        return dispatchBinaryOperatorNode.execute(leftOperand, rightOperand);
    }

    @Specialization(guards={"isNumeric()"})
    protected Object doToNumericOperand(Object left, Object right, @Cached(value="create(true)") JSToNumericNode toNumericOperandLeftNode, @Cached(value="create(true)") JSToNumericNode toNumericOperandRightNode, @Cached(value="create(getOverloadedOperatorName())") @Cached.Shared(value="dispatchBinaryOperator") DispatchBinaryOperatorNode dispatchBinaryOperatorNode) {
        Object rightOperand;
        Object leftOperand;
        if (this.leftToRight) {
            leftOperand = toNumericOperandLeftNode.execute(left);
            rightOperand = toNumericOperandRightNode.execute(right);
        } else {
            rightOperand = toNumericOperandRightNode.execute(right);
            leftOperand = toNumericOperandLeftNode.execute(left);
        }
        return dispatchBinaryOperatorNode.execute(leftOperand, rightOperand);
    }

    protected TruffleString getOverloadedOperatorName() {
        return this.overloadedOperatorName;
    }

    @Idempotent
    protected final boolean isNumeric() {
        return this.numeric;
    }

    protected JSToPrimitiveNode.Hint getHint() {
        return this.hint;
    }

    @Idempotent
    protected boolean isAddition() {
        return Strings.equals(Strings.SYMBOL_PLUS, this.overloadedOperatorName);
    }

    protected boolean isEquality() {
        return Strings.equals(Strings.SYMBOL_EQUALS_EQUALS, this.overloadedOperatorName);
    }

    @ImportStatic(value={OperatorSet.class})
    public static abstract class DispatchBinaryOperatorNode
    extends JavaScriptBaseNode {
        static final int LIMIT = 3;
        private final TruffleString overloadedOperatorName;

        protected DispatchBinaryOperatorNode(TruffleString overloadedOperatorName) {
            this.overloadedOperatorName = overloadedOperatorName;
        }

        protected abstract Object execute(Object var1, Object var2);

        @Specialization(guards={"left.matchesOperatorCounter(leftOperatorCounter)", "right.matchesOperatorCounter(rightOperatorCounter)"}, limit="LIMIT")
        protected Object doOverloadedOverloaded(JSOverloadedOperatorsObject left, JSOverloadedOperatorsObject right, @Cached(value="left.getOperatorCounter()") int leftOperatorCounter, @Cached(value="right.getOperatorCounter()") int rightOperatorCounter, @Cached(value="getOperatorImplementation(left, right, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        @Specialization(guards={"left.matchesOperatorCounter(leftOperatorCounter)", "isNumber(right)"}, limit="LIMIT")
        protected Object doOverloadedNumber(JSOverloadedOperatorsObject left, Object right, @Cached(value="left.getOperatorCounter()") int leftOperatorCounter, @Cached(value="getOperatorImplementation(left, right, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        @Specialization(guards={"left.matchesOperatorCounter(leftOperatorCounter)"}, limit="LIMIT")
        protected Object doOverloadedBigInt(JSOverloadedOperatorsObject left, BigInt right, @Cached(value="left.getOperatorCounter()") int leftOperatorCounter, @Cached(value="getOperatorImplementation(left, right, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        @Specialization(guards={"left.matchesOperatorCounter(leftOperatorCounter)", "isString(right)", "!isAddition()"}, limit="LIMIT")
        protected Object doOverloadedString(JSOverloadedOperatorsObject left, Object right, @Cached(value="left.getOperatorCounter()") int leftOperatorCounter, @Cached(value="getOperatorImplementation(left, right, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        @Specialization(guards={"isNullOrUndefined(right)"})
        protected Object doOverloadedNullish(JSOverloadedOperatorsObject left, Object right) {
            return this.missingImplementation();
        }

        @Specialization(guards={"right.matchesOperatorCounter(rightOperatorCounter)", "isNumber(left)"}, limit="LIMIT")
        protected Object doNumberOverloaded(Object left, JSOverloadedOperatorsObject right, @Cached(value="right.getOperatorCounter()") int rightOperatorCounter, @Cached(value="getOperatorImplementation(left, right, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        @Specialization(guards={"right.matchesOperatorCounter(rightOperatorCounter)"}, limit="LIMIT")
        protected Object doBigIntOverloaded(BigInt left, JSOverloadedOperatorsObject right, @Cached(value="right.getOperatorCounter()") int rightOperatorCounter, @Cached(value="getOperatorImplementation(left, right, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        @Specialization(guards={"right.matchesOperatorCounter(rightOperatorCounter)", "isString(left)", "!isAddition()"}, limit="LIMIT")
        protected Object doStringOverloaded(Object left, JSOverloadedOperatorsObject right, @Cached(value="right.getOperatorCounter()") int rightOperatorCounter, @Cached(value="getOperatorImplementation(left, right, getOverloadedOperatorName())") Object operatorImplementation, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        @Specialization(guards={"isNullOrUndefined(left)"})
        protected Object doNullishOverloaded(Object left, JSOverloadedOperatorsObject right) {
            return this.missingImplementation();
        }

        @Specialization(replaces={"doOverloadedOverloaded", "doOverloadedNumber", "doOverloadedBigInt", "doOverloadedString", "doNumberOverloaded", "doBigIntOverloaded", "doStringOverloaded"})
        @ReportPolymorphism.Megamorphic
        protected Object doGeneric(Object left, Object right, @Cached(value="createCall()") @Cached.Exclusive JSFunctionCallNode callNode) {
            Object operatorImplementation = OperatorSet.getOperatorImplementation(left, right, this.getOverloadedOperatorName());
            return this.performOverloaded(callNode, operatorImplementation, left, right);
        }

        private boolean missingImplementation() {
            if (this.isEquality()) {
                return false;
            }
            throw Errors.createTypeErrorNoOverloadFound(this.getOverloadedOperatorName(), this);
        }

        private Object performOverloaded(JSFunctionCallNode callNode, Object operatorImplementation, Object left, Object right) {
            if (operatorImplementation == null) {
                return this.missingImplementation();
            }
            return callNode.executeCall(JSArguments.create((Object)Undefined.instance, operatorImplementation, left, right));
        }

        protected TruffleString getOverloadedOperatorName() {
            return this.overloadedOperatorName;
        }

        @Idempotent
        protected boolean isAddition() {
            return Strings.equals(Strings.SYMBOL_PLUS, this.overloadedOperatorName);
        }

        protected boolean isEquality() {
            return Strings.equals(Strings.SYMBOL_EQUALS_EQUALS, this.overloadedOperatorName);
        }
    }
}

