/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Customizer;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.xml.catalog.CatalogMounterModel;
import org.openide.util.NbBundle;

final class CatalogMounterPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = -1208422697106159058L;
    private CatalogMounterModel model;
    private JComboBox catalogComboBox;
    private JLabel catalogLabel;
    private JPanel parentPanel;

    public CatalogMounterPanel(CatalogMounterModel model) {
        this.model = model;
        this.initComponents();
        this.initAccessibility();
        this.catalogLabel.setDisplayedMnemonic(NbBundle.getMessage(CatalogMounterPanel.class, (String)"CatalogMounterPanel.catalogLabel.mne").charAt(0));
        this.catalogComboBox.setModel(model.getCatalogComboBoxModel());
        this.updateCatalogPanel();
        model.addChangeListener(this);
    }

    private Dimension comboSize(int columns) {
        JTextField template = new JTextField();
        template.setColumns(columns);
        return template.getPreferredSize();
    }

    private void initComponents() {
        this.catalogLabel = new JLabel();
        this.catalogComboBox = new JComboBox();
        this.parentPanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setMinimumSize(new Dimension(380, 100));
        this.setLayout(new GridBagLayout());
        this.catalogLabel.setLabelFor(this.catalogComboBox);
        this.catalogLabel.setText(NbBundle.getMessage(CatalogMounterPanel.class, (String)"CatalogMounterPanel.catalogLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.catalogLabel, gridBagConstraints);
        this.catalogComboBox.setPreferredSize(this.comboSize(40));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.catalogComboBox, gridBagConstraints);
        this.parentPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.parentPanel, gridBagConstraints);
    }

    private void updateCatalogPanel() {
        Customizer cust = this.model.getCatalogCustomizer();
        cust.setObject(this.model.getCatalog());
        this.invalidate();
        this.parentPanel.removeAll();
        Component catalogPanel = (Component)((Object)cust);
        this.parentPanel.add(catalogPanel, "Center");
        this.validate();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateCatalogPanel();
    }

    private void initAccessibility() {
        this.catalogComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogMounterPanel.class, (String)"ACSD_catalogComboBox"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CatalogMounterPanel.class, (String)"ACSN_CatalogMounterPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogMounterPanel.class, (String)"ACSD_CatalogMounterPanel"));
    }
}

