/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.beaninfo.swing;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.beans.SimpleBeanInfo;
import java.util.ResourceBundle;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

abstract class BISupport
extends SimpleBeanInfo {
    private PropertyDescriptor[] pds;
    private String icon;
    private Class beanClass;

    protected BISupport(String iconBaseName, Class beanClass) {
        this.icon = iconBaseName;
        this.beanClass = beanClass;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return new BeanDescriptor(this.beanClass);
    }

    @Override
    public synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (this.pds == null) {
            try {
                this.pds = this.createPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                this.pds = super.getPropertyDescriptors();
            }
        }
        return this.pds;
    }

    @Override
    public Image getIcon(int type) {
        if (type == 2 || type == 4) {
            return ImageUtilities.loadImage((String)("org/netbeans/modules/form/beaninfo/swing/" + this.icon + "32.gif"));
        }
        return ImageUtilities.loadImage((String)("org/netbeans/modules/form/beaninfo/swing/" + this.icon + ".gif"));
    }

    protected PropertyDescriptor[] createPropertyDescriptors() throws IntrospectionException {
        return new PropertyDescriptor[0];
    }

    protected String getString(String key) {
        return NbBundle.getMessage(BISupport.class, (String)key);
    }

    protected PropertyDescriptor createRW(Class beanClass, String name) throws IntrospectionException {
        String title = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        PropertyDescriptor pd = new PropertyDescriptor(name, beanClass, "get" + title, "set" + title);
        this.setProps(pd, beanClass, title);
        return pd;
    }

    protected PropertyDescriptor createRO(Class beanClass, String name) throws IntrospectionException {
        String title = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        PropertyDescriptor pd = new PropertyDescriptor(name, beanClass, "get" + title, null);
        this.setProps(pd, beanClass, title);
        return pd;
    }

    private void setProps(PropertyDescriptor pd, Class beanClass, String title) {
        String className = beanClass.getName();
        int dotIdx = className.lastIndexOf(46);
        className = dotIdx > 0 ? className.substring(dotIdx + 1) : className;
        pd.setDisplayName(this.getString("PROP_" + className + '.' + title));
        pd.setShortDescription(this.getString("HINT_" + className + '.' + title));
    }

    static class TaggedPropertyEditor
    extends PropertyEditorSupport {
        private String[] tags;
        private int[] values;
        private String[] javaInitStrings;
        private String[] tagKeys;

        protected TaggedPropertyEditor(int[] values, String[] javaInitStrings, String[] tagKeys) {
            this.values = values;
            this.javaInitStrings = javaInitStrings;
            this.tagKeys = tagKeys;
        }

        @Override
        public String[] getTags() {
            if (this.tags == null) {
                this.createTags();
            }
            return this.tags;
        }

        @Override
        public String getAsText() {
            Object valObj = this.getValue();
            if (valObj instanceof Integer) {
                if (this.tags == null) {
                    this.createTags();
                }
                int value = (Integer)valObj;
                for (int i = 0; i < this.values.length; ++i) {
                    if (value != this.values[i]) continue;
                    return this.tags[i];
                }
            }
            return null;
        }

        @Override
        public void setAsText(String str) {
            if (this.tags == null) {
                this.createTags();
            }
            int value = -1;
            for (int i = 0; i < this.tags.length; ++i) {
                if (!str.equals(this.tags[i])) continue;
                value = this.values[i];
                break;
            }
            if (value != -1) {
                this.setValue(value);
            }
        }

        @Override
        public String getJavaInitializationString() {
            Object valObj = this.getValue();
            if (valObj instanceof Integer) {
                int value = (Integer)valObj;
                for (int i = 0; i < this.values.length; ++i) {
                    if (value != this.values[i]) continue;
                    return this.javaInitStrings[i];
                }
            }
            return "???";
        }

        private void createTags() {
            this.tags = new String[this.tagKeys.length];
            ResourceBundle bundle = NbBundle.getBundle(BISupport.class);
            for (int i = 0; i < this.tagKeys.length; ++i) {
                this.tags[i] = bundle.getString(this.tagKeys[i]);
            }
        }
    }
}

