/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.NodeSourceOption;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="sourceType")
@JsonFilter(value="explicitlySetFilter")
public final class NodeSourceViaImageOption
extends NodeSourceOption {
    @JsonProperty(value="imageId")
    private final String imageId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public NodeSourceViaImageOption(String sourceName, String imageId) {
        super(sourceName);
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NodeSourceViaImageOption(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeSourceViaImageOption)) {
            return false;
        }
        NodeSourceViaImageOption other = (NodeSourceViaImageOption)((Object)o);
        return Objects.equals(this.imageId, other.imageId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="sourceName")
        private String sourceName;
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            this.__explicitlySet__.add("sourceName");
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public NodeSourceViaImageOption build() {
            NodeSourceViaImageOption model = new NodeSourceViaImageOption(this.sourceName, this.imageId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NodeSourceViaImageOption model) {
            if (model.wasPropertyExplicitlySet("sourceName")) {
                this.sourceName(model.getSourceName());
            }
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            return this;
        }
    }
}

