/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.osgi.customizer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginContainer;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.maven.osgi.customizer.InstructionsConverter;
import org.netbeans.modules.maven.spi.customizer.SelectedItemsTablePersister;

public class FelixExportPersister
implements SelectedItemsTablePersister {
    private final ModelHandle2 handle;
    private final Project project;
    private ModelOperation<POMModel> operation;
    private ModelOperation<POMModel> defaultOperation;
    private boolean isDefined = false;
    private SortedMap<String, Boolean> defaultValue;

    public FelixExportPersister(Project project, ModelHandle2 handle) {
        this.project = project;
        this.handle = handle;
        String[] exports = PluginPropertyUtils.getPluginPropertyList((Project)project, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"Export-Package", (String)"manifest");
        String exportInstruction = null;
        if (exports != null && exports.length == 1) {
            exportInstruction = exports[0];
            this.isDefined = true;
        } else {
            this.isDefined = false;
        }
        String[] privates = PluginPropertyUtils.getPluginPropertyList((Project)project, (String)"org.apache.felix", (String)"maven-bundle-plugin", (String)"instructions", (String)"Private-Package", (String)"manifest");
        String privateInstruction = null;
        if (privates != null && privates.length == 1) {
            privateInstruction = privates[0];
        }
        HashMap<Integer, String> instructions = new HashMap<Integer, String>(2);
        instructions.put(InstructionsConverter.EXPORT_PACKAGE, exportInstruction);
        instructions.put(InstructionsConverter.PRIVATE_PACKAGE, privateInstruction);
        this.defaultValue = InstructionsConverter.computeExportList(instructions, project);
    }

    public boolean isIsDefined() {
        return this.isDefined;
    }

    public SortedMap<String, Boolean> read() {
        return this.defaultValue;
    }

    public void write(SortedMap<String, Boolean> selItems) {
        if (this.operation != null) {
            this.handle.removePOMModification(this.operation);
        }
        final Map<Integer, String> exportIns = InstructionsConverter.computeExportInstructions(selItems, this.project);
        this.operation = new ModelOperation<POMModel>(){
            final /* synthetic */ FelixExportPersister this$0;
            {
                this.this$0 = this$0;
            }

            public void performOperation(POMModel pomModel) {
                Build build = pomModel.getProject().getBuild();
                Plugin felixPlugin = null;
                if (build != null) {
                    felixPlugin = build.findPluginById("org.apache.felix", "maven-bundle-plugin");
                } else {
                    build = pomModel.getFactory().createBuild();
                    pomModel.getProject().setBuild(build);
                }
                Configuration config = null;
                if (felixPlugin != null) {
                    config = felixPlugin.getConfiguration();
                } else {
                    felixPlugin = pomModel.getFactory().createPlugin();
                    felixPlugin.setGroupId("org.apache.felix");
                    felixPlugin.setArtifactId("maven-bundle-plugin");
                    felixPlugin.setExtensions(Boolean.TRUE);
                    build.addPlugin(felixPlugin);
                }
                if (config == null) {
                    config = pomModel.getFactory().createConfiguration();
                    felixPlugin.setConfiguration(config);
                }
                POMExtensibilityElement instructionsEl = null;
                List confEls = config.getConfigurationElements();
                for (POMExtensibilityElement el : confEls) {
                    if (!"instructions".equals(el.getQName().getLocalPart())) continue;
                    instructionsEl = el;
                    break;
                }
                if (instructionsEl == null) {
                    instructionsEl = pomModel.getFactory().createPOMExtensibilityElement(new QName("instructions"));
                    config.addExtensibilityElement(instructionsEl);
                }
                POMExtensibilityElement exportEl = ModelUtils.getOrCreateChild(instructionsEl, (String)"Export-Package", (POMModel)pomModel);
                POMExtensibilityElement privateEl = ModelUtils.getOrCreateChild((POMComponent)instructionsEl, (String)"Private-Package", (POMModel)pomModel);
                exportEl.setElementText((String)exportIns.get(InstructionsConverter.EXPORT_PACKAGE));
                privateEl.setElementText((String)exportIns.get(InstructionsConverter.PRIVATE_PACKAGE));
            }
        };
        this.handle.addPOMModification(this.operation);
    }

    void setDefault(boolean def) {
        if (def) {
            if (this.operation != null) {
                this.handle.removePOMModification(this.operation);
            }
            if (this.defaultOperation == null) {
                this.defaultOperation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel pomModel) {
                        List profiles;
                        Build build = pomModel.getProject().getBuild();
                        if (build != null) {
                            this.removeExportPrivate(this.findInstructions((PluginContainer)build));
                            PluginManagement pm = build.getPluginManagement();
                            if (pm != null) {
                                this.removeExportPrivate(this.findInstructions((PluginContainer)pm));
                            }
                        }
                        if ((profiles = FelixExportPersister.this.handle.getActiveConfiguration().getActivatedProfiles()) != null) {
                            for (String prof : profiles) {
                                BuildBase bb;
                                Profile p = pomModel.getProject().findProfileById(prof);
                                if (p == null || (bb = p.getBuildBase()) == null) continue;
                                this.removeExportPrivate(this.findInstructions((PluginContainer)bb));
                                PluginManagement pm = bb.getPluginManagement();
                                if (pm == null) continue;
                                this.removeExportPrivate(this.findInstructions((PluginContainer)pm));
                            }
                        }
                    }

                    private POMExtensibilityElement findInstructions(PluginContainer cont) {
                        Configuration config;
                        Plugin felixPlugin = cont.findPluginById("org.apache.felix", "maven-bundle-plugin");
                        if (felixPlugin != null && (config = felixPlugin.getConfiguration()) != null) {
                            List confEls = config.getConfigurationElements();
                            for (POMExtensibilityElement el : confEls) {
                                if (!"instructions".equals(el.getQName().getLocalPart())) continue;
                                return el;
                            }
                        }
                        return null;
                    }

                    private void removeExportPrivate(POMExtensibilityElement instructionsEl) {
                        if (instructionsEl != null) {
                            for (POMExtensibilityElement el : instructionsEl.getAnyElements()) {
                                if ("Export-Package".equals(el.getQName().getLocalPart())) {
                                    instructionsEl.removeAnyElement(el);
                                }
                                if (!"Private-Package".equals(el.getQName().getLocalPart())) continue;
                                instructionsEl.removeAnyElement(el);
                            }
                        }
                    }
                };
            }
            this.handle.addPOMModification(this.defaultOperation);
        } else {
            if (this.operation != null) {
                this.handle.addPOMModification(this.operation);
            }
            if (this.defaultOperation != null) {
                this.handle.removePOMModification(this.defaultOperation);
            }
        }
    }
}

