/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.common.tools;

import com.sun.xml.registry.common.tools.bindings_v3.JAXRClassificationScheme;
import com.sun.xml.registry.common.tools.bindings_v3.JAXRConcept;
import com.sun.xml.registry.common.tools.bindings_v3.Namepattern;
import com.sun.xml.registry.common.tools.bindings_v3.ObjectFactory;
import com.sun.xml.registry.common.tools.bindings_v3.PredefinedConcepts;
import com.sun.xml.registry.uddi.ConnectionImpl;
import com.sun.xml.registry.uddi.infomodel.ClassificationSchemeImpl;
import com.sun.xml.registry.uddi.infomodel.ConceptImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.KeyImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.RegistryObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXRConceptsManager {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.common");
        }
    });
    static Locale US_LOCALE = new Locale("en", "US");
    static PredefinedConcepts predefines;
    static PredefinedConcepts naics;
    static PredefinedConcepts iso;
    static PredefinedConcepts unsp;
    static PredefinedConcepts user;
    static Collection definedSchemes;
    ArrayList fileList = new ArrayList();
    HashMap dMap = new HashMap();
    String jaxrFile;
    String naicsFile;
    String isoFile;
    String predefinesDTD;
    HashMap idMap;
    ConnectionImpl connection;
    private static JAXRConceptsManager instance;
    private JAXBContext jc;
    private ObjectFactory objFactory;
    private Unmarshaller u;
    private static String taxonomyPath;

    public static JAXRConceptsManager getInstance(ConnectionImpl connection) {
        try {
            if (instance == null) {
                instance = new JAXRConceptsManager(connection);
            }
            instance.loadTaxonomies();
            definedSchemes = instance.taxonomies2TaxonomyTree();
        }
        catch (JAXRException ex) {
            System.out.println("Failed to load taxonomies");
            ex.printStackTrace();
        }
        return instance;
    }

    private JAXRConceptsManager(ConnectionImpl connection) {
        this.connection = connection;
        this.idMap = new HashMap();
        this.initJAXBObjectFactory();
    }

    private void initJAXBObjectFactory() {
        try {
            if (this.jc == null) {
                this.jc = JAXBContext.newInstance("com.sun.xml.registry.common.tools.bindings_v3");
            }
        }
        catch (JAXBException jbe) {
            System.out.println("Exiting unable to initial JAXB context");
        }
        if (this.objFactory == null) {
            this.objFactory = new ObjectFactory();
        }
        try {
            this.u = this.jc.createUnmarshaller();
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public Collection findClassificationSchemeByName(Collection findQualifiers, String namePattern) throws JAXRException {
        Collection matchingSchemes = this.getClassificationSchemeByName(findQualifiers, namePattern);
        return matchingSchemes;
    }

    public Concept findConceptByPath(String path) throws JAXRException {
        return this.getConceptsByPath2(path);
    }

    public Collection findClassificationSchemes(Collection findQualifiers, Collection namePatterns, Collection classifications, Collection externalLinks) throws JAXRException {
        Collection matches = this.doFindClassificationSchemes(findQualifiers, namePatterns);
        return matches;
    }

    public Collection getChildConcepts(ClassificationScheme scheme) throws JAXRException {
        if (scheme != null) {
            return scheme.getChildrenConcepts();
        }
        return null;
    }

    Collection stringNames2Namepatterns(Collection patterns) {
        ArrayList<Namepattern> namepatterns = new ArrayList<Namepattern>();
        Iterator iter = patterns.iterator();
        Namepattern pattern = null;
        while (iter.hasNext()) {
            pattern = this.objFactory.createNamepattern();
            pattern.setContent(iter.next().toString());
            namepatterns.add(pattern);
        }
        return namepatterns;
    }

    private JAXRClassificationScheme classificationScheme2JAXRClassificationScheme(ClassificationScheme scheme) throws JAXRException {
        if (scheme != null) {
            this.logger.finest("Scheme is not null");
            String key = scheme.getKey().getId();
            String name = null;
            InternationalString iName = scheme.getName();
            if (iName != null) {
                name = iName.getValue();
            }
            Object description = null;
            JAXRClassificationScheme jaxrScheme = null;
            jaxrScheme = this.objFactory.createJAXRClassificationScheme();
            jaxrScheme.setId(key);
            jaxrScheme.setName(name);
            if (jaxrScheme != null) {
                this.logger.finest("jaxrScheme is not null in cs2jrcl");
            }
            return jaxrScheme;
        }
        return null;
    }

    Collection jaxrClassificationSchemes2ClassificationSchemes(Collection schemes) throws JAXRException {
        ArrayList<ClassificationSchemeImpl> classificationSchemes = new ArrayList<ClassificationSchemeImpl>();
        if (schemes != null) {
            Iterator iter = schemes.iterator();
            ClassificationSchemeImpl classificationScheme = null;
            while (iter.hasNext()) {
                JAXRClassificationScheme scheme = (JAXRClassificationScheme)iter.next();
                String key = scheme.getId();
                String name = scheme.getName();
                String description = scheme.getDescription();
                classificationScheme = new ClassificationSchemeImpl(new KeyImpl(key));
                classificationScheme.setName(new InternationalStringImpl(US_LOCALE, name));
                classificationScheme.setDescription(new InternationalStringImpl(US_LOCALE, description));
                classificationScheme.setPredefined(true);
                this.idMap.put(classificationScheme.getKey().getId(), classificationScheme);
                classificationSchemes.add(classificationScheme);
            }
        }
        return classificationSchemes;
    }

    ClassificationScheme jaxrClassificationScheme2ClassificationScheme(JAXRClassificationScheme scheme) throws JAXRException {
        ClassificationSchemeImpl classificationScheme = null;
        if (scheme != null) {
            String key = scheme.getId();
            String name = scheme.getName();
            String description = scheme.getDescription();
            classificationScheme = new ClassificationSchemeImpl(new KeyImpl(key));
            classificationScheme.setName(new InternationalStringImpl(US_LOCALE, name));
            classificationScheme.setDescription(new InternationalStringImpl(US_LOCALE, description));
            classificationScheme.setPredefined(true);
            this.idMap.put(classificationScheme.getKey().getId(), classificationScheme);
        }
        return classificationScheme;
    }

    Collection jaxrConcepts2Concepts(ClassificationScheme scheme, Collection jaxrConcepts) throws JAXRException {
        ArrayList<ConceptImpl> concepts = new ArrayList<ConceptImpl>();
        this.idMap.clear();
        ClassificationSchemeImpl parentScheme = null;
        ClassificationSchemeImpl classificationScheme = (ClassificationSchemeImpl)scheme;
        if (scheme != null) {
            classificationScheme.setPredefined(true);
            this.idMap.put(classificationScheme.getKey().getId(), classificationScheme);
            if (jaxrConcepts != null) {
                Iterator iter = jaxrConcepts.iterator();
                while (iter.hasNext()) {
                    ConceptImpl concept = null;
                    JAXRConcept jaxrConcept = (JAXRConcept)iter.next();
                    String ckey = jaxrConcept.getId();
                    String cname = jaxrConcept.getName();
                    String cvalue = jaxrConcept.getCode();
                    String parentId = jaxrConcept.getParent();
                    concept = new ConceptImpl();
                    concept.setKey(new KeyImpl(ckey));
                    concept.setIsRetrieved(true);
                    concept.setIsLoaded(true);
                    concept.setName(new InternationalStringImpl(US_LOCALE, cname));
                    concept.setValue(cvalue);
                    concept.setPredefined(true);
                    this.idMap.put(ckey, concept);
                    Object parent = this.idMap.get(parentId);
                    if (parent == null) {
                        concepts.add(concept);
                    }
                    if (parent instanceof ClassificationSchemeImpl) {
                        parentScheme = (ClassificationSchemeImpl)parent;
                        concept.setClassificationScheme(parentScheme);
                        parentScheme.addChildConcept(concept);
                        continue;
                    }
                    if (!(parent instanceof ConceptImpl)) continue;
                    ConceptImpl parentConcept = (ConceptImpl)parent;
                    concept.setParentConcept(concept);
                    parentConcept.addChildConcept(concept);
                }
                if (parentScheme != null) {
                    parentScheme.setChildrenLoaded(true);
                    concepts.addAll(parentScheme.getChildrenConcepts());
                }
            }
        }
        return concepts;
    }

    ClassificationScheme jaxrConcepts2Concepts2(ClassificationScheme scheme, Collection jaxrConcepts) throws JAXRException {
        Collection concepts = new ArrayList();
        ClassificationSchemeImpl classificationScheme = (ClassificationSchemeImpl)scheme;
        if (scheme != null) {
            classificationScheme.setPredefined(true);
            this.idMap.put(classificationScheme.getKey().getId(), classificationScheme);
            if (jaxrConcepts != null) {
                for (JAXRConcept jaxrConcept : jaxrConcepts) {
                    String ckey = jaxrConcept.getId();
                    String cname = jaxrConcept.getName();
                    String cvalue = jaxrConcept.getCode();
                    String parentId = jaxrConcept.getParent();
                    List<JAXRConcept> jaxrChildConcepts = jaxrConcept.getJAXRConcept();
                    ConceptImpl concept = new ConceptImpl();
                    concept.setKey(new KeyImpl(ckey));
                    concept.setIsRetrieved(true);
                    concept.setIsLoaded(true);
                    concept.setName(new InternationalStringImpl(US_LOCALE, cname));
                    concept.setValue(cvalue);
                    concept.setPredefined(true);
                    if (jaxrChildConcepts != null && !jaxrChildConcepts.isEmpty()) {
                        concepts = this.jaxrChildConcepts2ConceptCollection(jaxrChildConcepts, concept);
                    }
                    if (concepts == null) continue;
                    for (Concept aconcept : concepts) {
                        classificationScheme.addChildConcept(aconcept);
                    }
                }
            }
        }
        return classificationScheme;
    }

    Collection jaxrChildConcepts2ConceptCollection(Collection jaxrConcepts, ConceptImpl parentConcept) throws JAXRException {
        ArrayList<ConceptImpl> concepts = new ArrayList<ConceptImpl>();
        for (JAXRConcept jconcept : jaxrConcepts) {
            String name = jconcept.getName();
            String parent = jconcept.getParent();
            String id = jconcept.getId();
            String value = jconcept.getCode();
            List<JAXRConcept> childConcepts = jconcept.getJAXRConcept();
            ConceptImpl concept = new ConceptImpl();
            concept.setKey(new KeyImpl(id));
            concept.setIsRetrieved(true);
            concept.setIsLoaded(true);
            concept.setName(new InternationalStringImpl(US_LOCALE, name));
            concept.setParentConcept(parentConcept);
            concept.setValue(value);
            if (childConcepts != null) {
                Collection collection = this.jaxrChildConcepts2ConceptCollection(childConcepts, concept);
            }
            if (concept == null) continue;
            concepts.add(concept);
            parentConcept.addChildConcept(concept);
        }
        return concepts;
    }

    Collection keysFromJAXRObjects(Collection jaxrObjects) {
        ArrayList<KeyImpl> keys = new ArrayList<KeyImpl>();
        for (Object jaxrObject : jaxrObjects) {
            KeyImpl key;
            if (jaxrObject instanceof JAXRClassificationScheme) {
                key = new KeyImpl(((JAXRClassificationScheme)jaxrObject).getId());
                keys.add(key);
                continue;
            }
            key = new KeyImpl(((JAXRConcept)jaxrObject).getParent());
            keys.add(key);
        }
        return keys;
    }

    DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(false);
        dbf.setValidating(false);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            IllegalArgumentException iae = new IllegalArgumentException(pce.getMessage());
            iae.initCause(pce);
            throw iae;
        }
    }

    Collection getAllClassificationSchemes() {
        Collection defines = this.dMap.values();
        ArrayList allSchemes = new ArrayList();
        Iterator diter = defines.iterator();
        List<JAXRClassificationScheme> schemes = null;
        while (diter.hasNext()) {
            PredefinedConcepts pConcepts = (PredefinedConcepts)diter.next();
            schemes = pConcepts.getJAXRClassificationScheme();
            Iterator<JAXRClassificationScheme> iterator = schemes.iterator();
        }
        return schemes;
    }

    Collection getClassificationSchemeByName(Collection findQualifiers, String name) throws JAXRException {
        ClassificationScheme jscheme2 = null;
        ArrayList<ClassificationScheme> allMatches = new ArrayList<ClassificationScheme>();
        for (ClassificationScheme jscheme2 : definedSchemes) {
            String pname = jscheme2.getName().getValue(US_LOCALE);
            String uname = name.toUpperCase();
            if (name.indexOf(pname) != -1 || pname.indexOf(name) != -1 || pname.equalsIgnoreCase(name)) {
                allMatches.add(jscheme2);
                return allMatches;
            }
            if (uname.indexOf(pname) != -1 || pname.indexOf(uname) != -1 || pname.equalsIgnoreCase(uname)) {
                allMatches.add(jscheme2);
                return allMatches;
            }
            char escapeChar = '\\';
            if (name.indexOf("%") == -1) {
                String mname = name + "%";
                if (this.matchPattern(mname, pname, escapeChar)) {
                    allMatches.add(jscheme2);
                    continue;
                }
                mname = "%" + name;
                if (this.matchPattern(mname, pname, escapeChar)) {
                    allMatches.add(jscheme2);
                    continue;
                }
                mname = "%" + name + "%";
                if (this.matchPattern(mname, pname, escapeChar)) {
                    allMatches.add(jscheme2);
                    continue;
                }
                mname = uname + "%";
                if (this.matchPattern(mname, pname, escapeChar)) {
                    allMatches.add(jscheme2);
                    continue;
                }
                mname = "%" + uname;
                if (this.matchPattern(mname, pname, escapeChar)) {
                    allMatches.add(jscheme2);
                    continue;
                }
                mname = "%" + uname + "%";
                if (!this.matchPattern(mname, pname, escapeChar)) continue;
                allMatches.add(jscheme2);
                continue;
            }
            if (this.matchPattern(name, pname, escapeChar)) {
                allMatches.add(jscheme2);
                continue;
            }
            if (!this.matchPattern(uname, pname, escapeChar)) continue;
            allMatches.add(jscheme2);
        }
        return allMatches;
    }

    public ClassificationScheme getClassificationSchemeById(String id) throws JAXRException {
        for (ClassificationScheme scheme : definedSchemes) {
            String cid = scheme.getKey().getId();
            if (!cid.equalsIgnoreCase(id)) continue;
            return scheme;
        }
        return null;
    }

    Concept getConceptById(Collection childConcepts, String id) throws JAXRException {
        for (Concept concept : childConcepts) {
            if (concept.getKey().getId().equalsIgnoreCase(id)) {
                return concept;
            }
            Collection children = concept.getChildrenConcepts();
            Concept found = null;
            if (children != null) {
                found = this.getConceptById(children, id);
            }
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Concept getConceptById(String id) throws JAXRException {
        this.logger.finest("Id is " + id);
        if (id == null) {
            return null;
        }
        for (ClassificationScheme scheme : definedSchemes) {
            Collection children = scheme.getChildrenConcepts();
            if (children == null) continue;
            for (Concept concept : children) {
                if (concept.getKey().getId().equalsIgnoreCase(id)) {
                    return concept;
                }
                Collection conceptChildren = concept.getChildrenConcepts();
                Concept found = null;
                if (conceptChildren != null) {
                    found = this.getConceptById(conceptChildren, id);
                }
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    JAXRClassificationScheme getClassificationSchemeForConcept(JAXRConcept concept) {
        String cid = concept.getParent();
        Collection schemes = this.getAllClassificationSchemes();
        for (JAXRClassificationScheme jscheme : schemes) {
            if (!cid.equals(jscheme.getId())) continue;
            return jscheme;
        }
        return null;
    }

    boolean hasChildren(Collection concepts, String id) {
        for (JAXRConcept pconcept : concepts) {
            String parent = pconcept.getParent();
            if (!parent.equals(id)) continue;
            return true;
        }
        return false;
    }

    boolean hasChildrenConcepts(JAXRClassificationScheme scheme) {
        List<JAXRConcept> concepts = scheme.getJAXRConcept();
        if (concepts != null) {
            return concepts.size() > 0;
        }
        return false;
    }

    Concept getConceptsByPath2(String xpath) throws JAXRException {
        String anyPath = "*";
        String anyDescendant = "//";
        String delim = "/";
        boolean escaped = false;
        String tok = null;
        ArrayList<String> tokens = new ArrayList<String>();
        if (xpath != null) {
            StringTokenizer st = new StringTokenizer(xpath, delim, true);
            boolean k = true;
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                tokens.add(tok);
            }
        } else {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("JAXRConceptsManager:Path_is_null"));
        }
        Concept concept = null;
        int i = 0;
        int numtoks = tokens.size();
        if (i < numtoks) {
            String delimOne = (String)tokens.get(i);
            ++i;
            if (delimOne.equals("/")) {
                String classificationId = (String)tokens.get(i);
                ++i;
                ClassificationScheme scheme = this.getClassificationSchemeById(classificationId);
                if (scheme == null) {
                    return null;
                }
                this.logger.finest("scheme.getName " + scheme.getName().getValue());
                Collection children = scheme.getChildrenConcepts();
                while (i < numtoks) {
                    String delimn = (String)tokens.get(i);
                    if (!delimn.equals("/") || ++i >= numtoks) continue;
                    String value = (String)tokens.get(i);
                    ++i;
                    if (children == null || (concept = this.getConceptByValue(children, value)) == null) continue;
                    this.logger.finest("FirstConcept with value" + concept.getValue());
                    children = concept.getChildrenConcepts();
                    if (children != null) continue;
                    this.logger.finest("children are null for " + concept.getValue());
                }
                return concept;
            }
        }
        return null;
    }

    Concept getConceptByValue(Collection childConcepts, String value) throws JAXRException {
        for (Concept concept : childConcepts) {
            String cvalue = concept.getValue();
            if (cvalue == null || !cvalue.equalsIgnoreCase(value)) continue;
            return concept;
        }
        return null;
    }

    Concept findConceptByValue(RegistryObject parent, String value) throws JAXRException {
        Collection children = null;
        if (parent instanceof ClassificationScheme) {
            children = ((ClassificationScheme)parent).getChildrenConcepts();
        } else if (parent instanceof Concept) {
            children = ((Concept)parent).getChildrenConcepts();
        }
        Concept concept2 = null;
        if (children != null) {
            for (Concept concept2 : children) {
                this.logger.finest("Concept in find by value" + concept2.getValue());
                String cvalue = concept2.getValue();
                if (cvalue == null || !cvalue.equalsIgnoreCase(value)) continue;
                return concept2;
            }
        } else {
            this.logger.finest("Children are null");
        }
        return null;
    }

    Collection getConceptsByPath(String xpath, char escapeChar) throws ParserConfigurationException {
        String escapeCharStr = String.valueOf(escapeChar);
        String anyPath = "*";
        String anyDescendant = "//";
        String delim = "/";
        String delims = delim + escapeCharStr;
        boolean escaped = false;
        String tok = null;
        ArrayList<String> tokens = new ArrayList<String>();
        if (xpath != null) {
            StringTokenizer st = new StringTokenizer(xpath, delims, true);
            boolean k = true;
            while (st.hasMoreTokens()) {
                tok = st.nextToken();
                tokens.add(tok);
            }
        }
        ArrayList<Object> concepts = new ArrayList<Object>();
        PredefinedConcepts predefines = (PredefinedConcepts)this.dMap.get(naics);
        Element el = null;
        int j = 0;
        Object uuid = null;
        tok = (String)tokens.get(j);
        Element firstConcept = null;
        while (j <= tokens.size()) {
            String nexttok = null;
            if (!tok.equals(delim) || ++j >= tokens.size()) break;
            nexttok = (String)tokens.get(j);
            if (nexttok.equals(delim)) {
                if (++j >= tokens.size()) break;
                tok = (String)tokens.get(j);
                if (tok.indexOf("uuid:") != -1) {
                    el = this.findElementByUUID(tok, el);
                } else {
                    if (firstConcept == null) {
                        firstConcept = el;
                    }
                    el = this.findElementByCode(tok, firstConcept);
                }
                if (++j >= tokens.size()) break;
                tok = (String)tokens.get(j);
                continue;
            }
            if (nexttok.equals(anyPath)) {
                if (nexttok.indexOf("uuid:") != -1) {
                    el = this.findElementByUUID(nexttok, el);
                } else {
                    if (firstConcept == null) {
                        firstConcept = el;
                    }
                    el = this.findElementByCode(nexttok, firstConcept);
                }
                if (++j >= tokens.size()) break;
                tok = (String)tokens.get(j);
                continue;
            }
            if (nexttok.indexOf("uuid:") != -1) {
                el = this.findElementByUUID(nexttok, el);
            } else {
                if (firstConcept == null) {
                    firstConcept = el;
                }
                el = this.findElementByCode(nexttok, firstConcept);
            }
            if (++j >= tokens.size()) break;
            tok = (String)tokens.get(j);
        }
        if (el != null) {
            Object jconcept = null;
            String tagName = el.getTagName();
            if (tagName.equals("JAXRConcept")) {
                if (jconcept == null) {
                    this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("JAXRConceptsManager:jconcept_is_null"));
                }
                concepts.add(jconcept);
                return concepts;
            }
        }
        return null;
    }

    Element findElementByUUID(String uuid, Element el) {
        NodeList nlist1 = el.getElementsByTagName("JAXRClassificationScheme");
        for (int i = 0; i < nlist1.getLength(); ++i) {
            Node n = nlist1.item(i);
            String pname = ((Element)n).getTagName();
            String id = ((Element)n).getAttribute("id");
            if (!id.equals(uuid)) continue;
            String name = ((Element)n).getAttribute("name");
            return (Element)n;
        }
        return null;
    }

    Element findElementByCode(String code, Element el) {
        NodeList nlist1 = el.getElementsByTagName("JAXRConcept");
        for (int i = 0; i < nlist1.getLength(); ++i) {
            Node n = nlist1.item(i);
            String pname = ((Element)n).getTagName();
            String ecode = ((Element)n).getAttribute("code");
            if (!ecode.equals(code)) continue;
            String name = ((Element)n).getAttribute("name");
            return (Element)n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchPattern(String patternStr, String str, char escapeChar) {
        boolean matched = false;
        String escapeCharStr = String.valueOf(escapeChar);
        String wildCards = "_%";
        String delims = wildCards + escapeCharStr;
        boolean escaped = false;
        int index = 0;
        String tok = null;
        boolean debug = false;
        try {
            if (str != null) {
                StringTokenizer st = new StringTokenizer(patternStr, delims, true);
                ArrayList<String> tokens = new ArrayList<String>();
                int k = 1;
                while (st.hasMoreTokens()) {
                    tok = st.nextToken();
                    if (debug) {
                        this.logger.finest(k++ + " matchPattern Token=" + tok);
                    }
                    tokens.add(tok);
                }
                matched = true;
                int numTokens = tokens.size();
                block8: for (int i = 0; i < numTokens; ++i) {
                    tok = (String)tokens.get(i);
                    if (tok.equals(escapeCharStr) && !escaped) {
                        escaped = true;
                        continue;
                    }
                    if (tok.equals("%") && !escaped) {
                        if (i == numTokens - 1) {
                            index = str.length();
                            continue;
                        }
                        if (i == numTokens - 1) continue;
                        int _cnt = 0;
                        ++i;
                        while (i < numTokens) {
                            tok = (String)tokens.get(i);
                            if (tok.equals(escapeCharStr) && !escaped) {
                                escaped = true;
                            } else if (!tok.equals("%") || escaped) {
                                if (tok.equals("_") && !escaped) {
                                    ++_cnt;
                                } else {
                                    int oldIndex = index;
                                    if (i == numTokens - 1) {
                                        if (str.endsWith(tok)) {
                                            index = str.length() - tok.length();
                                        } else {
                                            matched = false;
                                            if (debug) {
                                                this.logger.finest("no matched5 for token: '" + tok + "'");
                                            }
                                        }
                                    } else {
                                        index = str.indexOf(tok, index);
                                    }
                                    if (index < 0) {
                                        matched = false;
                                        if (debug) {
                                            this.logger.finest("no matched1 for token: '" + tok + "'");
                                        }
                                    } else if (index - oldIndex >= _cnt) {
                                        index += tok.length();
                                        if (debug) {
                                            this.logger.finest("matched1: " + str.substring(0, index));
                                        }
                                    } else {
                                        matched = false;
                                        if (debug) {
                                            this.logger.finest("no matched 2 for token: '" + tok + "'");
                                        }
                                    }
                                    escaped = false;
                                    continue block8;
                                }
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (tok.equals("_") && !escaped) {
                        ++index;
                        if (!debug) continue;
                        this.logger.finest("matched2: " + str.substring(0, index));
                        continue;
                    }
                    int tokLen = tok.length();
                    if (debug) {
                        this.logger.finest(index + " " + tokLen);
                    }
                    if (index + tokLen <= str.length()) {
                        String subStr = null;
                        try {
                            subStr = str.substring(index, index + tokLen);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            matched = false;
                            break;
                        }
                        if (!subStr.equalsIgnoreCase(tok)) {
                            matched = false;
                            if (!debug) break;
                            this.logger.finest("no matched3 for token: '" + tok + "'");
                            break;
                        }
                        index += tok.length();
                        if (debug) {
                            this.logger.finest("matched3: " + str.substring(0, index));
                        }
                    } else {
                        matched = false;
                        if (!debug) break;
                        this.logger.finest("no matched4 for token: '" + tok + "'");
                        break;
                    }
                    escaped = false;
                }
            }
            if (matched && index != str.length()) {
                if (debug) {
                    this.logger.finest("no match5(remainder): " + str.substring(index, str.length()));
                }
                matched = false;
            }
            if (debug) {
                this.logger.finest("JAXR:matchPattern patternStr = '" + patternStr + "' str = '" + str + "' matched = " + matched);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            matched = false;
            if (debug) {
                e.printStackTrace();
                this.logger.finest("HANDLED OUTOFBOUNDS JAXR:matchPattern patternStr = '" + patternStr + "' str = '" + str + "' matched = " + matched);
            }
        }
        finally {
            return matched;
        }
    }

    Collection doFindClassificationSchemes(Collection findQualifiers, Collection namepatterns) throws JAXRException {
        Collection matchingSchemes = null;
        for (String name : namepatterns) {
            matchingSchemes = this.getClassificationSchemeByName(findQualifiers, name);
        }
        return matchingSchemes;
    }

    void loadTaxonomies() throws JAXRException {
        String naics = taxonomyPath + "naics.xml";
        String iso3166 = taxonomyPath + "iso3166.xml";
        String unspsc = taxonomyPath + "unspsc.xml";
        String jaxrconcepts = taxonomyPath + "jaxrconcepts.xml";
        try {
            this.fileList.add(naics);
            this.fileList.add(iso3166);
            this.fileList.add(unspsc);
            this.fileList.add(jaxrconcepts);
            String userDefined = this.connection.getUserDefinedTaxonomy();
            if (userDefined != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Parsing user defined taxonomy filenames");
                }
                String space = " ";
                StringTokenizer spaceTokenizer = new StringTokenizer(userDefined, space);
                StringBuffer udBuffer = new StringBuffer();
                while (spaceTokenizer.hasMoreElements()) {
                    udBuffer.append(spaceTokenizer.nextToken());
                }
                userDefined = udBuffer.toString();
                this.logger.finest(userDefined);
                StringTokenizer tokenizer = new StringTokenizer(userDefined, "|");
                while (tokenizer.hasMoreElements()) {
                    String filename = tokenizer.nextToken();
                    if (this.fileList.contains(filename)) continue;
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("Adding filename to list to load: " + filename);
                    }
                    this.fileList.add(filename);
                }
            }
            for (final String filename : this.fileList) {
                InputStream is;
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Filename is " + filename);
                }
                if ((is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return this.getClass().getResourceAsStream(filename);
                    }
                })) == null) {
                    this.logger.finest("Could not load input stream. Try file lookup.");
                    try {
                        is = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return new FileInputStream(filename);
                                }
                                catch (FileNotFoundException fnfe) {
                                    fnfe.printStackTrace();
                                    return null;
                                }
                            }
                        });
                    }
                    catch (Throwable t) {
                        this.logger.log(Level.FINEST, t.getMessage(), t);
                    }
                }
                if (is == null) {
                    this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("JAXRConceptsManager:Could_not_load_file:_") + filename);
                    continue;
                }
                PredefinedConcepts predefines = (PredefinedConcepts)this.u.unmarshal(is);
                List<JAXRClassificationScheme> schemes = predefines.getJAXRClassificationScheme();
                if (schemes.size() <= 0) continue;
                for (int i = 0; i < schemes.size(); ++i) {
                    JAXRClassificationScheme scheme = schemes.get(i);
                    this.dMap.put(filename + i, scheme);
                    this.logger.finest("Got Scheme Success" + filename + " ");
                }
                this.logger.finest("Got Scheme Success");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/common/LocalStrings").getString("JAXRConceptsManager:Cannot_initialize:_") + e.getMessage(), (Throwable)e);
        }
    }

    Collection taxonomies2TaxonomyTree() throws JAXRException {
        Collection taxonomies = this.dMap.values();
        ArrayList<ClassificationScheme> schemes = new ArrayList<ClassificationScheme>();
        for (JAXRClassificationScheme jaxrScheme : taxonomies) {
            List<JAXRConcept> jaxrConcepts = jaxrScheme.getJAXRConcept();
            ClassificationScheme scheme = this.jaxrClassificationScheme2ClassificationScheme(jaxrScheme);
            if (scheme.getName().getValue(US_LOCALE).indexOf("unspsc") != -1) {
                scheme = this.jaxrConcepts2Concepts2(scheme, jaxrConcepts);
            } else {
                Collection collection = this.jaxrConcepts2Concepts(scheme, jaxrConcepts);
            }
            schemes.add(scheme);
        }
        return schemes;
    }

    void taxonomyTree2TaxonomyFile() throws JAXRException {
        if (definedSchemes != null) {
            this.logger.finest("Have DefinedSchemes");
            for (ClassificationScheme scheme : definedSchemes) {
                JAXRClassificationScheme jAXRClassificationScheme = this.scheme2JAXRSchemeTree(scheme);
            }
        }
    }

    JAXRClassificationScheme scheme2JAXRSchemeTree(ClassificationScheme scheme) throws JAXRException {
        if (scheme != null) {
            JAXRClassificationScheme jaxrScheme = this.classificationScheme2JAXRClassificationScheme(scheme);
            Collection children = scheme.getChildrenConcepts();
            Collection jaxrConcepts = this.concepts2JAXRConceptsTree(jaxrScheme.getId(), children);
            if (jaxrConcepts != null) {
                jaxrScheme.getJAXRConcept().addAll(jaxrConcepts);
            }
            return jaxrScheme;
        }
        return null;
    }

    Collection concepts2JAXRConceptsTree(String parentId, Collection childConcepts) throws JAXRException {
        ArrayList<JAXRConcept> jaxrConcepts = null;
        if (childConcepts != null) {
            jaxrConcepts = new ArrayList<JAXRConcept>();
            for (Concept concept : childConcepts) {
                String id = concept.getKey().getId();
                String name = concept.getName().getValue();
                String value = null;
                try {
                    value = concept.getValue();
                }
                catch (Exception ex) {
                    value = "";
                }
                Collection children = concept.getChildrenConcepts();
                JAXRConcept jconcept = null;
                jconcept.setName(name);
                jconcept.setId(id);
                jconcept.setCode(value);
                jconcept.setParent(parentId);
                Collection jconcepts = null;
                if (children != null && (jconcepts = this.concepts2JAXRConceptsTree(id, children)) != null && jconcepts.size() > 0) {
                    jconcept.getJAXRConcept().addAll(jconcepts);
                }
                if (jconcept == null) continue;
                jaxrConcepts.add(jconcept);
            }
        }
        return jaxrConcepts;
    }

    static {
        taxonomyPath = "resources/";
    }
}

