/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.customizer.CustomizerSupport;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbCollections;

public class WildFlyProperties {
    public static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String PROP_PROXY_ENABLED = "proxy_enabled";
    private static final String PROP_JAVA_PLATFORM = "java_platform";
    private static final String PROP_SOURCES = "sources";
    private static final String PROP_JAVADOCS = "javadocs";
    private static final FilenameFilter CP_FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || new File(dir, name).isDirectory();
        }
    };
    private static final String DEF_VALUE_JAVA_OPTS = "";
    private static final boolean DEF_VALUE_PROXY_ENABLED = true;
    private final InstanceProperties ip;
    private final WildflyDeploymentManager manager;
    private String username = "admin";
    private String password = "admin";
    private long updateCredentialsTimestamp;
    private static final Logger LOGGER = Logger.getLogger(WildFlyProperties.class.getName());
    private final WildflyPluginUtils.Version version;
    private final boolean wildfly;
    private final boolean servletOnly;
    private final boolean jakartaEE;

    public WildFlyProperties(WildflyDeploymentManager manager) {
        this.manager = manager;
        this.ip = manager.getInstanceProperties();
        File serverPath = new File(this.ip.getProperty("root-dir"));
        this.version = manager.getServerVersion();
        this.wildfly = manager.isWildfly();
        this.servletOnly = WildflyPluginUtils.isWildFlyServlet(serverPath);
        this.jakartaEE = WildflyPluginUtils.isWildFlyJakartaEE(serverPath);
    }

    public boolean isWildfly() {
        return this.wildfly;
    }

    public String getServerProfile() {
        if (this.ip.getProperty("config_file") == null) {
            return WildflyPluginUtils.getDefaultConfigurationFile(this.ip.getProperty("root-dir"));
        }
        return this.ip.getProperty("config_file");
    }

    public InstanceProperties getInstanceProperties() {
        return this.ip;
    }

    public WildflyPluginUtils.Version getServerVersion() {
        return this.version;
    }

    public boolean isServletOnly() {
        return this.servletOnly;
    }

    public boolean isVersion(WildflyPluginUtils.Version targetVersion) {
        return this.version != null && this.version.compareToIgnoreUpdate(targetVersion) >= 0;
    }

    public boolean isJakartaEE() {
        return this.jakartaEE;
    }

    public File getServerDir() {
        return new File(this.ip.getProperty("server-dir"));
    }

    public File getRootDir() {
        return new File(this.ip.getProperty("root-dir"));
    }

    public File getDeployDir() {
        return new File(this.ip.getProperty("deploy-dir"));
    }

    public File getLibsDir() {
        return new File(this.getServerDir(), "lib");
    }

    public boolean getProxyEnabled() {
        String val = this.ip.getProperty(PROP_PROXY_ENABLED);
        return val != null ? Boolean.valueOf(val) : true;
    }

    public void setProxyEnabled(boolean enabled) {
        this.ip.setProperty(PROP_PROXY_ENABLED, Boolean.toString(enabled));
    }

    public JavaPlatform getJavaPlatform() {
        String currentJvm = this.ip.getProperty(PROP_JAVA_PLATFORM);
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform[] installedPlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String platformName = (String)installedPlatforms[i].getProperties().get(PLAT_PROP_ANT_NAME);
            if (platformName == null || !platformName.equals(currentJvm)) continue;
            return installedPlatforms[i];
        }
        return jpm.getDefaultPlatform();
    }

    public void setJavaPlatform(JavaPlatform javaPlatform) {
        this.ip.setProperty(PROP_JAVA_PLATFORM, (String)javaPlatform.getProperties().get(PLAT_PROP_ANT_NAME));
    }

    public String getJavaOpts() {
        String val = this.ip.getProperty("java_opts");
        return val != null ? val : DEF_VALUE_JAVA_OPTS;
    }

    public void setJavaOpts(String javaOpts) {
        this.ip.setProperty("java_opts", javaOpts);
    }

    public String getModulePath(String module) {
        return this.getRootDir().getAbsolutePath() + ("/modules/system/layers/base/" + module).replace('/', File.separatorChar);
    }

    private static void addFileToList(List<URL> list, File f) {
        URL u = FileUtil.urlForArchiveOrDir((File)f);
        if (u != null) {
            list.add(u);
        }
    }

    private List<URL> selectJars(FileObject file) {
        if (file == null) {
            return Collections.EMPTY_LIST;
        }
        if (file.isData()) {
            URL url;
            if (file.isValid() && FileUtil.isArchiveFile((FileObject)file) && (url = URLMapper.findURL((FileObject)file, (int)1)) != null) {
                return Collections.singletonList(FileUtil.getArchiveRoot((URL)url));
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList<URL> result = new ArrayList<URL>();
        for (FileObject child : file.getChildren()) {
            result.addAll(this.selectJars(child));
        }
        return result;
    }

    public List<URL> getClasses() {
        ArrayList<URL> classes = new ArrayList<URL>();
        classes.addAll(this.selectJars(FileUtil.toFileObject((File)new File(this.getModulePath("jakarta")))));
        classes.addAll(this.selectJars(FileUtil.toFileObject((File)new File(this.getModulePath("javax")))));
        File glassfish = new File(this.getModulePath("org/glassfish/javax"));
        if (glassfish.exists()) {
            classes.addAll(this.selectJars(FileUtil.toFileObject((File)glassfish)));
        }
        return classes;
    }

    public List<URL> getSources() {
        String path = this.ip.getProperty(PROP_SOURCES);
        if (path == null) {
            return new ArrayList<URL>();
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setSources(List<URL> path) {
        this.ip.setProperty(PROP_SOURCES, CustomizerSupport.buildPath(path));
    }

    public List<URL> getJavadocs() {
        String path = this.ip.getProperty(PROP_JAVADOCS);
        if (path == null) {
            ArrayList<URL> list = new ArrayList<URL>();
            String eeDocs = this.getServerVersion().compareTo(WildflyPluginUtils.WILDFLY_27_0_0) >= 0 ? "docs/jakartaee10-doc-api.jar" : (this.getServerVersion().compareTo(WildflyPluginUtils.WILDFLY_21_0_0) >= 0 ? (this.isJakartaEE() ? "docs/jakartaee9-doc-api.jar" : "docs/jakartaee8-doc-api.jar") : "docs/javaee-doc-api.jar");
            File j2eeDoc = InstalledFileLocator.getDefault().locate(eeDocs, null, false);
            if (j2eeDoc != null) {
                WildFlyProperties.addFileToList(list, j2eeDoc);
            }
            return list;
        }
        return CustomizerSupport.tokenizePath(path);
    }

    public void setJavadocs(List<URL> path) {
        this.ip.setProperty(PROP_JAVADOCS, CustomizerSupport.buildPath(path));
    }

    public synchronized String getUsername() {
        this.updateCredentials();
        return this.username;
    }

    public synchronized String getPassword() {
        this.updateCredentials();
        return this.password;
    }

    private synchronized void updateCredentials() {
        File usersPropFile = new File(this.getServerDir(), "/conf/props/jmx-console-users.properties");
        long lastModified = usersPropFile.lastModified();
        if (lastModified == this.updateCredentialsTimestamp) {
            LOGGER.log(Level.FINER, "Credentials are up-to-date.");
            return;
        }
        Properties usersProps = new Properties();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(usersPropFile));){
            usersProps.load(is);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, usersPropFile + " not found.", e);
            return;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error while reading " + usersPropFile, e);
            return;
        }
        Enumeration names = NbCollections.checkedEnumerationByFilter(usersProps.propertyNames(), String.class, (boolean)false);
        if (names.hasMoreElements()) {
            this.username = (String)names.nextElement();
            this.password = usersProps.getProperty(this.username);
        }
        this.updateCredentialsTimestamp = lastModified;
    }
}

