/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.database.model.SwitchoverDataGuardAssociationDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SwitchoverDataGuardAssociationRequest
extends BmcRequest<SwitchoverDataGuardAssociationDetails> {
    private String databaseId;
    private String dataGuardAssociationId;
    private SwitchoverDataGuardAssociationDetails switchoverDataGuardAssociationDetails;
    private String ifMatch;

    public String getDatabaseId() {
        return this.databaseId;
    }

    public String getDataGuardAssociationId() {
        return this.dataGuardAssociationId;
    }

    public SwitchoverDataGuardAssociationDetails getSwitchoverDataGuardAssociationDetails() {
        return this.switchoverDataGuardAssociationDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public SwitchoverDataGuardAssociationDetails getBody$() {
        return this.switchoverDataGuardAssociationDetails;
    }

    public Builder toBuilder() {
        return new Builder().databaseId(this.databaseId).dataGuardAssociationId(this.dataGuardAssociationId).switchoverDataGuardAssociationDetails(this.switchoverDataGuardAssociationDetails).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseId=").append(String.valueOf(this.databaseId));
        sb.append(",dataGuardAssociationId=").append(String.valueOf(this.dataGuardAssociationId));
        sb.append(",switchoverDataGuardAssociationDetails=").append(String.valueOf((Object)this.switchoverDataGuardAssociationDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SwitchoverDataGuardAssociationRequest)) {
            return false;
        }
        SwitchoverDataGuardAssociationRequest other = (SwitchoverDataGuardAssociationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseId, other.databaseId) && Objects.equals(this.dataGuardAssociationId, other.dataGuardAssociationId) && Objects.equals((Object)this.switchoverDataGuardAssociationDetails, (Object)other.switchoverDataGuardAssociationDetails) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseId == null ? 43 : this.databaseId.hashCode());
        result = result * 59 + (this.dataGuardAssociationId == null ? 43 : this.dataGuardAssociationId.hashCode());
        result = result * 59 + (this.switchoverDataGuardAssociationDetails == null ? 43 : this.switchoverDataGuardAssociationDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseId = null;
        private String dataGuardAssociationId = null;
        private SwitchoverDataGuardAssociationDetails switchoverDataGuardAssociationDetails = null;
        private String ifMatch = null;

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder dataGuardAssociationId(String dataGuardAssociationId) {
            this.dataGuardAssociationId = dataGuardAssociationId;
            return this;
        }

        public Builder switchoverDataGuardAssociationDetails(SwitchoverDataGuardAssociationDetails switchoverDataGuardAssociationDetails) {
            this.switchoverDataGuardAssociationDetails = switchoverDataGuardAssociationDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SwitchoverDataGuardAssociationRequest o) {
            this.databaseId(o.getDatabaseId());
            this.dataGuardAssociationId(o.getDataGuardAssociationId());
            this.switchoverDataGuardAssociationDetails(o.getSwitchoverDataGuardAssociationDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SwitchoverDataGuardAssociationRequest build() {
            SwitchoverDataGuardAssociationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(SwitchoverDataGuardAssociationDetails body) {
            this.switchoverDataGuardAssociationDetails(body);
            return this;
        }

        public SwitchoverDataGuardAssociationRequest buildWithoutInvocationCallback() {
            SwitchoverDataGuardAssociationRequest request = new SwitchoverDataGuardAssociationRequest();
            request.databaseId = this.databaseId;
            request.dataGuardAssociationId = this.dataGuardAssociationId;
            request.switchoverDataGuardAssociationDetails = this.switchoverDataGuardAssociationDetails;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

