/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.bugtracking.commons.FindTypesSupport;
import org.netbeans.modules.bugtracking.commons.StackTraceSupport;
import org.netbeans.modules.bugtracking.commons.Support;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.commons.WebUrlHyperlinkSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public final class HyperlinkSupport {
    private static final HyperlinkSupport instance = new HyperlinkSupport();
    static final String STACKTRACE_ATTRIBUTE = "attribute.stacktrace.link";
    static final String TYPE_ATTRIBUTE = "attribute.type.link";
    static final String URL_ATTRIBUTE = "attribute.url.link";
    public static final String LINK_ATTRIBUTE = "attribute.simple.link";
    private final MotionListener motionListener;
    private final java.awt.event.MouseListener mouseListener;
    private final RequestProcessor rp = new RequestProcessor("Bugtracking hyperlinks", 50);
    private static final String REGISTER_TASK = "hyperlink.task";
    private final ContainerListener regListener = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            while ((c = c.getParent()) != null) {
                if (!(c instanceof TopComponent)) continue;
                RequestProcessor.Task t = (RequestProcessor.Task)((TopComponent)c).getClientProperty((Object)HyperlinkSupport.REGISTER_TASK);
                if (t == null) break;
                t.schedule(1000);
                break;
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
        }
    };
    private final RegisterTask registerTask = new RegisterTask();

    private HyperlinkSupport() {
        this.motionListener = new MotionListener();
        this.mouseListener = new MouseListener();
    }

    public static HyperlinkSupport getInstance() {
        return instance;
    }

    public void register(Component c) {
        this.registerChildren(c, null);
    }

    public void register(final TopComponent tc, final IssueLinker issueLinker) {
        tc.removeContainerListener(this.regListener);
        tc.addContainerListener(this.regListener);
        RequestProcessor.Task task = this.rp.create(new Runnable(){
            final /* synthetic */ HyperlinkSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.registerChildren((Component)tc, issueLinker);
            }
        });
        tc.putClientProperty((Object)REGISTER_TASK, (Object)task);
        task.schedule(1000);
    }

    private void registerChildren(Component c, IssueLinker issueLinker) {
        JTextPane tp;
        if (c instanceof Container) {
            Component[] components;
            Container container = (Container)c;
            container.removeContainerListener(this.regListener);
            container.addContainerListener(this.regListener);
            for (Component cmp : components = container.getComponents()) {
                this.registerChildren(cmp, issueLinker);
            }
        }
        if (c instanceof JTextPane && !(tp = (JTextPane)c).isEditable()) {
            this.registerTask.add(tp, issueLinker);
        }
    }

    private void registerForStacktraces(JTextPane pane) {
        pane.removeMouseMotionListener(this.motionListener);
        StackTraceSupport.register(pane);
        pane.removeMouseMotionListener(this.motionListener);
        pane.addMouseMotionListener(this.motionListener);
    }

    private void registerForTypes(JTextPane pane) {
        pane.removeMouseMotionListener(this.motionListener);
        FindTypesSupport.getInstance().register(pane);
        pane.removeMouseMotionListener(this.motionListener);
        pane.addMouseMotionListener(this.motionListener);
    }

    private void registerForURLs(JTextPane pane) {
        pane.removeMouseMotionListener(this.motionListener);
        WebUrlHyperlinkSupport.register(pane);
        pane.removeMouseMotionListener(this.motionListener);
        pane.addMouseMotionListener(this.motionListener);
    }

    public void registerLink(final JTextPane pane, final int[] pos, final Link link) {
        pane.removeMouseMotionListener(this.motionListener);
        this.rp.post(new Runnable(){
            final /* synthetic */ HyperlinkSupport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.registerLinkIntern(pane, pos, link);
                pane.removeMouseMotionListener(this.this$0.motionListener);
                pane.addMouseMotionListener(this.this$0.motionListener);
            }
        });
    }

    private void registerForIssueLinks(JTextPane pane, Link issueLink, IssueRefProvider issueIdProvider) {
        pane.removeMouseMotionListener(this.motionListener);
        try {
            String text = "";
            try {
                text = pane.getStyledDocument().getText(0, pane.getStyledDocument().getLength());
            }
            catch (BadLocationException ex) {
                Support.LOG.log(Level.INFO, null, ex);
            }
            this.registerLinkIntern(pane, issueIdProvider.getIssueRefSpans(text), issueLink);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        pane.addMouseMotionListener(this.motionListener);
    }

    private void registerLinkIntern(final JTextPane pane, final int[] pos, final Link link) {
        final StyledDocument doc = pane.getStyledDocument();
        if (pos.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ HyperlinkSupport this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
                    Style hlStyle = doc.addStyle("regularBlue-link", defStyle);
                    hlStyle.addAttribute(HyperlinkSupport.LINK_ATTRIBUTE, link);
                    StyleConstants.setForeground(hlStyle, UIUtils.getLinkColor());
                    StyleConstants.setUnderline(hlStyle, true);
                    for (int i = 0; i < pos.length; i += 2) {
                        int off = pos[i];
                        int length = pos[i + 1] - pos[i];
                        doc.setCharacterAttributes(off, length, hlStyle, true);
                    }
                    pane.removeMouseListener(this.this$0.mouseListener);
                    pane.addMouseListener(this.this$0.mouseListener);
                }
            });
        }
    }

    public static interface Link {
        public void onClick(String var1);
    }

    public static interface IssueRefProvider {
        public int[] getIssueRefSpans(CharSequence var1);
    }

    private class MotionListener
    extends MouseMotionAdapter {
        private MotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTextPane pane = (JTextPane)e.getSource();
            StyledDocument doc = pane.getStyledDocument();
            Element elem = doc.getCharacterElement(pane.viewToModel(e.getPoint()));
            AttributeSet as = elem.getAttributes();
            if (StyleConstants.isUnderline(as)) {
                pane.setCursor(new Cursor(12));
            } else {
                pane.setCursor(new Cursor(0));
            }
        }
    }

    public static interface IssueLinker
    extends Link,
    IssueRefProvider {
    }

    private class RegisterTask
    implements Runnable {
        private final ConcurrentLinkedQueue<R> toregister = new ConcurrentLinkedQueue();
        private final RequestProcessor.Task task;

        private RegisterTask() {
            this.task = HyperlinkSupport.this.rp.create((Runnable)this);
        }

        void add(JTextPane tp, IssueLinker issueLinker) {
            this.toregister.add(new R(tp, issueLinker));
            this.task.schedule(300);
        }

        @Override
        public void run() {
            R r;
            LinkedList<R> rs = new LinkedList<R>();
            while ((r = this.toregister.poll()) != null) {
                rs.add(r);
            }
            for (R reg : rs) {
                HyperlinkSupport.this.registerForStacktraces(reg.tp);
                HyperlinkSupport.this.registerForTypes(reg.tp);
                HyperlinkSupport.this.registerForURLs(reg.tp);
                if (reg.issueLinker == null) continue;
                HyperlinkSupport.this.registerForIssueLinks(reg.tp, reg.issueLinker, reg.issueLinker);
            }
        }

        private class R {
            private final JTextPane tp;
            private final IssueLinker issueLinker;

            public R(JTextPane tp, IssueLinker issueLinker) {
                this.tp = tp;
                this.issueLinker = issueLinker;
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                JTextPane pane;
                StyledDocument doc;
                Element elem;
                AttributeSet as;
                Link link;
                if (SwingUtilities.isLeftMouseButton(e) && (link = (Link)(as = (elem = (doc = (pane = (JTextPane)e.getSource()).getStyledDocument()).getCharacterElement(pane.viewToModel(e.getPoint()))).getAttributes()).getAttribute(HyperlinkSupport.LINK_ATTRIBUTE)) != null) {
                    link.onClick(elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset()));
                }
            }
            catch (Exception ex) {
                Support.LOG.log(Level.SEVERE, null, ex);
            }
        }
    }
}

