/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter.libinstaller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.pluginimporter.libinstaller.Bundle;
import org.netbeans.modules.autoupdate.pluginimporter.libinstaller.InstallLibraryTask;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;

public class JUnitLibraryInstaller {
    private static final String JUNIT_LIB = "org.netbeans.modules.junitlib";
    private static final String JUNIT_MODULE = "org.netbeans.modules.junit";
    private static final Logger LOG = Logger.getLogger(JUnitLibraryInstaller.class.getName());

    public static void install(boolean silent) {
        UpdateElement jUnitElement;
        UpdateUnit jUnitMod;
        Map<String, UpdateUnit> modules = JUnitLibraryInstaller.findModules(JUNIT_LIB, JUNIT_MODULE);
        if (modules.size() < 2) {
            LOG.finer("May be first start, when no update lists have yet been downloaded.");
            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                try {
                    p.refresh(null, true);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "While refreshing " + p + " thrown " + ex, ex);
                }
            }
            modules = JUnitLibraryInstaller.findModules(JUNIT_LIB, JUNIT_MODULE);
        }
        if ((jUnitMod = modules.get(JUNIT_MODULE)) == null) {
            LOG.fine("No org.netbeans.modules.junit found. Probably a network problem.");
            return;
        }
        if (jUnitMod.getInstalled() == null) {
            LOG.fine("org.netbeans.modules.junit didn't installed, no needed to install org.netbeans.modules.junitlib");
            return;
        }
        UpdateUnit jUnitLib = modules.get(JUNIT_LIB);
        if (jUnitLib == null) {
            LOG.fine("No org.netbeans.modules.junitlib found. Probably a network problem.");
            return;
        }
        if (jUnitLib.getInstalled() != null) {
            LOG.fine("org.netbeans.modules.junitlib already installed, no needed to install again.");
            return;
        }
        assert (!jUnitLib.getAvailableUpdates().isEmpty()) : "Updates found for " + jUnitLib;
        if (jUnitLib.getAvailableUpdates().isEmpty()) {
            LOG.log(Level.INFO, "No updates found for {0}", jUnitLib);
            return;
        }
        OperationContainer oc = OperationContainer.createForInstall();
        if (!oc.canBeAdded(jUnitLib, jUnitElement = (UpdateElement)jUnitLib.getAvailableUpdates().get(0))) {
            LOG.log(Level.INFO, "Could not add {0} to updates", jUnitElement);
            return;
        }
        for (UpdateElement req : oc.add(jUnitElement).getRequiredElements()) {
            oc.add(req);
        }
        if (silent) {
            try {
                JUnitLibraryInstaller.install((OperationContainer<InstallSupport>)oc, jUnitElement, jUnitLib, true);
            }
            catch (OperationException ex) {
                LOG.log(Level.INFO, "While installing " + jUnitLib + " thrown " + (Object)((Object)ex), ex);
                if (OperationException.ERROR_TYPE.WRITE_PERMISSION.equals((Object)ex.getErrorType())) {
                    JUnitLibraryInstaller.notifyWarning((OperationContainer<InstallSupport>)oc, jUnitElement, jUnitLib);
                }
            }
        } else {
            NotifyDescriptor.Confirmation question = new NotifyDescriptor.Confirmation((Object)Bundle.download_question(), Bundle.download_title(), 2);
            question.setOptions(new Object[]{Bundle.accept_button(), NotifyDescriptor.CANCEL_OPTION});
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)question) == Bundle.accept_button()) {
                if (!PluginManager.openInstallWizard((OperationContainer)oc)) {
                    LOG.info("user canceled JUnit install wizard");
                }
            } else {
                LOG.info("user denied JUnit installation");
            }
        }
    }

    private static void install(OperationContainer<InstallSupport> oc, UpdateElement jUnitElement, UpdateUnit jUnitLib, boolean useUserdirAsFallback) throws OperationException {
        LOG.log(Level.FINE, "Try to download {0}", jUnitElement);
        ProgressHandle downloadHandle = ProgressHandleFactory.createHandle((String)Bundle.download_handle());
        InstallSupport.Validator validator = ((InstallSupport)oc.getSupport()).doDownload(downloadHandle, null, useUserdirAsFallback);
        ProgressHandle validateHandle = ProgressHandleFactory.createHandle((String)Bundle.validate_handle());
        InstallSupport.Installer installer = ((InstallSupport)oc.getSupport()).doValidate(validator, validateHandle);
        LOG.log(Level.FINE, "Try to install {0}", jUnitElement);
        ProgressHandle installHandle = ProgressHandleFactory.createHandle((String)Bundle.install_handle());
        OperationSupport.Restarter restarter = ((InstallSupport)oc.getSupport()).doInstall(installer, installHandle);
        assert (restarter == null) : "Not need to restart while installing " + jUnitLib;
        LOG.log(Level.FINE, "Done {0}", jUnitElement);
    }

    private static void notifyWarning(final OperationContainer<InstallSupport> oc, final UpdateElement jUnitElement, final UpdateUnit jUnitLib) {
        ActionListener onMouseClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable r = new Runnable(){
                    final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        try {
                            JUnitLibraryInstaller.install((OperationContainer<InstallSupport>)oc, jUnitElement, jUnitLib, true);
                        }
                        catch (OperationException ex) {
                            LOG.log(Level.INFO, "While installing " + jUnitLib + " thrown " + (Object)((Object)ex), ex);
                        }
                    }
                };
                JUnitLibraryInstaller.showWritePermissionDialog(r);
            }
        };
        String title = Bundle.writePermission();
        String description = Bundle.showDetails();
        NotificationDisplayer.getDefault().notify(title, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/pluginimporter/resources/warning.gif", (boolean)false), description, onMouseClickAction, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
    }

    private static void showWritePermissionDialog(Runnable installAnyway) {
        JButton cancel = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancel, (String)Bundle.cancel());
        JButton install = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)install, (String)Bundle.installAnyway());
        DialogDescriptor descriptor = new DialogDescriptor((Object)new JLabel(Bundle.writePermissionDetails()), Bundle.warning(), true, (Object[])new JButton[]{install, cancel}, null, 0, null, null);
        descriptor.setMessageType(3);
        descriptor.setClosingOptions(null);
        DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        if (install.equals(descriptor.getValue())) {
            LOG.info("user install JUnit into userdir anyway");
            InstallLibraryTask.RP.post(installAnyway);
        } else {
            LOG.info("user canceled install JUnit into userdir");
        }
    }

    private static Map<String, UpdateUnit> findModules(String ... codeNames) {
        List<String> names = Arrays.asList(codeNames);
        HashMap<String, UpdateUnit> res = new HashMap<String, UpdateUnit>();
        for (UpdateUnit unit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!names.contains(unit.getCodeName())) continue;
            res.put(unit.getCodeName(), unit);
            if (res.size() != names.size()) continue;
            return res;
        }
        return res;
    }
}

