/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.hyperlink.BeansRefHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.Bundle;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.ElementSeekerTask;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;
import org.netbeans.modules.spring.java.PropertyFinder;

public class PHyperlinkProcessor
extends HyperlinkProcessor {
    private BeansRefHyperlinkProcessor beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(true);

    @Override
    public void process(HyperlinkEnv env) {
        String attribName = env.getAttribName();
        if (env.getType().isValueHyperlink()) {
            if (attribName.endsWith("-ref")) {
                this.beansRefHyperlinkProcessor.process(env);
            }
        } else if (env.getType().isAttributeHyperlink()) {
            String className;
            String propName = ContextUtilities.getLocalNameFromTag(attribName);
            if (propName.endsWith("-ref")) {
                propName = propName.substring(0, propName.indexOf("-ref"));
            }
            if ((className = new BeanClassFinder(env.getBeanAttributes(), env.getFileObject()).findImplementationClass(false)) == null) {
                return;
            }
            JavaSource js = JavaUtils.getJavaSource(env.getFileObject());
            if (js == null) {
                return;
            }
            ClassSeekerTask classSeekerTask = new ClassSeekerTask(js, className, propName);
            classSeekerTask.runAsUserTask();
            if (!classSeekerTask.wasElementFound() && SourceUtils.isScanInProgress()) {
                ScanDialog.runWhenScanFinished((Runnable)classSeekerTask, (String)Bundle.title_attribute_searching());
            }
        }
    }

    @Override
    public int[] getSpan(HyperlinkEnv env) {
        if (env.getType().isValueHyperlink()) {
            return super.getSpan(env);
        }
        if (env.getType().isAttributeHyperlink()) {
            return new int[]{env.getTokenStartOffset(), env.getTokenEndOffset()};
        }
        return null;
    }

    private class ClassSeekerTask
    extends ElementSeekerTask {
        private final String className;
        private final String propName;

        public ClassSeekerTask(JavaSource javaSource, String className, String propName) {
            super(javaSource);
            this.className = className;
            this.propName = propName;
        }

        public void run(CompilationController cc) throws Exception {
            TypeElement type = JavaUtils.findClassElementByBinaryName(this.className, cc);
            if (type == null) {
                return;
            }
            this.elementFound.set(true);
            Property[] props = new PropertyFinder(type.asType(), this.propName, cc.getElementUtilities(), MatchType.PREFIX).findProperties();
            if (props.length > 0 && props[0].getSetter() != null) {
                ElementOpen.open((ClasspathInfo)cc.getClasspathInfo(), (Element)props[0].getSetter());
            }
        }
    }
}

