/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DefaultSourceMap
extends SourceFileMap {
    private J2eeModuleProvider provider;
    private HashSet rootFiles = new HashSet();

    public DefaultSourceMap(J2eeModuleProvider provider) {
        this.provider = provider;
        FileObject[] roots = provider.getSourceRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i] == null) continue;
            this.rootFiles.add(FileUtil.toFile((FileObject)roots[i]));
        }
    }

    @Override
    public String getContextName() {
        return this.provider.getDeploymentName();
    }

    @Override
    public FileObject[] getSourceRoots() {
        return this.provider.getSourceRoots();
    }

    @Override
    public File getEnterpriseResourceDir() {
        return this.provider.getJ2eeModule().getResourceDirectory();
    }

    @Override
    public File[] getEnterpriseResourceDirs() {
        ArrayList<File> result = new ArrayList<File>();
        result.add(this.provider.getJ2eeModule().getResourceDirectory());
        if (this.provider instanceof J2eeApplicationProvider) {
            J2eeApplicationProvider jap = (J2eeApplicationProvider)this.provider;
            J2eeModuleProvider[] children = jap.getChildModuleProviders();
            for (int i = 0; i < children.length; ++i) {
                result.add(children[i].getJ2eeModule().getResourceDirectory());
            }
        }
        return result.toArray(new File[0]);
    }

    @Override
    public boolean add(String distributionPath, FileObject sourceFile) {
        return false;
    }

    @Override
    public FileObject remove(String distributionPath) {
        return null;
    }

    @Override
    public FileObject[] findSourceFile(String distributionPath) {
        ArrayList<FileObject> ret = new ArrayList<FileObject>();
        FileObject[] roots = this.getSourceRoots();
        String path = distributionPath.startsWith("/") ? distributionPath.substring(1) : distributionPath;
        for (int i = 0; i < roots.length; ++i) {
            FileObject fo = roots[i].getFileObject(path);
            if (fo == null) continue;
            ret.add(fo);
        }
        return ret.toArray(new FileObject[0]);
    }

    @Override
    public File getDistributionPath(FileObject sourceFile) {
        for (File rootFile : this.rootFiles) {
            FileObject root = FileUtil.toFileObject((File)rootFile);
            String relative = FileUtil.getRelativePath((FileObject)root, (FileObject)sourceFile);
            if (relative == null || relative.trim().equals("")) continue;
            return new File(relative);
        }
        return null;
    }
}

