/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.ReplaceConstructorWithFactoryRefactoring;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.ReplaceConstructorWithBuilderPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.spi.java.hints.support.TransformationSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ReplaceConstructorWithFactoryPlugin
extends JavaRefactoringPlugin {
    private final ReplaceConstructorWithFactoryRefactoring refactoring;
    private final AtomicBoolean cancel = new AtomicBoolean();
    private final TreePathHandle treePathHandle;

    public ReplaceConstructorWithFactoryPlugin(ReplaceConstructorWithFactoryRefactoring replaceConstructorRefactoring) {
        this.refactoring = replaceConstructorRefactoring;
        this.treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Element constr = this.treePathHandle.resolveElement((CompilationInfo)javac);
        if (constr.getKind() != ElementKind.CONSTRUCTOR) {
            return new Problem(true, Bundle.ERR_ReplaceWrongType());
        }
        Element enclosingElement = constr.getEnclosingElement();
        if (!enclosingElement.getModifiers().contains((Object)Modifier.STATIC) && enclosingElement.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return new Problem(true, Bundle.ERR_ReplaceWrongInnerType());
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        String factoryName = this.refactoring.getFactoryName();
        if (factoryName == null || factoryName.length() == 0) {
            return new Problem(true, "No factory method name specified.");
        }
        if (!SourceVersion.isIdentifier(factoryName)) {
            return new Problem(true, factoryName + " is not an identifier.");
        }
        return null;
    }

    public final Problem prepare(RefactoringElementsBag refactoringElements) {
        this.cancel.set(false);
        final TreePathHandle constr = this.treePathHandle;
        final String[] ruleCode = new String[1];
        final String[] toCode = new String[1];
        try {
            ModificationResult mod = JavaSource.forFileObject((FileObject)constr.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){
                final /* synthetic */ ReplaceConstructorWithFactoryPlugin this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - void declaration
                 */
                public void run(WorkingCopy parameter) throws Exception {
                    void var15_20;
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath constrPath = constr.resolve((CompilationInfo)parameter);
                    if (constrPath == null || constrPath.getLeaf().getKind() != Tree.Kind.METHOD) {
                        return;
                    }
                    MethodTree constructor = (MethodTree)constrPath.getLeaf();
                    TypeElement parent = (TypeElement)parameter.getTrees().getElement(constrPath.getParentPath());
                    TreeMaker make = parameter.getTreeMaker();
                    StringBuilder parameters = new StringBuilder();
                    StringBuilder constraints = new StringBuilder();
                    StringBuilder realParameters = new StringBuilder();
                    int count = 1;
                    for (VariableTree variableTree : constructor.getParameters()) {
                        if (count > 1) {
                            parameters.append(", ");
                            constraints.append(" && ");
                            realParameters.append(", ");
                        }
                        realParameters.append(variableTree.getName());
                        parameters.append("$").append(count);
                        constraints.append("$").append(count).append(" instanceof ").append(parameter.getTrees().getTypeMirror(new TreePath(new TreePath(constrPath, variableTree), variableTree.getType())));
                        ++count;
                    }
                    EnumSet<Modifier> factoryMods = EnumSet.of(Modifier.STATIC);
                    factoryMods.addAll(constructor.getModifiers().getFlags());
                    ClassTree classTree = (ClassTree)constrPath.getParentPath().getLeaf();
                    List<? extends TypeParameterTree> typeParameters = classTree.getTypeParameters();
                    LinkedList<IdentifierTree> arguments = new LinkedList<IdentifierTree>();
                    for (VariableTree variableTree : constructor.getParameters()) {
                        arguments.add(make.Identifier((CharSequence)variableTree.getName()));
                    }
                    LinkedList<IdentifierTree> typeArguments = new LinkedList<IdentifierTree>();
                    for (TypeParameterTree typeParameterTree : typeParameters) {
                        typeArguments.add(make.Identifier((CharSequence)typeParameterTree.getName()));
                    }
                    ExpressionTree expressionTree = make.QualIdent((Element)parent);
                    if (!typeArguments.isEmpty()) {
                        ExpressionTree expressionTree2 = (ExpressionTree)((Object)make.ParameterizedType((Tree)expressionTree, typeArguments));
                    }
                    BlockTree blockTree = make.Block(Collections.singletonList(make.Return((ExpressionTree)make.NewClass(null, Collections.EMPTY_LIST, (ExpressionTree)var15_20, arguments, null))), false);
                    MethodTree factory = make.Method(make.Modifiers(factoryMods), (CharSequence)this.this$0.refactoring.getFactoryName(), (Tree)var15_20, typeParameters, constructor.getParameters(), Collections.emptyList(), blockTree, null);
                    parameter.rewrite(constrPath.getParentPath().getLeaf(), (Tree)GeneratorUtilities.get((WorkingCopy)parameter).insertClassMember(classTree, (Tree)factory));
                    EnumSet<Modifier> constructorMods = EnumSet.of(Modifier.PRIVATE);
                    parameter.rewrite((Tree)constructor.getModifiers(), (Tree)make.Modifiers(constructorMods));
                    StringBuilder rule = new StringBuilder();
                    boolean hasTypeParams = !parent.getTypeParameters().isEmpty();
                    rule.append("new ").append(parent.getQualifiedName()).append(hasTypeParams ? "<$modifiers$>(" : "(").append((CharSequence)parameters).append(")");
                    if (constraints.length() > 0) {
                        rule.append(" :: ").append((CharSequence)constraints);
                    }
                    ruleCode[0] = rule.toString();
                    toCode[0] = String.valueOf(parent.getQualifiedName()) + (hasTypeParams ? ".<$modifiers$>" : ".") + this.this$0.refactoring.getFactoryName() + "(" + String.valueOf(parameters) + ")";
                    toCode[0] = toCode[0] + ";;";
                }
            });
            if (ruleCode[0] == null) {
                return new Problem(true, Bundle.ERR_ReplaceWrongType());
            }
            ArrayList<ModificationResult> results = new ArrayList<ModificationResult>();
            results.add(mod);
            results.addAll(TransformationSupport.create((String)(ruleCode[0] + " => " + toCode[0])).setCancel(this.cancel).processAllProjects());
            ReplaceConstructorWithBuilderPlugin.createAndAddElements(this.refactoring, refactoringElements, results);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    @Override
    public void cancelRequest() {
        this.cancel.set(true);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        ClasspathInfo cpInfo = this.getClasspathInfo(this.refactoring);
        return JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
    }
}

