/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensearch.sql.calcite.utils.binning.SpanInfo;
import org.opensearch.sql.calcite.utils.binning.SpanType;

public class SpanParser {
    private static final Pattern LOG_PATTERN = Pattern.compile("^(\\d*\\.?\\d*)?log(\\d+\\.?\\d*)$");
    private static final Map<String, String> NORMALIZED_UNITS = new HashMap<String, String>();
    private static final Map<String, String> UNIT_LOOKUP = new HashMap<String, String>();

    public static SpanInfo parse(String spanStr) {
        String lowerSpanStr;
        switch (lowerSpanStr = spanStr.toLowerCase(Locale.ROOT).trim()) {
            case "log10": {
                return new SpanInfo(SpanType.LOG, 1.0, 10.0);
            }
            case "log2": {
                return new SpanInfo(SpanType.LOG, 1.0, 2.0);
            }
            case "loge": 
            case "ln": {
                return new SpanInfo(SpanType.LOG, 1.0, Math.E);
            }
        }
        Matcher logMatcher = LOG_PATTERN.matcher(lowerSpanStr);
        if (logMatcher.matches()) {
            return SpanParser.parseLogSpan(logMatcher);
        }
        String timeUnit = SpanParser.extractTimeUnit(spanStr);
        if (timeUnit != null) {
            return SpanParser.parseTimeSpan(spanStr, timeUnit);
        }
        return SpanParser.parseNumericSpan(spanStr);
    }

    private static SpanInfo parseLogSpan(Matcher logMatcher) {
        String coeffStr = logMatcher.group(1);
        String baseStr = logMatcher.group(2);
        double coefficient = coeffStr == null || coeffStr.isEmpty() ? 1.0 : Double.parseDouble(coeffStr);
        double base = Double.parseDouble(baseStr);
        if (base <= 1.0) {
            throw new IllegalArgumentException("Log base must be > 1.0, got: " + base);
        }
        if (coefficient <= 0.0) {
            throw new IllegalArgumentException("Log coefficient must be > 0.0, got coefficient=" + coefficient + ", base=" + base);
        }
        return new SpanInfo(SpanType.LOG, coefficient, base);
    }

    private static SpanInfo parseTimeSpan(String spanStr, String timeUnit) {
        String valueStr = spanStr.substring(0, spanStr.length() - timeUnit.length());
        double value = Double.parseDouble(valueStr);
        return new SpanInfo(SpanType.TIME, value, timeUnit);
    }

    private static SpanInfo parseNumericSpan(String spanStr) {
        try {
            double value = Double.parseDouble(spanStr);
            return new SpanInfo(SpanType.NUMERIC, value, null);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid span format: " + spanStr);
        }
    }

    public static String extractTimeUnit(String spanStr) {
        String longestMatch = null;
        for (String unit : UNIT_LOOKUP.keySet()) {
            int unitStartPos;
            boolean matches = unit.equals("M") || unit.equals("m") || unit.equals("us") || unit.equals("cs") || unit.equals("ds") ? spanStr.endsWith(unit) : spanStr.toLowerCase(Locale.ROOT).endsWith(unit.toLowerCase(Locale.ROOT));
            if (!matches || (unitStartPos = spanStr.length() - unit.length()) != 0 && Character.isLetter(spanStr.charAt(unitStartPos - 1)) || longestMatch != null && unit.length() <= longestMatch.length()) continue;
            longestMatch = unit;
        }
        return longestMatch != null ? UNIT_LOOKUP.get(longestMatch) : null;
    }

    public static String getNormalizedUnit(String unit) {
        return NORMALIZED_UNITS.getOrDefault(unit, unit);
    }

    static {
        NORMALIZED_UNITS.putAll(Map.ofEntries(Map.entry("seconds", "s"), Map.entry("second", "s"), Map.entry("secs", "s"), Map.entry("sec", "s"), Map.entry("s", "s"), Map.entry("minutes", "m"), Map.entry("minute", "m"), Map.entry("mins", "m"), Map.entry("min", "m"), Map.entry("m", "m"), Map.entry("hours", "h"), Map.entry("hour", "h"), Map.entry("hrs", "h"), Map.entry("hr", "h"), Map.entry("h", "h"), Map.entry("days", "d"), Map.entry("day", "d"), Map.entry("d", "d"), Map.entry("months", "months"), Map.entry("month", "months"), Map.entry("mon", "months"), Map.entry("M", "months"), Map.entry("ms", "ms"), Map.entry("us", "us"), Map.entry("cs", "cs"), Map.entry("ds", "ds")));
        for (String unit : NORMALIZED_UNITS.keySet()) {
            if (unit.equals("M") || unit.equals("m") || unit.equals("us") || unit.equals("cs") || unit.equals("ds")) {
                UNIT_LOOKUP.put(unit, unit);
                continue;
            }
            UNIT_LOOKUP.put(unit.toLowerCase(Locale.ROOT), unit);
        }
    }
}

