/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.id;

import java.util.Objects;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;

public final class AsynchronousSearchId {
    private final AsynchronousSearchContextId asynchronousSearchContextId;
    private final String node;
    private final long taskId;

    public AsynchronousSearchId(String node, long taskId, AsynchronousSearchContextId asynchronousSearchContextId) {
        this.node = node;
        this.taskId = taskId;
        this.asynchronousSearchContextId = asynchronousSearchContextId;
    }

    public AsynchronousSearchContextId getAsynchronousSearchContextId() {
        return this.asynchronousSearchContextId;
    }

    public String getNode() {
        return this.node;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public String toString() {
        return "[" + this.node + "][" + this.taskId + "][" + String.valueOf(this.asynchronousSearchContextId) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.asynchronousSearchContextId, this.node, this.taskId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsynchronousSearchId asynchronousSearchId = (AsynchronousSearchId)o;
        return asynchronousSearchId.asynchronousSearchContextId.equals(this.asynchronousSearchContextId) && asynchronousSearchId.node.equals(this.node) && asynchronousSearchId.taskId == this.taskId;
    }
}

