"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPlugin = void 0;
var _operators = require("rxjs/operators");
var _routes = require("./routes");
var _opensearch_security_configuration_plugin = _interopRequireDefault(require("./backend/opensearch_security_configuration_plugin"));
var _opensearch_security_plugin = _interopRequireDefault(require("./backend/opensearch_security_plugin"));
var _security_cookie = require("./session/security_cookie");
var _opensearch_security_client = require("./backend/opensearch_security_client");
var _tenant_index = require("./multitenancy/tenant_index");
var _auth_handler_factory = require("./auth/auth_handler_factory");
var _routes2 = require("./multitenancy/routes");
var _auth_type_routes = require("./routes/auth_type_routes");
var _core = require("../../../src/core/server/saved_objects/migrations/core");
var _saved_objects_wrapper = require("./saved_objects/saved_objects_wrapper");
var _tenant_resolver = require("./multitenancy/tenant_resolver");
var _readonly_service = require("./readonly/readonly_service");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          *   Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   Licensed under the Apache License, Version 2.0 (the "License").
                                                                                                                                                                                                                                                                                                                          *   You may not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                          *   A copy of the License is located at
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *       http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   or in the "license" file accompanying this file. This file is distributed
                                                                                                                                                                                                                                                                                                                          *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
                                                                                                                                                                                                                                                                                                                          *   express or implied. See the License for the specific language governing
                                                                                                                                                                                                                                                                                                                          *   permissions and limitations under the License.
                                                                                                                                                                                                                                                                                                                          */
class SecurityPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    // FIXME: keep an reference of admin client so that it can be used in start(), better to figureout a
    //        decent way to get adminClient in start. (maybe using getStartServices() from setup?)
    // @ts-ignore: property not initialzied in constructor
    _defineProperty(this, "securityClient", void 0);
    _defineProperty(this, "savedObjectClientWrapper", void 0);
    this.logger = initializerContext.logger.get();
    this.savedObjectClientWrapper = new _saved_objects_wrapper.SecuritySavedObjectsClientWrapper();
  }
  async setup(core, {
    dataSource
  }) {
    var _config$multitenancy, _config$multitenancy2;
    this.logger.debug('opendistro_security: Setup');
    const dataSourceEnabled = !!dataSource;
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();
    const esClient = core.opensearch.legacy.createClient('opendistro_security', {
      plugins: [_opensearch_security_configuration_plugin.default, _opensearch_security_plugin.default]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_opensearch_security_configuration_plugin.default);
      dataSource.registerCustomApiSchema(_opensearch_security_plugin.default);
    }
    this.securityClient = new _opensearch_security_client.SecurityClient(esClient);
    const securitySessionStorageFactory = await core.http.createCookieSessionStorageFactory((0, _security_cookie.getSecurityCookieOptions)(config));

    // put logger into route handler context, so that we don't need to pass througth parameters
    core.http.registerRouteHandlerContext('security_plugin', (context, request) => {
      return {
        logger: this.logger,
        esClient
      };
    });

    // setup auth
    const auth = await (0, _auth_handler_factory.getAuthenticationHandler)(config.auth.type, router, config, core, esClient, securitySessionStorageFactory, this.logger);
    core.http.registerAuth(auth.authHandler);

    /* Here we check if multitenancy is enabled to ensure if it is, we insert the tenant info (security_tenant) into the resolved, short URL so the page can correctly load with the right tenant information [Fix for issue 1203](https://github.com/opensearch-project/security-dashboards-plugin/issues/1203 */
    if ((_config$multitenancy = config.multitenancy) !== null && _config$multitenancy !== void 0 && _config$multitenancy.enabled) {
      core.http.registerOnPreResponse((request, preResponse, toolkit) => {
        (0, _tenant_resolver.addTenantParameterToResolvedShortLink)(request);
        return toolkit.next();
      });
    }

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    (0, _auth_type_routes.defineAuthTypeRoutes)(router, config);

    // set up multi-tenant routes
    if ((_config$multitenancy2 = config.multitenancy) !== null && _config$multitenancy2 !== void 0 && _config$multitenancy2.enabled) {
      (0, _routes2.setupMultitenantRoutes)(router, securitySessionStorageFactory, this.securityClient);
    }
    if (config.multitenancy.enabled && config.multitenancy.enable_aggregation_view) {
      core.savedObjects.addClientWrapper(2, 'security-saved-object-client-wrapper', this.savedObjectClientWrapper.wrapperFactory);
    }
    const service = new _readonly_service.ReadonlyService(this.logger, this.securityClient, auth, securitySessionStorageFactory, config);
    core.security.registerReadonlyService(service);
    return {
      config$,
      securityConfigClient: esClient
    };
  }

  // TODO: add more logs
  async start(core) {
    var _config$multitenancy3;
    this.logger.debug('opendistro_security: Started');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    this.savedObjectClientWrapper.httpStart = core.http;
    this.savedObjectClientWrapper.config = config;
    if ((_config$multitenancy3 = config.multitenancy) !== null && _config$multitenancy3 !== void 0 && _config$multitenancy3.enabled) {
      const globalConfig$ = this.initializerContext.config.legacy.globalConfig$;
      const globalConfig = await globalConfig$.pipe((0, _operators.first)()).toPromise();
      const opensearchDashboardsIndex = globalConfig.opensearchDashboards.index;
      const typeRegistry = core.savedObjects.getTypeRegistry();
      const esClient = core.opensearch.client.asInternalUser;
      const migrationClient = (0, _core.createMigrationOpenSearchClient)(esClient, this.logger);
      (0, _tenant_index.setupIndexTemplate)(esClient, opensearchDashboardsIndex, typeRegistry, this.logger);
      const serializer = core.savedObjects.createSerializer();
      const opensearchDashboardsVersion = this.initializerContext.env.packageInfo.version;
      (0, _tenant_index.migrateTenantIndices)(opensearchDashboardsVersion, migrationClient, this.securityClient, typeRegistry, serializer, this.logger);
    }
    return {
      http: core.http,
      es: core.opensearch.legacy
    };
  }
  stop() {}
}
exports.SecurityPlugin = SecurityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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