/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceEventWindowsResponse;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindow;

public class DescribeInstanceEventWindowsIterable
implements SdkIterable<DescribeInstanceEventWindowsResponse> {
    private final Ec2Client client;
    private final DescribeInstanceEventWindowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceEventWindowsIterable(Ec2Client client, DescribeInstanceEventWindowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInstanceEventWindowsResponseFetcher();
    }

    public Iterator<DescribeInstanceEventWindowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceEventWindow> instanceEventWindows() {
        Function<DescribeInstanceEventWindowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceEventWindows() != null) {
                return response.instanceEventWindows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceEventWindowsResponseFetcher
    implements SyncPageFetcher<DescribeInstanceEventWindowsResponse> {
        private DescribeInstanceEventWindowsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceEventWindowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceEventWindowsResponse nextPage(DescribeInstanceEventWindowsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceEventWindowsIterable.this.client.describeInstanceEventWindows(DescribeInstanceEventWindowsIterable.this.firstRequest);
            }
            return DescribeInstanceEventWindowsIterable.this.client.describeInstanceEventWindows((DescribeInstanceEventWindowsRequest)((Object)DescribeInstanceEventWindowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

