/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.PermissionGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchPermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchPermission> {
    private static final SdkField<String> ORGANIZATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationArn").getter(LaunchPermission.getter(LaunchPermission::organizationArn)).setter(LaunchPermission.setter(Builder::organizationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationArn").unmarshallLocationName("organizationArn").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnitArn").getter(LaunchPermission.getter(LaunchPermission::organizationalUnitArn)).setter(LaunchPermission.setter(Builder::organizationalUnitArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitArn").unmarshallLocationName("organizationalUnitArn").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(LaunchPermission.getter(LaunchPermission::userId)).setter(LaunchPermission.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").unmarshallLocationName("userId").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(LaunchPermission.getter(LaunchPermission::groupAsString)).setter(LaunchPermission.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").unmarshallLocationName("group").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ARN_FIELD, ORGANIZATIONAL_UNIT_ARN_FIELD, USER_ID_FIELD, GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchPermission.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String organizationArn;
    private final String organizationalUnitArn;
    private final String userId;
    private final String group;

    private LaunchPermission(BuilderImpl builder) {
        this.organizationArn = builder.organizationArn;
        this.organizationalUnitArn = builder.organizationalUnitArn;
        this.userId = builder.userId;
        this.group = builder.group;
    }

    public final String organizationArn() {
        return this.organizationArn;
    }

    public final String organizationalUnitArn() {
        return this.organizationalUnitArn;
    }

    public final String userId() {
        return this.userId;
    }

    public final PermissionGroup group() {
        return PermissionGroup.fromValue(this.group);
    }

    public final String groupAsString() {
        return this.group;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermission)) {
            return false;
        }
        LaunchPermission other = (LaunchPermission)obj;
        return Objects.equals(this.organizationArn(), other.organizationArn()) && Objects.equals(this.organizationalUnitArn(), other.organizationalUnitArn()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.groupAsString(), other.groupAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchPermission").add("OrganizationArn", (Object)this.organizationArn()).add("OrganizationalUnitArn", (Object)this.organizationalUnitArn()).add("UserId", (Object)this.userId()).add("Group", (Object)this.groupAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationArn": {
                return Optional.ofNullable(clazz.cast(this.organizationArn()));
            }
            case "OrganizationalUnitArn": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitArn()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.groupAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OrganizationArn", ORGANIZATION_ARN_FIELD);
        map.put("OrganizationalUnitArn", ORGANIZATIONAL_UNIT_ARN_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("Group", GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchPermission, T> g) {
        return obj -> g.apply((LaunchPermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationArn;
        private String organizationalUnitArn;
        private String userId;
        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermission model) {
            this.organizationArn(model.organizationArn);
            this.organizationalUnitArn(model.organizationalUnitArn);
            this.userId(model.userId);
            this.group(model.group);
        }

        public final String getOrganizationArn() {
            return this.organizationArn;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final String getOrganizationalUnitArn() {
            return this.organizationalUnitArn;
        }

        public final void setOrganizationalUnitArn(String organizationalUnitArn) {
            this.organizationalUnitArn = organizationalUnitArn;
        }

        @Override
        public final Builder organizationalUnitArn(String organizationalUnitArn) {
            this.organizationalUnitArn = organizationalUnitArn;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group == null ? null : group.toString());
            return this;
        }

        public LaunchPermission build() {
            return new LaunchPermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchPermission> {
        public Builder organizationArn(String var1);

        public Builder organizationalUnitArn(String var1);

        public Builder userId(String var1);

        public Builder group(String var1);

        public Builder group(PermissionGroup var1);
    }
}

