/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class DeleteModelRequest
extends ActionRequest {
    private String modelID;

    public DeleteModelRequest(StreamInput in) throws IOException {
        super(in);
        this.modelID = in.readString();
    }

    public DeleteModelRequest(String modelID) {
        this.modelID = modelID;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.modelID);
    }

    public ActionRequestValidationException validate() {
        if (StringUtils.isNotBlank((String)this.modelID)) {
            return null;
        }
        return ValidateActions.addValidationError((String)"Model id cannot be empty ", null);
    }

    public String getModelID() {
        return this.modelID;
    }
}

