/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.hadoop.io.ByteBufferPool;

public final class VectorIOBufferPool
implements ByteBufferPool {
    private final IntFunction<ByteBuffer> allocate;
    private final Consumer<ByteBuffer> release;

    public VectorIOBufferPool(IntFunction<ByteBuffer> allocate, Consumer<ByteBuffer> release) {
        this.allocate = Objects.requireNonNull(allocate);
        this.release = Objects.requireNonNull(release);
    }

    @Override
    public ByteBuffer getBuffer(boolean direct, int length) {
        return this.allocate.apply(length);
    }

    @Override
    public void putBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            this.release.accept(buffer);
        }
    }
}

