/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.Log;
import software.amazon.awssdk.crt.io.TlsHashAlgorithm;
import software.amazon.awssdk.crt.io.TlsKeyOperationHandler;
import software.amazon.awssdk.crt.io.TlsSignatureAlgorithm;

public final class TlsKeyOperation {
    private CrtResourceInternal nativeResource;
    private byte[] inputData;
    private Type operationType;
    private TlsSignatureAlgorithm signatureAlgorithm;
    private TlsHashAlgorithm digestAlgorithm;

    protected TlsKeyOperation(long nativeHandle, byte[] inputData, int operationType, int signatureAlgorithm, int digestAlgorithm) {
        this.nativeResource = new CrtResourceInternal(nativeHandle);
        this.inputData = inputData;
        this.operationType = Type.getEnumValueFromInteger(operationType);
        this.signatureAlgorithm = TlsSignatureAlgorithm.getEnumValueFromInteger(signatureAlgorithm);
        this.digestAlgorithm = TlsHashAlgorithm.getEnumValueFromInteger(digestAlgorithm);
    }

    public byte[] getInput() {
        return this.inputData;
    }

    public Type getType() {
        return this.operationType;
    }

    public TlsSignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public TlsHashAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public synchronized void complete(byte[] output) {
        if (this.nativeResource.isNull()) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.CommonGeneral, "No native handle set in TlsKeyOperation! Cannot complete operation");
            return;
        }
        TlsKeyOperation.tlsKeyOperationComplete(this.nativeResource.getNativeHandle(), output);
        this.nativeResource.close();
    }

    public synchronized void completeExceptionally(Throwable ex) {
        if (this.nativeResource.isNull()) {
            Log.log(Log.LogLevel.Error, Log.LogSubject.CommonGeneral, "No native handle set in TlsKeyOperation! Cannot complete operation exceptionally");
            return;
        }
        TlsKeyOperation.tlsKeyOperationCompleteExceptionally(this.nativeResource.getNativeHandle(), ex);
        this.nativeResource.close();
    }

    private static void invokePerformOperation(TlsKeyOperationHandler handler, TlsKeyOperation operation) {
        try {
            handler.performOperation(operation);
        }
        catch (Exception ex) {
            StringWriter stringWriter = new StringWriter();
            ex.printStackTrace(new PrintWriter(stringWriter));
            Log.log(Log.LogLevel.Error, Log.LogSubject.CommonGeneral, "Exception occured!\n" + stringWriter.toString());
            operation.completeExceptionally(ex);
        }
    }

    private static native void tlsKeyOperationComplete(long var0, byte[] var2);

    private static native void tlsKeyOperationCompleteExceptionally(long var0, Throwable var2);

    private class CrtResourceInternal
    extends CrtResource {
        CrtResourceInternal(long nativeHandle) {
            this.acquireNativeHandle(nativeHandle);
        }

        @Override
        protected void releaseNativeHandle() {
        }

        @Override
        protected boolean canReleaseReferencesImmediately() {
            return true;
        }
    }

    public static enum Type {
        UNKNOWN(0),
        SIGN(1),
        DECRYPT(2);

        int nativeValue;
        static Map<Integer, Type> enumMapping;

        static Map<Integer, Type> buildEnumMapping() {
            HashMap<Integer, Type> enumMapping = new HashMap<Integer, Type>();
            for (Type i : Type.values()) {
                enumMapping.put(i.nativeValue, i);
            }
            return enumMapping;
        }

        public static Type getEnumValueFromInteger(int value) {
            Type enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal TlsKeyOperation.Type");
        }

        private Type(int nativeValue) {
            this.nativeValue = nativeValue;
        }

        public int getNativeValue() {
            return this.nativeValue;
        }

        static {
            enumMapping = Type.buildEnumMapping();
        }
    }
}

