/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.font.StringBounder;

public class Genealogy {
    private Map<Ftile, Ftile> myFatherIs = new HashMap<Ftile, Ftile>();
    private final Ftile root;

    public Genealogy(Ftile root) {
        this.root = root;
        this.process(root);
    }

    private void process(Ftile current) {
        Collection<Ftile> children = current.getMyChildren();
        for (Ftile child : children) {
            this.setMyFather(child, current);
            this.process(child);
        }
    }

    public Ftile getMyFather(Ftile me) {
        return this.myFatherIs.get(me);
    }

    private void setMyFather(Ftile child, Ftile father) {
        if (this.myFatherIs.containsKey(child)) {
            throw new IllegalArgumentException();
        }
        this.myFatherIs.put(child, father);
    }

    public UTranslate getTranslate(Ftile child, StringBounder stringBounder) {
        Ftile current = child;
        UTranslate result = UTranslate.none();
        while (current != this.root) {
            Ftile father = this.getMyFather(current);
            UTranslate tr = father.getTranslateFor(current, stringBounder);
            result = tr.compose(result);
            current = father;
        }
        return result;
    }
}

