/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

public enum GlobalConfigKey {
    REPLACE_WHITE_BACKGROUND_BY_TRANSPARENT(Boolean.FALSE),
    VERBOSE(Boolean.FALSE),
    EXTRACT_FROM_METADATA(Boolean.FALSE),
    WORD(Boolean.FALSE),
    SYSTEM_EXIT(Boolean.TRUE),
    GUI(Boolean.FALSE),
    PRINT_FONTS(Boolean.FALSE),
    ENCODESPRITE(Boolean.FALSE),
    DUMP_HTML_STATS(Boolean.FALSE),
    DUMP_STATS(Boolean.FALSE),
    LOOP_STATS(Boolean.FALSE),
    OVERWRITE(Boolean.FALSE),
    ENABLE_STATS(GlobalConfigKey.defaultForStats()),
    STD_LIB(Boolean.FALSE),
    SILENTLY_COMPLETELY_IGNORE_ERRORS(Boolean.FALSE),
    CLIPBOARD_LOOP(Boolean.FALSE),
    CLIPBOARD(Boolean.FALSE),
    FILE_SEPARATOR("_"),
    TIMEOUT_MS(900000L);

    private final Object defaultValue;

    private GlobalConfigKey(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    private static boolean defaultForStats() {
        return GlobalConfigKey.isTrue(System.getProperty("PLANTUML_STATS")) || GlobalConfigKey.isTrue(System.getenv("PLANTUML_STATS"));
    }

    private static boolean isTrue(String value) {
        return "on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
    }
}

