/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.projectTree;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.ui.projectTree.MarkdownRenamer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/ui/projectTree/MarkdownRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamerFactory;", "<init>", "()V", "isApplicable", "", "element", "Lcom/intellij/psi/PsiElement;", "getOptionName", "", "isEnabled", "setEnabled", "", "enabled", "createRenamer", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "newName", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "intellij.markdown"})
public final class MarkdownRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (!(element2 instanceof MarkdownFile)) {
            return false;
        }
        List<PsiFile> boundDocuments = MarkdownRenamer.Companion.findBoundDocument((MarkdownFile)element2);
        return !((Collection)boundDocuments).isEmpty();
    }

    @NotNull
    public String getOptionName() {
        String string = MarkdownBundle.message("markdown.rename.factory.option.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element2, @NotNull String newName, @NotNull Collection<UsageInfo> usages2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
        if (!(element2 instanceof MarkdownFile)) {
            throw new IllegalStateException("Check failed.");
        }
        return new MarkdownRenamer((MarkdownFile)element2, newName);
    }
}

