\name{FastMarchingUpwindGradientImageFilter}
\alias{FastMarchingUpwindGradientImageFilter}
\title{FastMarchingUpwindGradientImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Generates the upwind gradient field of fast marching arrival times.
FastMarchingUpwindGradientImageFilter}
\details{
This filter adds some extra functionality to its base class. While the
solution T(x) of the Eikonal equation is being generated by the base
class with the fast marching method, the filter generates the upwind
gradient vectors of T(x), storing them in an image.
Since the Eikonal equation generates the arrival times of a wave
traveling at a given speed, the generated gradient vectors can be
interpreted as the slowness (1/velocity) vectors of the front (the
quantity inside the modulus operator in the Eikonal equation).
Gradient vectors are computed using upwind finite differences, that
is, information only propagates from points where the wavefront has
already passed. This is consistent with how the fast marching method
works.
One more extra feature is the possibility to define a set of Target
points where the propagation stops. This can be used to avoid
computing the Eikonal solution for the whole domain. The front can be
stopped either when one Target point is reached or all Target points
are reached. The propagation can stop after a time TargetOffset has
passed since the stop condition is met. This way the solution is
computed a bit downstream the Target points, so that the level sets of
T(x) corresponding to the Target are smooth.
For an alternative implementation, see itk::FastMarchingUpwindGradientImageFilterBase .
Luca Antiga Ph.D. Biomedical Technologies Laboratory, Bioengineering
Department, Mario Negri Institute, Italy.
See:
FastMarchingUpwindGradient for the procedural interface
itk::FastMarchingUpwindGradientImageFilter for the Doxygen on the original ITK class.
FastMarchingUpwindGradientImageFilter}
%C++ includes: sitkFastMarchingUpwindGradientImageFilter.h
\section{Methods}{
\describe{
\item{Self AddTargetPoint(std::vector< unsigned int > point):}{
Add TargetPoints point.
}
\item{Self AddTrialPoint(std::vector< unsigned int > point):}{
Add TrialPoints point.
}
\item{Self ClearTargetPoints():}{
Remove all TargetPoints points.
}
\item{Self ClearTrialPoints():}{
Remove all TrialPoints points.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{ FastMarchingUpwindGradientImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image GetGradientImage() const:}{
Get the gradient image.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::vector< double > GetInitialTrialValues() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetNormalizationFactor() const:}{
Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.
}
\item{unsigned int GetNumberOfTargets() const:}{
Get the number of targets.
}
\item{double GetTargetOffset() const:}{
Get the TargetOffset ivar.
}
\item{std::vector< std::vector< unsigned int > > GetTargetPoints() const:}{
Get the container of Target Points.
}
\item{double GetTargetValue() const:}{
Get the arrival time corresponding to the last reached target. If
TargetReachedMode is set to NoTargets, TargetValue contains the last
(aka largest) Eikonal solution value generated.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{std::vector< std::vector< unsigned int > > GetTrialPoints() const:}{}
\item{Self SetInitialTrialValues(std::vector< double > InitialTrialValues):}{
Set the initial seed values for corresponding trial point.
}
\item{Self SetNormalizationFactor(double NormalizationFactor):}{
Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.
}
\item{Self SetNumberOfTargets(unsigned int NumberOfTargets):}{}
\item{Self SetTargetOffset(double TargetOffset):}{
Set how long (in terms of arrival times) after targets are reached the
front must stop. This is useful to ensure that the level set of target
arrival time is smooth.
}
\item{Self SetTargetPoints(std::vector< std::vector< unsigned int > > TargetPoints):}{
Set the container of Target Points. If a target point is reached, the
propagation stops. Trial points are represented as a VectorContainer of LevelSetNodes.
}
\item{Self SetTrialPoints(std::vector< std::vector< unsigned int > > TrialPoints):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~FastMarchingUpwindGradientImageFilter():}{
Destructor
}
}
}
