%%
%% This is file `nstc-cm302.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% nstc-proposal.dtx  (with options: `cm302')
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   https://www.latex-project.org/lppl.txt
%% and version 1.3c or later is part of all distributions of LaTeX
%% version 2008 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Liang-Ting Chen (陳亮廷).
%% 
%% This work consists of the files nstc-proposal.dtx and nstc-proposal.ins
%% and the derived files nstc-cm03.cls, nstc-cm302.cls,
%% example/proposal.tex, and example/bibliography.tex.
%% 
\NeedsTeXFormat{LaTeX2e}[2023-11-01]
\ProvidesClass{nstc-cm302}
   [2024-11-04 v1.0 NSTC CM03/302 LaTeX 文件格式]

\def\cmthree@opterrlong{The option "\CurrentOption" from article.cls is
  not compatible with the format of cm03.}
\newcommand{\cmthree@warning}{\ClassWarning{cm03}{\cmthree@opterrlong}}
\newcommand{\cmthree@info}[1]{\ClassInfo{cm03}{#1}}
\DeclareOption{titlepage}{\cmthree@warning}
\DeclareOption{notitlepage}{\cmthree@warning}
\DeclareOption{10pt}{\cmthree@warning}
\DeclareOption{11pt}{\cmthree@warning}
\DeclareOption{letterpaper}{\cmthree@warning}
\DeclareOption{a5paper}{\cmthree@warning}
\DeclareOption{b5paper}{\cmthree@warning}
\DeclareOption{executivepaper}{\cmthree@warning}
\DeclareOption{legalpaper}{\cmthree@warning}
\DeclareOption{twocolumn}{\cmthree@warning}
\DeclareOption{openright}{\cmthree@warning}
\DeclareOption{libertine}{\let\@libertine\relax}
\DeclareOption{kaiti}{\let\@kaiti\relax}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass[a4paper,12pt,onecolumn,twoside]{article}
\RequirePackage[margin=2cm,bottom=2.4cm]{geometry}
\RequirePackage{setspace}
\onehalfspacing

\RequirePackage{iftex,xifthen}
\RequirePackage{amsmath,amsthm}
\iftutex
\RequirePackage[PunctStyle=plain,no-math]{xeCJK}
\ifx\@kaiti\relax
  \setCJKmainfont{Kaiti TC}[BoldFont = *-Bold]
  \setCJKsansfont{Heiti TC}
  \cmthree@info{使用楷體作為中文字型}
\else
\IfFontExistsTF{BiauKai}{
  \setCJKmainfont{BiauKai}[AutoFakeBold=2.5]
  \cmthree@info{使用標楷體 (BiauKai) 作為中文字型}
}{
  \IfFontExistsTF{BiauKaiTC}{
  \setCJKmainfont{BiauKaiTC}[AutoFakeBold=2.5]
  \cmthree@info{使用標楷體繁 (BiauKaiTC) 作為中文字型}
}{
  \setCJKmainfont{bkai00mp.ttf}[AutoFakeBold=2.5]
  \cmthree@info{使用 AR PL UKai TW 作為中文字型}
}}
\fi
\else
  \RequirePackage{CJKutf8}
  \newenvironment{zh}{\begin{CJK*}{UTF8}{bkai}}{\end{CJK*}}
  \input{c70bkai.fd}
  \DeclareFontShape{C70}{bkai}{b}{n}{<-> CJKb * bkaiu}{\CJKbold}
  \AddToHook{begindocument/end}{\begin{zh}}
  \AddToHook{enddocument}{\end{zh}}
\fi
\ifx\@libertine\relax
  \RequirePackage[tt=false]{libertine}
  \iftutex
    \RequirePackage{unicode-math}
    \setmathfont[Scale=MatchUppercase]{LibertinusMath-Regular.otf}
  \else
    \RequirePackage[libertine]{newtxmath}
  \fi
\else
  \RequirePackage{newtxtext}
  \iftutex
    \defaultfontfeatures{}
  \fi
  \RequirePackage{newtxmath}
\fi
\def\cmthree@heading{五、著作目錄（建議呈現與計畫相關之著作目錄，頁數以~2~頁為限）：}
\def\cmthree@footer{表\;CM302}
\AddToHook{begindocument/end}{\par%
  \everypar={{\setbox0=\lastbox}\everypar{}}%
  \begingroup\large\bfseries\cmthree@heading\endgroup\par}

\RequirePackage{lastpage,fancyhdr}
\pagestyle{fancy}
\renewcommand{\headrulewidth}{0pt}
\fancyhead{}
\iftutex
  \lfoot{\cmthree@footer}
\else
  \lfoot{\begin{zh}\cmthree@footer\end{zh}}
\fi
\cfoot{}
\iftutex
  \rfoot{共~\pageref{LastPage}~頁%
  \hspace{1em}第~\thepage~頁}
\else
  \rfoot{\begin{zh}共~\pageref{LastPage}~頁%
  \hspace{1em}第~\thepage~頁\end{zh}}
\fi
\AddToHook{begindocument/end}{\renewcommand{\section}[2]{}}

\endinput
%%
%% End of file `nstc-cm302.cls'.
