/*
 * Copyright (c) 1999-2004,2008-2015 Apple Inc. All Rights Reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 *
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 *
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 *
 * @APPLE_LICENSE_HEADER_END@
 *
 * oidsalg.h -- OIDs defining crypto algorithms
 */

#ifndef	_OIDS_ALG_H_
#define _OIDS_ALG_H_

#include <Security/SecAsn1Types.h>

#ifdef	__cplusplus
extern "C" {
#endif

extern const SecAsn1Oid
	CSSMOID_MD2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_MD4 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_MD5 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_RSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_MD2WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_MD4WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_MD5WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA1WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA224WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA256WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA384WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA512WithRSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA1WithRSA_OIW DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_RSAWithOAEP DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_OAEP_MGF1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_OAEP_ID_PSPECIFIED DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DES_CBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_PUB_NUMBER DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_STATIC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_ONE_FLOW DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_EPHEM DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_HYBRID1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_HYBRID2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_HYBRID_ONEFLOW DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_MQV1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_MQV2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_STATIC_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_ONE_FLOW_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_EPHEM_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_HYBRID1_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_DH_HYBRID2_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_MQV1_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ANSI_MQV2_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS3 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DH DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 				// BSAFE only
	CSSMOID_DSA_CMS DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 			// X509/CMS
	CSSMOID_DSA_JDK DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 			// JDK 1.1
	CSSMOID_SHA1WithDSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 		// BSAFE
	CSSMOID_SHA1WithDSA_CMS DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 	// X509/CMS
	CSSMOID_SHA1WithDSA_JDK DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER, 	// JDK 1.1
	CSSMOID_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA224 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA256 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA384 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_SHA512 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ecPublicKey DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ECDSA_WithSHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ECDSA_WithSHA224 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ECDSA_WithSHA256 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ECDSA_WithSHA384 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ECDSA_WithSHA512 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_ECDSA_WithSpecified DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_ISIGN DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_X509_BASIC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_SSL DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_LOCAL_CERT_GEN DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_CSR_GEN DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_REVOCATION_CRL DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_REVOCATION_OCSP DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_SMIME DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_EAP DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_CODE_SIGN DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_SW_UPDATE_SIGNING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_IP_SEC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_ICHAT DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_RESOURCE_SIGN DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_PKINIT_CLIENT DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_PKINIT_SERVER DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_CODE_SIGNING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_PACKAGE_SIGNING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_MACAPPSTORE_RECEIPT DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_APPLEID_SHARING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_TIMESTAMPING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_REVOCATION DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_PASSBOOK_SIGNING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_MOBILE_STORE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_ESCROW_SERVICE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_PROFILE_SIGNING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_QA_PROFILE_SIGNING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_TEST_MOBILE_STORE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_PCS_ESCROW_SERVICE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_TP_PROVISIONING_PROFILE_SIGNING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_FEE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_ASC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_FEE_MD5 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_FEE_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_FEED DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_FEEDEXP DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_APPLE_ECDSA DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_IDENTITY DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_EMAIL_SIGN DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_EMAIL_ENCRYPT DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_ARCHIVE_LIST DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_ARCHIVE_STORE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_ARCHIVE_FETCH DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_ARCHIVE_REMOVE DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_SHARED_SERVICES DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_VALUE_USERNAME DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_VALUE_PASSWORD DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_VALUE_HOSTNAME DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_VALUE_RENEW DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_VALUE_ASYNC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_DOTMAC_CERT_REQ_VALUE_IS_PENDING DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_DIGEST_ALG DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_ENCRYPT_ALG DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_HMAC_SHA1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_pbeWithMD2AndDES DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_pbeWithMD2AndRC2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_pbeWithMD5AndDES DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_pbeWithMD5AndRC2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_pbeWithSHA1AndDES DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_pbeWithSHA1AndRC2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_PBKDF2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_PBES2 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_PBMAC1 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_RC2_CBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_DES_EDE3_CBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS5_RC5_CBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS12_pbeWithSHAAnd128BitRC4 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS12_pbeWithSHAAnd40BitRC4 DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS12_pbeWithSHAAnd3Key3DESCBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS12_pbeWithSHAAnd2Key3DESCBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS12_pbeWithSHAAnd128BitRC2CBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER,
	CSSMOID_PKCS12_pbewithSHAAnd40BitRC2CBC DEPRECATED_IN_MAC_OS_X_VERSION_10_7_AND_LATER;

#ifdef	__cplusplus
}
#endif

#endif	/* _OIDS_ALG_H_ */
