/*
 * Copyright (c) 2014 DeNA Co., Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* DO NOT EDIT! generated by tokens.pl */
#ifndef h2o__token_table_h
#define h2o__token_table_h

#define H2O_TOKEN_AUTHORITY (h2o__tokens + 0)
#define H2O_TOKEN_METHOD (h2o__tokens + 1)
#define H2O_TOKEN_PATH (h2o__tokens + 2)
#define H2O_TOKEN_PROTOCOL (h2o__tokens + 3)
#define H2O_TOKEN_SCHEME (h2o__tokens + 4)
#define H2O_TOKEN_STATUS (h2o__tokens + 5)
#define H2O_TOKEN_ACCEPT (h2o__tokens + 6)
#define H2O_TOKEN_ACCEPT_CHARSET (h2o__tokens + 7)
#define H2O_TOKEN_ACCEPT_ENCODING (h2o__tokens + 8)
#define H2O_TOKEN_ACCEPT_LANGUAGE (h2o__tokens + 9)
#define H2O_TOKEN_ACCEPT_RANGES (h2o__tokens + 10)
#define H2O_TOKEN_ACCESS_CONTROL_ALLOW_CREDENTIALS (h2o__tokens + 11)
#define H2O_TOKEN_ACCESS_CONTROL_ALLOW_HEADERS (h2o__tokens + 12)
#define H2O_TOKEN_ACCESS_CONTROL_ALLOW_METHODS (h2o__tokens + 13)
#define H2O_TOKEN_ACCESS_CONTROL_ALLOW_ORIGIN (h2o__tokens + 14)
#define H2O_TOKEN_ACCESS_CONTROL_EXPOSE_HEADERS (h2o__tokens + 15)
#define H2O_TOKEN_ACCESS_CONTROL_REQUEST_HEADERS (h2o__tokens + 16)
#define H2O_TOKEN_ACCESS_CONTROL_REQUEST_METHOD (h2o__tokens + 17)
#define H2O_TOKEN_AGE (h2o__tokens + 18)
#define H2O_TOKEN_ALLOW (h2o__tokens + 19)
#define H2O_TOKEN_ALT_SVC (h2o__tokens + 20)
#define H2O_TOKEN_AUTHORIZATION (h2o__tokens + 21)
#define H2O_TOKEN_CACHE_CONTROL (h2o__tokens + 22)
#define H2O_TOKEN_CACHE_DIGEST (h2o__tokens + 23)
#define H2O_TOKEN_CONNECTION (h2o__tokens + 24)
#define H2O_TOKEN_CONTENT_DISPOSITION (h2o__tokens + 25)
#define H2O_TOKEN_CONTENT_ENCODING (h2o__tokens + 26)
#define H2O_TOKEN_CONTENT_LANGUAGE (h2o__tokens + 27)
#define H2O_TOKEN_CONTENT_LENGTH (h2o__tokens + 28)
#define H2O_TOKEN_CONTENT_LOCATION (h2o__tokens + 29)
#define H2O_TOKEN_CONTENT_RANGE (h2o__tokens + 30)
#define H2O_TOKEN_CONTENT_SECURITY_POLICY (h2o__tokens + 31)
#define H2O_TOKEN_CONTENT_TYPE (h2o__tokens + 32)
#define H2O_TOKEN_COOKIE (h2o__tokens + 33)
#define H2O_TOKEN_DATAGRAM_FLOW_ID (h2o__tokens + 34)
#define H2O_TOKEN_DATE (h2o__tokens + 35)
#define H2O_TOKEN_EARLY_DATA (h2o__tokens + 36)
#define H2O_TOKEN_ETAG (h2o__tokens + 37)
#define H2O_TOKEN_EXPECT (h2o__tokens + 38)
#define H2O_TOKEN_EXPECT_CT (h2o__tokens + 39)
#define H2O_TOKEN_EXPIRES (h2o__tokens + 40)
#define H2O_TOKEN_FORWARDED (h2o__tokens + 41)
#define H2O_TOKEN_FROM (h2o__tokens + 42)
#define H2O_TOKEN_HOST (h2o__tokens + 43)
#define H2O_TOKEN_HTTP2_SETTINGS (h2o__tokens + 44)
#define H2O_TOKEN_IF_MATCH (h2o__tokens + 45)
#define H2O_TOKEN_IF_MODIFIED_SINCE (h2o__tokens + 46)
#define H2O_TOKEN_IF_NONE_MATCH (h2o__tokens + 47)
#define H2O_TOKEN_IF_RANGE (h2o__tokens + 48)
#define H2O_TOKEN_IF_UNMODIFIED_SINCE (h2o__tokens + 49)
#define H2O_TOKEN_KEEP_ALIVE (h2o__tokens + 50)
#define H2O_TOKEN_LAST_MODIFIED (h2o__tokens + 51)
#define H2O_TOKEN_LINK (h2o__tokens + 52)
#define H2O_TOKEN_LOCATION (h2o__tokens + 53)
#define H2O_TOKEN_MAX_FORWARDS (h2o__tokens + 54)
#define H2O_TOKEN_NO_EARLY_HINTS (h2o__tokens + 55)
#define H2O_TOKEN_ORIGIN (h2o__tokens + 56)
#define H2O_TOKEN_PRIORITY (h2o__tokens + 57)
#define H2O_TOKEN_PROXY_AUTHENTICATE (h2o__tokens + 58)
#define H2O_TOKEN_PROXY_AUTHORIZATION (h2o__tokens + 59)
#define H2O_TOKEN_PROXY_CONNECTION (h2o__tokens + 60)
#define H2O_TOKEN_PURPOSE (h2o__tokens + 61)
#define H2O_TOKEN_RANGE (h2o__tokens + 62)
#define H2O_TOKEN_REFERER (h2o__tokens + 63)
#define H2O_TOKEN_REFRESH (h2o__tokens + 64)
#define H2O_TOKEN_RETRY_AFTER (h2o__tokens + 65)
#define H2O_TOKEN_SERVER (h2o__tokens + 66)
#define H2O_TOKEN_SET_COOKIE (h2o__tokens + 67)
#define H2O_TOKEN_STRICT_TRANSPORT_SECURITY (h2o__tokens + 68)
#define H2O_TOKEN_TE (h2o__tokens + 69)
#define H2O_TOKEN_TIMING_ALLOW_ORIGIN (h2o__tokens + 70)
#define H2O_TOKEN_TRANSFER_ENCODING (h2o__tokens + 71)
#define H2O_TOKEN_UPGRADE (h2o__tokens + 72)
#define H2O_TOKEN_UPGRADE_INSECURE_REQUESTS (h2o__tokens + 73)
#define H2O_TOKEN_USER_AGENT (h2o__tokens + 74)
#define H2O_TOKEN_VARY (h2o__tokens + 75)
#define H2O_TOKEN_VIA (h2o__tokens + 76)
#define H2O_TOKEN_WWW_AUTHENTICATE (h2o__tokens + 77)
#define H2O_TOKEN_X_COMPRESS_HINT (h2o__tokens + 78)
#define H2O_TOKEN_X_CONTENT_TYPE_OPTIONS (h2o__tokens + 79)
#define H2O_TOKEN_X_FORWARDED_FOR (h2o__tokens + 80)
#define H2O_TOKEN_X_FRAME_OPTIONS (h2o__tokens + 81)
#define H2O_TOKEN_X_REPROXY_URL (h2o__tokens + 82)
#define H2O_TOKEN_X_TRAFFIC (h2o__tokens + 83)
#define H2O_TOKEN_X_XSS_PROTECTION (h2o__tokens + 84)

extern const h2o_hpack_static_table_entry_t h2o_hpack_static_table[61];
extern const h2o_qpack_static_table_entry_t h2o_qpack_static_table[99];

typedef int32_t (*h2o_qpack_lookup_static_cb)(h2o_iovec_t value, int *is_exact);
extern const h2o_qpack_lookup_static_cb h2o_qpack_lookup_static[85];

int32_t h2o_qpack_lookup_authority(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_method(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_path(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_protocol(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_scheme(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_status(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_accept(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_accept_charset(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_accept_encoding(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_accept_language(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_accept_ranges(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_access_control_allow_credentials(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_access_control_allow_headers(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_access_control_allow_methods(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_access_control_allow_origin(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_access_control_expose_headers(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_access_control_request_headers(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_access_control_request_method(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_age(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_allow(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_alt_svc(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_authorization(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_cache_control(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_cache_digest(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_connection(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_disposition(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_encoding(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_language(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_length(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_location(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_range(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_security_policy(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_content_type(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_cookie(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_datagram_flow_id(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_date(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_early_data(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_etag(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_expect(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_expect_ct(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_expires(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_forwarded(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_from(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_host(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_http2_settings(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_if_match(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_if_modified_since(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_if_none_match(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_if_range(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_if_unmodified_since(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_keep_alive(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_last_modified(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_link(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_location(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_max_forwards(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_no_early_hints(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_origin(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_priority(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_proxy_authenticate(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_proxy_authorization(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_proxy_connection(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_purpose(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_range(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_referer(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_refresh(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_retry_after(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_server(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_set_cookie(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_strict_transport_security(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_te(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_timing_allow_origin(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_transfer_encoding(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_upgrade(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_upgrade_insecure_requests(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_user_agent(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_vary(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_via(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_www_authenticate(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_x_compress_hint(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_x_content_type_options(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_x_forwarded_for(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_x_frame_options(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_x_reproxy_url(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_x_traffic(h2o_iovec_t value, int *is_exact);
int32_t h2o_qpack_lookup_x_xss_protection(h2o_iovec_t value, int *is_exact);

#endif
