# dev/Dockerfile.riscv64.gnu
ARG CROSS_BASE_IMAGE
FROM ${CROSS_BASE_IMAGE}

# Base tools
RUN dpkg --add-architecture riscv64 \
  && apt-get update \
  && apt-get install -y --no-install-recommends \
    build-essential gperf pkg-config \
    wget ca-certificates \
    gcc-riscv64-linux-gnu g++-riscv64-linux-gnu

# Build libseccomp statically.
ENV SECCOMP_VER=2.6.0

RUN wget https://github.com/seccomp/libseccomp/releases/download/v${SECCOMP_VER}/libseccomp-${SECCOMP_VER}.tar.gz \
 && tar -xvpf libseccomp-${SECCOMP_VER}.tar.gz \
 && cd libseccomp-${SECCOMP_VER} \
 && ./configure --host=riscv64-linux-gnu --enable-static --disable-shared \
 && make -j"$(nproc)" >&2 \
 && make install >&2 \
 && cd / && rm -rf libseccomp-${SECCOMP_VER} libseccomp-${SECCOMP_VER}.tar.gz
