/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.FontInfoFrame;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.SaveInterface;
import com.kreative.bitsnpicas.edit.SaveManager;
import com.kreative.bitsnpicas.geos.mover.GEOSMoverFrame;
import com.kreative.bitsnpicas.mover.MoverFrame;
import com.kreative.unicode.fontmap.FontMapController;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class CommonMenuItems {
    public static final int SHORTCUT_KEY;
    public static final boolean IS_MAC_OS;

    static {
        boolean bl;
        SHORTCUT_KEY = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        try {
            bl = System.getProperty("os.name").toUpperCase().contains("MAC OS");
        }
        catch (Exception exception) {
            bl = false;
        }
        IS_MAC_OS = bl;
    }

    public static class FontMapMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public FontMapMenuItem() {
            super("Font Map");
            this.setAccelerator(KeyStroke.getKeyStroke(70, SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontMapController.getInstance().getFrame().setVisible(true);
                }
            });
        }
    }

    public static class ExitMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public ExitMenuItem() {
            super("Exit");
            this.setAccelerator(KeyStroke.getKeyStroke(81, SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.gc();
                    for (Window window : Window.getWindows()) {
                        if (!window.isVisible()) continue;
                        window.dispatchEvent(new WindowEvent(window, 201));
                        if (!window.isVisible()) continue;
                        return;
                    }
                    System.exit(0);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FontInfoMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public FontInfoMenuItem(final Font<?> font, final SaveManager saveManager) {
            super("Font Info");
            this.setAccelerator(KeyStroke.getKeyStroke(73, SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    new FontInfoFrame(font, saveManager).setVisible(true);
                }
            });
        }
    }

    public static class SaveAsMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public SaveAsMenuItem(final SaveInterface saveInterface) {
            super("Save As...");
            this.setAccelerator(KeyStroke.getKeyStroke(83, SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    saveInterface.saveAs();
                }
            });
        }
    }

    public static class SaveMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public SaveMenuItem(final SaveInterface saveInterface) {
            super("Save");
            this.setAccelerator(KeyStroke.getKeyStroke(83, SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    saveInterface.save();
                }
            });
        }
    }

    public static class CloseMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public CloseMenuItem(final Window window) {
            super("Close Window");
            this.setAccelerator(KeyStroke.getKeyStroke(87, SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    window.dispatchEvent(new WindowEvent(window, 201));
                }
            });
        }
    }

    public static class OpenMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public OpenMenuItem() {
            super("Open...");
            this.setAccelerator(KeyStroke.getKeyStroke(79, SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Main.openFonts();
                }
            });
        }
    }

    public static class NewGEOSFontMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public NewGEOSFontMenuItem() {
            super("New GEOS Font");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GEOSMoverFrame.forNewFile().setVisible(true);
                }
            });
        }
    }

    public static class NewFontSuitcaseMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public NewFontSuitcaseMenuItem() {
            super("New Font Suitcase");
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MoverFrame.forNewFile().setVisible(true);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        }
    }

    public static class NewVectorFontMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public NewVectorFontMenuItem() {
            super("New Vector Font");
            this.setAccelerator(KeyStroke.getKeyStroke(78, SHORTCUT_KEY | 1));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Main.newVectorFont();
                }
            });
        }
    }

    public static class NewBitmapFontMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;

        public NewBitmapFontMenuItem() {
            super("New Bitmap Font");
            this.setAccelerator(KeyStroke.getKeyStroke(78, SHORTCUT_KEY));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Main.newBitmapFont();
                }
            });
        }
    }

    public static class NewMenu
    extends JMenu {
        private static final long serialVersionUID = 1L;

        public NewMenu() {
            super("New");
            this.add(new NewBitmapFontMenuItem());
            this.add(new NewFontSuitcaseMenuItem());
            this.add(new NewGEOSFontMenuItem());
        }
    }
}

