/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListSelection {
    private final List<int[]> ranges = new ArrayList<int[]>();

    public void clear() {
        this.ranges.clear();
    }

    public void add(int n) {
        this.ranges.add(new int[]{n, n});
    }

    public void add(int n, int n2) {
        this.ranges.add(new int[]{n, n2});
    }

    public void extend(int n) {
        if (this.ranges.isEmpty()) {
            this.ranges.add(new int[]{n, n});
        } else {
            this.ranges.get((int)(this.ranges.size() - 1))[1] = n;
        }
    }

    public int getLast() {
        if (this.ranges.isEmpty()) {
            return -1;
        }
        return this.ranges.get(this.ranges.size() - 1)[1];
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public boolean contains(int n) {
        boolean bl = false;
        for (int[] nArray : this.ranges) {
            int n2 = Math.min(nArray[0], nArray[1]);
            int n3 = Math.max(nArray[0], nArray[1]);
            if (n < n2 || n > n3) continue;
            bl = !bl;
        }
        return bl;
    }

    public SortedSet<Integer> toSet() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int[] nArray : this.ranges) {
            int n = Math.min(nArray[0], nArray[1]);
            int n2 = Math.max(nArray[0], nArray[1]);
            for (int i = n; i <= n2; ++i) {
                if (treeSet.contains(i)) {
                    treeSet.remove(i);
                    continue;
                }
                treeSet.add(i);
            }
        }
        return treeSet;
    }
}

