/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class SwingUtils {
    private static final int K = -16777216;
    private static final int W = -1;
    public static final Cursor CURSOR_CROSSHAIR = Cursor.getPredefinedCursor(1);
    public static final Cursor CURSOR_MOVE = SwingUtils.makeCursor(17, 17, new int[]{0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -16777216, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -16777216, -16777216, -16777216, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -16777216, -16777216, -16777216, -16777216, -16777216, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -16777216, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, -1, -16777216, -1, 0, 0, -1, -1, 0, 0, 0, 0, 0, -1, -16777216, -1, 0, 0, -1, -16777216, -1, 0, 0, -1, -16777216, -1, 0, 0, 0, -1, -16777216, -16777216, -1, -1, -1, -1, -16777216, -1, -1, -1, -1, -16777216, -16777216, -1, 0, -1, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -1, 0, -1, -16777216, -16777216, -1, -1, -1, -1, -16777216, -1, -1, -1, -1, -16777216, -16777216, -1, 0, 0, 0, -1, -16777216, -1, 0, 0, -1, -16777216, -1, 0, 0, -1, -16777216, -1, 0, 0, 0, 0, 0, -1, -1, 0, 0, -1, -16777216, -1, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -16777216, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -16777216, -16777216, -16777216, -16777216, -16777216, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -16777216, -16777216, -16777216, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -16777216, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 8, "Move");
    public static final Cursor CURSOR_HAND_OPEN = SwingUtils.makeCursor(16, 16, new int[]{0, 0, 0, 0, 0, 0, 0, -16777216, -16777216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16777216, -16777216, 0, -16777216, -1, -1, -16777216, -16777216, -16777216, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -16777216, -16777216, -1, -1, -16777216, -1, -1, -16777216, 0, 0, 0, 0, 0, -16777216, -1, -1, -16777216, -16777216, -1, -1, -16777216, -1, -1, -16777216, 0, -16777216, 0, 0, 0, 0, -16777216, -1, -1, -16777216, -1, -1, -16777216, -1, -1, -16777216, -16777216, -1, -16777216, 0, 0, 0, -16777216, -1, -1, -16777216, -1, -1, -16777216, -1, -1, -16777216, -1, -1, -16777216, 0, -16777216, -16777216, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, -1, -1, -16777216, -16777216, -1, -1, -16777216, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, -16777216, -1, -1, -1, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0}, 6, 6, "Hand");
    public static final Cursor CURSOR_HAND_CLOSED = SwingUtils.makeCursor(16, 16, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -16777216, -16777216, 0, -16777216, -16777216, 0, -16777216, -16777216, 0, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -16777216, -1, -1, -16777216, -1, -1, -16777216, -16777216, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, -1, -16777216, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, -16777216, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0, 0, 0, 0, 0, 0, -16777216, -1, -1, -1, -1, -1, -1, -16777216, 0, 0, 0}, 6, 6, "HandClosed");

    public static void setOpaque(JPanel jPanel, boolean bl) {
        jPanel.setOpaque(bl);
        int n = jPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JPanel)) continue;
            SwingUtils.setOpaque((JPanel)component, bl);
        }
    }

    public static void setDefaultButton(JRootPane jRootPane, JButton jButton) {
        jRootPane.setDefaultButton(jButton);
    }

    public static void setCancelButton(JRootPane jRootPane, final JButton jButton) {
        jRootPane.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        jRootPane.getActionMap().put("cancel", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.doClick();
            }
        });
    }

    public static void setDontSaveButton(JRootPane jRootPane, final JButton jButton) {
        jRootPane.getInputMap(2).put(KeyStroke.getKeyStroke(68, 0), "dontSave");
        jRootPane.getInputMap(2).put(KeyStroke.getKeyStroke(68, jRootPane.getToolkit().getMenuShortcutKeyMask()), "dontSave");
        jRootPane.getActionMap().put("dontSave", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                jButton.doClick();
            }
        });
    }

    public static BufferedImage toBufferedImage(Image image) {
        int n;
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        boolean bl = false;
        for (n = 0; n < 10 && !(bl = toolkit.prepareImage(image, -1, -1, null)); ++n) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!bl) {
            return null;
        }
        n = -1;
        int n2 = -1;
        for (int i = 0; i < 10; ++i) {
            n = image.getWidth(null);
            n2 = image.getHeight(null);
            if (n > 0 && n2 > 0) break;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (n < 1 || n2 < 1) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        boolean bl2 = false;
        for (int i = 0; i < 10 && !(bl2 = graphics2D.drawImage(image, 0, 0, null)); ++i) {
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        graphics2D.dispose();
        if (!bl2) {
            return null;
        }
        return bufferedImage;
    }

    public static Cursor makeCursor(int n, int n2, int[] nArray, int n3, int n4, String string) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getBestCursorSize(n, n2);
            if (dimension.width <= 0 || dimension.height <= 0) {
                System.err.println("Notice: System does not support custom cursors. Returning generic cursor.");
                return Cursor.getPredefinedCursor(1);
            }
            if (dimension.width < n || dimension.height < n2) {
                dimension = toolkit.getBestCursorSize(n * 2, n2 * 2);
                if (dimension.width < n || dimension.height < n2) {
                    System.err.println("Notice: Tool requested a cursor larger than possible on this system. Returning generic cursor.");
                    return Cursor.getPredefinedCursor(1);
                }
            }
            BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 2);
            bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
            return toolkit.createCustomCursor(bufferedImage, new Point(n3, n4), string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Cursor.getPredefinedCursor(1);
        }
    }
}

