/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

import com.kreative.bitsnpicas.truetype.CmapSubtableSequentialEntry;
import com.kreative.bitsnpicas.truetype.ListBasedCmapSubtable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmapSubtableFormat12
extends ListBasedCmapSubtable<CmapSubtableSequentialEntry> {
    public int languageID = 0;

    @Override
    public int format() {
        return 12;
    }

    @Override
    public int getGlyphIndex(int n) {
        for (CmapSubtableSequentialEntry cmapSubtableSequentialEntry : this) {
            if (!cmapSubtableSequentialEntry.contains(n)) continue;
            return cmapSubtableSequentialEntry.getGlyphIndex(n);
        }
        return 0;
    }

    @Override
    protected void compile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(12);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeInt(16 + this.size() * 12);
        dataOutputStream.writeInt(this.languageID);
        dataOutputStream.writeInt(this.size());
        for (CmapSubtableSequentialEntry cmapSubtableSequentialEntry : this) {
            dataOutputStream.writeInt(cmapSubtableSequentialEntry.startCharCode);
            dataOutputStream.writeInt(cmapSubtableSequentialEntry.endCharCode);
            dataOutputStream.writeInt(cmapSubtableSequentialEntry.glyphIndex);
        }
    }

    @Override
    protected void decompile(DataInputStream dataInputStream, int n) throws IOException {
        dataInputStream.readUnsignedShort();
        dataInputStream.readUnsignedShort();
        dataInputStream.readInt();
        this.languageID = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        this.clear();
        for (int i = 0; i < n2; ++i) {
            CmapSubtableSequentialEntry cmapSubtableSequentialEntry = new CmapSubtableSequentialEntry();
            cmapSubtableSequentialEntry.startCharCode = dataInputStream.readInt();
            cmapSubtableSequentialEntry.endCharCode = dataInputStream.readInt();
            cmapSubtableSequentialEntry.glyphIndex = dataInputStream.readInt();
            this.add(cmapSubtableSequentialEntry);
        }
    }
}

