/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.truetype;

public abstract class PuaaSubtableEntry {
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    public static final int BOOLEAN = 3;
    public static final int DECIMAL = 4;
    public static final int HEXADECIMAL = 5;
    public static final int HEXMULTIPLE = 6;
    public static final int HEXSEQUENCE = 7;
    public static final int CASEMAPPING = 8;
    public static final int NAMEALIAS = 9;
    public int firstCodePoint = 0;
    public int lastCodePoint = 0;

    public boolean contains(int n) {
        return n >= this.firstCodePoint && n <= this.lastCodePoint;
    }

    public abstract String getPropertyValue(int var1);

    public static class NameAlias
    extends PuaaSubtableEntry {
        public String alias = null;
        public String type = null;

        public String getPropertyValue(int n) {
            if (this.alias == null || this.type == null) {
                return null;
            }
            return this.alias + ";" + this.type;
        }
    }

    public static class CaseMapping
    extends PuaaSubtableEntry {
        public int[] values = new int[0];
        public String condition = null;

        public String getPropertyValue(int n) {
            if (this.values == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                String string = Integer.toHexString(this.values[i]).toUpperCase();
                while (string.length() < 4) {
                    string = "0" + string;
                }
                stringBuffer.append(string);
            }
            if (this.condition != null && this.condition.length() > 0) {
                stringBuffer.append("; ");
                stringBuffer.append(this.condition);
            }
            return stringBuffer.toString();
        }
    }

    public static class HexSequence
    extends PuaaSubtableEntry {
        public int[] values = new int[0];

        public String getPropertyValue(int n) {
            if (this.values == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" ");
                }
                String string = Integer.toHexString(this.values[i]).toUpperCase();
                while (string.length() < 4) {
                    string = "0" + string;
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }

    public static class HexMultiple
    extends PuaaSubtableEntry {
        public int[] values = new int[0];

        public String getPropertyValue(int n) {
            if (this.values == null) {
                return null;
            }
            int n2 = this.values[n - this.firstCodePoint];
            String string = Integer.toHexString(n2).toUpperCase();
            while (string.length() < 4) {
                string = "0" + string;
            }
            return string;
        }
    }

    public static class Hexadecimal
    extends PuaaSubtableEntry {
        public int value = 0;

        public String getPropertyValue(int n) {
            String string = Integer.toHexString(this.value).toUpperCase();
            while (string.length() < 4) {
                string = "0" + string;
            }
            return string;
        }
    }

    public static class Decimal
    extends PuaaSubtableEntry {
        public int value = 0;

        public String getPropertyValue(int n) {
            return Integer.toString(this.value);
        }
    }

    public static class Boolean
    extends PuaaSubtableEntry {
        public boolean value = false;

        public String getPropertyValue(int n) {
            return this.value ? "Y" : "N";
        }
    }

    public static class Multiple
    extends PuaaSubtableEntry {
        public String[] values = new String[0];

        public String getPropertyValue(int n) {
            if (this.values == null) {
                return null;
            }
            return this.values[n - this.firstCodePoint];
        }
    }

    public static class Single
    extends PuaaSubtableEntry {
        public String value = null;

        public String getPropertyValue(int n) {
            return this.value;
        }
    }
}

