/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.FontGlyphTransformer;
import com.kreative.bitsnpicas.GlyphPair;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Font<T extends FontGlyph> {
    public static final int NAME_COPYRIGHT = 0;
    public static final int NAME_FAMILY = 1;
    public static final int NAME_STYLE = 2;
    public static final int NAME_UNIQUE_ID = 3;
    public static final int NAME_FAMILY_AND_STYLE = 4;
    public static final int NAME_VERSION = 5;
    public static final int NAME_POSTSCRIPT = 6;
    public static final int NAME_TRADEMARK = 7;
    public static final int NAME_MANUFACTURER = 8;
    public static final int NAME_DESIGNER = 9;
    public static final int NAME_DESCRIPTION = 10;
    public static final int NAME_VENDOR_URL = 11;
    public static final int NAME_DESIGNER_URL = 12;
    public static final int NAME_LICENSE_DESCRIPTION = 13;
    public static final int NAME_LICENSE_URL = 14;
    public static final int NAME_WINDOWS_FAMILY = 16;
    public static final int NAME_WINDOWS_STYLE = 17;
    public static final int NAME_MACOS_FAMILY_AND_STYLE = 18;
    public static final int NAME_SAMPLE_TEXT = 19;
    public static final int NAME_POSTSCRIPT_CID = 20;
    public static final int NAME_WWS_FAMILY = 21;
    public static final int NAME_WWS_STYLE = 22;
    protected SortedMap<Integer, String> names = new TreeMap<Integer, String>();
    protected SortedMap<Integer, T> characters = new TreeMap<Integer, T>();
    protected SortedMap<String, T> namedGlyphs = new TreeMap<String, T>();
    protected SortedMap<GlyphPair, Integer> kernPairs = new TreeMap<GlyphPair, Integer>();
    private static final char[] BASELINE_CHARS = "HXxZzAMNTYilmnEFIKLPRhkrvwVWBDbduftCGJOSUaceos2147035689\u00de\u00c6\u00e6\u00d0\u00d8\u00f8\u00a5\u00a3\u00df&!?.%@\u00b1".toCharArray();
    private static final char[] CAP_HEIGHT_CHARS = "HXTZAMNUVWYEFIJKLBDPRCGOQS5714023689\u00de\u00c6\u00d0\u00d8bdhkl\u00feft\u00a5!?&\u00a3\u00df%@".toCharArray();
    private static final char[] X_HEIGHT_CHARS = "xzuvwymnracegopqs\u00b5\u00e6\u00f8".toCharArray();
    private static final List<Integer> MONOSPACED_CLASSES = Arrays.asList(1, 2, 3, 4, 5, 9, 10, 11, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30);

    public abstract int getEmAscent();

    public abstract int getEmDescent();

    public abstract int getLineAscent();

    public abstract int getLineDescent();

    public abstract int getXHeight();

    public abstract int getCapHeight();

    public abstract int getLineGap();

    public abstract double getEmAscent2D();

    public abstract double getEmDescent2D();

    public abstract double getLineAscent2D();

    public abstract double getLineDescent2D();

    public abstract double getXHeight2D();

    public abstract double getCapHeight2D();

    public abstract double getLineGap2D();

    public abstract void setEmAscent(int var1);

    public abstract void setEmDescent(int var1);

    public abstract void setLineAscent(int var1);

    public abstract void setLineDescent(int var1);

    public abstract void setXHeight(int var1);

    public abstract void setCapHeight(int var1);

    public abstract void setLineGap(int var1);

    public abstract void setEmAscent2D(double var1);

    public abstract void setEmDescent2D(double var1);

    public abstract void setLineAscent2D(double var1);

    public abstract void setLineDescent2D(double var1);

    public abstract void setXHeight2D(double var1);

    public abstract void setCapHeight2D(double var1);

    public abstract void setLineGap2D(double var1);

    public boolean isEmpty() {
        return this.characters.isEmpty() && this.namedGlyphs.isEmpty();
    }

    public boolean containsCharacter(int n) {
        return this.characters.containsKey(n);
    }

    public T getCharacter(int n) {
        return (T)((FontGlyph)this.characters.get(n));
    }

    public T putCharacter(int n, T t) {
        if (t == null) {
            return (T)((FontGlyph)this.characters.remove(n));
        }
        return (T)((FontGlyph)this.characters.put(n, t));
    }

    public T removeCharacter(int n) {
        return (T)((FontGlyph)this.characters.remove(n));
    }

    public SortedMap<Integer, T> characters(boolean bl) {
        if (bl) {
            return new TreeMap<Integer, T>(this.characters);
        }
        return Collections.unmodifiableSortedMap(this.characters);
    }

    public boolean containsNamedGlyph(String string) {
        if (string == null) {
            return false;
        }
        return this.namedGlyphs.containsKey(string);
    }

    public T getNamedGlyph(String string) {
        if (string == null) {
            return null;
        }
        return (T)((FontGlyph)this.namedGlyphs.get(string));
    }

    public T putNamedGlyph(String string, T t) {
        if (string == null) {
            return null;
        }
        if (t == null) {
            return (T)((FontGlyph)this.namedGlyphs.remove(string));
        }
        return (T)((FontGlyph)this.namedGlyphs.put(string, t));
    }

    public T removeNamedGlyph(String string) {
        if (string == null) {
            return null;
        }
        return (T)((FontGlyph)this.namedGlyphs.remove(string));
    }

    public SortedMap<String, T> namedGlyphs(boolean bl) {
        if (bl) {
            return new TreeMap<String, T>(this.namedGlyphs);
        }
        return Collections.unmodifiableSortedMap(this.namedGlyphs);
    }

    public boolean containsName(int n) {
        return this.names.containsKey(n);
    }

    public String getName(int n) {
        return (String)this.names.get(n);
    }

    public String setName(int n, String string) {
        if (string == null) {
            return (String)this.names.remove(n);
        }
        return this.names.put(n, string);
    }

    public String removeName(int n) {
        return (String)this.names.remove(n);
    }

    public SortedMap<Integer, String> names(boolean bl) {
        if (bl) {
            return new TreeMap<Integer, String>(this.names);
        }
        return Collections.unmodifiableSortedMap(this.names);
    }

    public boolean containsKernPair(GlyphPair glyphPair) {
        if (glyphPair == null) {
            return false;
        }
        return this.kernPairs.containsKey(glyphPair);
    }

    public int getKernPair(GlyphPair glyphPair) {
        if (glyphPair == null) {
            return 0;
        }
        Integer n = (Integer)this.kernPairs.get(glyphPair);
        return n != null ? n : 0;
    }

    public int setKernPair(GlyphPair glyphPair, int n) {
        if (glyphPair == null) {
            return 0;
        }
        Integer n2 = this.kernPairs.put(glyphPair, n);
        return n2 != null ? n2 : 0;
    }

    public int removeKernPair(GlyphPair glyphPair) {
        if (glyphPair == null) {
            return 0;
        }
        Integer n = (Integer)this.kernPairs.remove(glyphPair);
        return n != null ? n : 0;
    }

    public SortedMap<GlyphPair, Integer> kernPairs(boolean bl) {
        if (bl) {
            return new TreeMap<GlyphPair, Integer>(this.kernPairs);
        }
        return Collections.unmodifiableSortedMap(this.kernPairs);
    }

    public int guessBaselineAdjustment() {
        for (char c : BASELINE_CHARS) {
            FontGlyph fontGlyph = (FontGlyph)this.characters.get(c);
            if (fontGlyph == null) continue;
            return fontGlyph.getGlyphHeight() - fontGlyph.getGlyphAscent();
        }
        return 0;
    }

    public double guessBaselineAdjustment2D() {
        for (char c : BASELINE_CHARS) {
            FontGlyph fontGlyph = (FontGlyph)this.characters.get(c);
            if (fontGlyph == null) continue;
            return fontGlyph.getGlyphHeight2D() - fontGlyph.getGlyphAscent2D();
        }
        return 0.0;
    }

    public int guessCapHeight() {
        for (char c : CAP_HEIGHT_CHARS) {
            FontGlyph fontGlyph = (FontGlyph)this.characters.get(c);
            if (fontGlyph == null) continue;
            return fontGlyph.getGlyphAscent();
        }
        return 0;
    }

    public double guessCapHeight2D() {
        for (char c : CAP_HEIGHT_CHARS) {
            FontGlyph fontGlyph = (FontGlyph)this.characters.get(c);
            if (fontGlyph == null) continue;
            return fontGlyph.getGlyphAscent2D();
        }
        return 0.0;
    }

    public int guessXHeight() {
        for (char c : X_HEIGHT_CHARS) {
            FontGlyph fontGlyph = (FontGlyph)this.characters.get(c);
            if (fontGlyph == null) continue;
            return fontGlyph.getGlyphAscent();
        }
        return 0;
    }

    public double guessXHeight2D() {
        for (char c : X_HEIGHT_CHARS) {
            FontGlyph fontGlyph = (FontGlyph)this.characters.get(c);
            if (fontGlyph == null) continue;
            return fontGlyph.getGlyphAscent2D();
        }
        return 0.0;
    }

    public boolean isMonospaced() {
        FontGlyph fontGlyph = (FontGlyph)this.characters.get(32);
        int n = fontGlyph != null ? fontGlyph.getCharacterWidth() : 0;
        for (Map.Entry<Integer, T> entry : this.characters.entrySet()) {
            Integer n2;
            if (((FontGlyph)entry.getValue()).getCharacterWidth() == n || !MONOSPACED_CLASSES.contains(n2 = Integer.valueOf(Character.getType(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public boolean isBoldStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("BOLD") || string.contains("BLACK") || string.contains("HEAVY");
        }
        return false;
    }

    public boolean isItalicStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("ITALIC") || string.contains("OBLIQUE") || string.contains("SLANT") || string.contains("ROTALIC");
        }
        return false;
    }

    public boolean isUnderlineStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("UNDERLINE") || string.contains("UNDERSCORE");
        }
        return false;
    }

    public boolean isOutlineStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("OUTLINE");
        }
        return false;
    }

    public boolean isShadowStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("SHADOW");
        }
        return false;
    }

    public boolean isCondensedStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("CONDENSE") || string.contains("NARROW");
        }
        return false;
    }

    public boolean isExtendedStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("EXTEND") || string.contains("EXPAND") || string.contains("WIDE");
        }
        return false;
    }

    public boolean isNegativeStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("NEGATIVE") || string.contains("REVERSE") || string.contains("INVERSE") || string.contains("INVERT");
        }
        return false;
    }

    public boolean isStrikeoutStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("STRIKEOUT") || string.contains("STRIKETHR");
        }
        return false;
    }

    public boolean isRegularStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).trim();
            return string.equalsIgnoreCase("") || string.equalsIgnoreCase("PLAIN") || string.equalsIgnoreCase("REGULAR") || string.equalsIgnoreCase("NORMAL") || string.equalsIgnoreCase("MEDIUM");
        }
        return false;
    }

    public boolean isObliqueStyle() {
        if (this.names.containsKey(2)) {
            String string = ((String)this.names.get(2)).toUpperCase();
            return string.contains("OBLIQUE") || string.contains("SLANT");
        }
        return false;
    }

    public int getMacStyle() {
        int n = 0;
        if (this.isBoldStyle()) {
            n |= 1;
        }
        if (this.isItalicStyle()) {
            n |= 2;
        }
        if (this.isUnderlineStyle()) {
            n |= 4;
        }
        if (this.isOutlineStyle()) {
            n |= 8;
        }
        if (this.isShadowStyle()) {
            n |= 0x10;
        }
        if (this.isCondensedStyle()) {
            n |= 0x20;
        }
        if (this.isExtendedStyle()) {
            n |= 0x40;
        }
        return n;
    }

    public int getFsSelection() {
        int n = 0;
        if (this.isItalicStyle()) {
            n |= 1;
        }
        if (this.isUnderlineStyle()) {
            n |= 2;
        }
        if (this.isNegativeStyle()) {
            n |= 4;
        }
        if (this.isOutlineStyle()) {
            n |= 8;
        }
        if (this.isStrikeoutStyle()) {
            n |= 0x10;
        }
        if (this.isBoldStyle()) {
            n |= 0x20;
        }
        if (this.isRegularStyle()) {
            n |= 0x40;
        }
        if (this.isObliqueStyle()) {
            n |= 0x200;
        }
        return n;
    }

    public void autoFillNames() {
        CharSequence charSequence;
        String string;
        String string2 = string = this.names.containsKey(1) ? (String)this.names.get(1) : "Untitled";
        if (!(!this.names.containsKey(2) || ((String)(charSequence = ((String)this.names.get(2)).trim())).equalsIgnoreCase("") || ((String)charSequence).equalsIgnoreCase("Plain") || ((String)charSequence).equalsIgnoreCase("Regular") || ((String)charSequence).equalsIgnoreCase("Normal") || ((String)charSequence).equalsIgnoreCase("Medium"))) {
            string = string + " " + (String)charSequence;
        }
        charSequence = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (c > ' ' && c < '\u007f' && Character.isLetterOrDigit(c)) {
                ((StringBuffer)charSequence).append(c);
            }
            c = stringCharacterIterator.next();
        }
        String string3 = ((StringBuffer)charSequence).toString();
        if (!this.names.containsKey(1)) {
            this.names.put(1, "Untitled");
        }
        if (!this.names.containsKey(2)) {
            this.names.put(2, "Regular");
        }
        if (!this.names.containsKey(3)) {
            this.names.put(3, "BitsNPicas: " + string3 + ": " + new GregorianCalendar().get(1));
        }
        if (!this.names.containsKey(4)) {
            this.names.put(4, string);
        }
        if (!this.names.containsKey(5)) {
            this.names.put(5, "Version 1.0");
        }
        if (!this.names.containsKey(6)) {
            this.names.put(6, string3);
        }
        if (!this.names.containsKey(8)) {
            this.names.put(8, "Made with Bits'n'Picas by Kreative Software");
        }
        if (!this.names.containsKey(11)) {
            this.names.put(11, "http://www.kreativekorp.com/software/bitsnpicas/");
        }
    }

    public void subsetRemap(Collection<GlyphPair> collection) {
        SortedMap<Integer, T> sortedMap = this.characters;
        SortedMap<String, T> sortedMap2 = this.namedGlyphs;
        this.characters = new TreeMap<Integer, T>();
        this.namedGlyphs = new TreeMap<String, T>();
        SortedMap<Integer, T> sortedMap3 = this.characters;
        SortedMap<String, T> sortedMap4 = this.namedGlyphs;
        for (GlyphPair glyphPair : collection) {
            FontGlyph fontGlyph;
            Object object = glyphPair.getLeft();
            Object object2 = glyphPair.getRight();
            if (object instanceof Integer) {
                fontGlyph = (FontGlyph)sortedMap.get(object);
                if (fontGlyph == null) continue;
                if (object2 instanceof Integer) {
                    sortedMap3.put((Integer)object2, fontGlyph);
                }
                if (object2 instanceof String) {
                    sortedMap4.put((String)object2, fontGlyph);
                }
            }
            if (!(object instanceof String) || (fontGlyph = (FontGlyph)sortedMap2.get(object)) == null) continue;
            if (object2 instanceof Integer) {
                sortedMap3.put((Integer)object2, fontGlyph);
            }
            if (!(object2 instanceof String)) continue;
            sortedMap4.put((String)object2, fontGlyph);
        }
    }

    public void transform(FontGlyphTransformer<T> fontGlyphTransformer) {
        FontGlyph fontGlyph;
        for (Map.Entry<Integer, T> entry : this.characters(true).entrySet()) {
            fontGlyph = fontGlyphTransformer.transformGlyph((FontGlyph)entry.getValue());
            if (fontGlyph == null) continue;
            this.characters.put(entry.getKey(), fontGlyph);
        }
        for (Map.Entry<Object, T> entry : this.namedGlyphs(true).entrySet()) {
            fontGlyph = fontGlyphTransformer.transformGlyph((FontGlyph)entry.getValue());
            if (fontGlyph == null) continue;
            this.namedGlyphs.put((String)entry.getKey(), fontGlyph);
        }
    }

    public String toString() {
        if (this.names.containsKey(4)) {
            return (String)this.names.get(4);
        }
        if (this.names.containsKey(1)) {
            if (this.names.containsKey(2)) {
                return (String)this.names.get(1) + " " + (String)this.names.get(2);
            }
            return (String)this.names.get(1);
        }
        if (this.names.containsKey(16)) {
            if (this.names.containsKey(17)) {
                return (String)this.names.get(16) + " " + (String)this.names.get(17);
            }
            return (String)this.names.get(16);
        }
        if (this.names.containsKey(18)) {
            return (String)this.names.get(18);
        }
        if (this.names.containsKey(21)) {
            if (this.names.containsKey(22)) {
                return (String)this.names.get(21) + " " + (String)this.names.get(22);
            }
            return (String)this.names.get(21);
        }
        if (this.names.containsKey(6)) {
            return (String)this.names.get(6);
        }
        return "Untitled";
    }
}

