/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.Font;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PointSizeGenerator {
    public abstract void setRange(int var1, int var2);

    public abstract void setPointSizes(int ... var1);

    public abstract int generatePointSize(Font<?> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Standard
    extends PointSizeGenerator {
        private int[] pointSizes;

        public Standard(int ... nArray) {
            this.pointSizes = nArray;
        }

        @Override
        public void setRange(int n, int n2) {
        }

        @Override
        public void setPointSizes(int ... nArray) {
            this.pointSizes = nArray;
        }

        @Override
        public int generatePointSize(Font<?> font) {
            int n = font.getEmAscent() + font.getEmDescent();
            if (n <= this.pointSizes[0]) {
                return this.pointSizes[0];
            }
            int n2 = this.pointSizes.length - 1;
            for (int i = 0; i < n2; ++i) {
                if (n > (this.pointSizes[i] + this.pointSizes[i + 1]) / 2) continue;
                return this.pointSizes[i];
            }
            return this.pointSizes[n2];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Automatic
    extends PointSizeGenerator {
        private int min;
        private int max;

        public Automatic(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        @Override
        public void setRange(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        @Override
        public void setPointSizes(int ... nArray) {
        }

        @Override
        public int generatePointSize(Font<?> font) {
            int n = font.getEmAscent() + font.getEmDescent();
            return n < this.min ? this.min : (n > this.max ? this.max : n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Fixed
    extends PointSizeGenerator {
        private int pointSize;

        public Fixed(int n) {
            this.pointSize = n;
        }

        @Override
        public void setRange(int n, int n2) {
        }

        @Override
        public void setPointSizes(int ... nArray) {
        }

        @Override
        public int generatePointSize(Font<?> font) {
            return this.pointSize;
        }
    }
}

