/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas;

import com.kreative.bitsnpicas.FontGlyph;
import com.kreative.bitsnpicas.VectorPath;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorFontGlyph
extends FontGlyph {
    protected List<VectorPath> contours = new ArrayList<VectorPath>();
    protected double advance;

    public VectorFontGlyph() {
        this.advance = 0.0;
    }

    public VectorFontGlyph(Collection<? extends VectorPath> collection) {
        this.contours.addAll(collection);
        if (collection.isEmpty()) {
            this.advance = 0.0;
        } else {
            VectorPath vectorPath = collection.iterator().next();
            Rectangle2D rectangle2D = vectorPath.toGeneralPath().getBounds2D();
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            for (VectorPath vectorPath2 : collection) {
                Rectangle2D rectangle2D2 = vectorPath2.toGeneralPath().getBounds2D();
                double d3 = rectangle2D2.getMinX();
                double d4 = rectangle2D2.getMaxX();
                if (d3 < d) {
                    d = d3;
                }
                if (!(d4 > d2)) continue;
                d2 = d4;
            }
            this.advance = d + d2;
        }
    }

    public VectorFontGlyph(Collection<? extends VectorPath> collection, double d) {
        this.contours.addAll(collection);
        this.advance = d;
    }

    public Collection<VectorPath> getContours() {
        return this.contours;
    }

    @Override
    public int getGlyphOffset() {
        if (this.contours.isEmpty()) {
            return 0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle rectangle = vectorPath.toGeneralPath().getBounds();
        int n = rectangle.x;
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle rectangle2 = vectorPath2.toGeneralPath().getBounds();
            int n2 = rectangle2.x;
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public double getGlyphOffset2D() {
        if (this.contours.isEmpty()) {
            return 0.0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle2D rectangle2D = vectorPath.toGeneralPath().getBounds2D();
        double d = rectangle2D.getMinX();
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle2D rectangle2D2 = vectorPath2.toGeneralPath().getBounds2D();
            double d2 = rectangle2D2.getMinX();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public int getGlyphWidth() {
        if (this.contours.isEmpty()) {
            return 0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle rectangle = vectorPath.toGeneralPath().getBounds();
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle rectangle2 = vectorPath2.toGeneralPath().getBounds();
            int n3 = rectangle2.x;
            int n4 = rectangle2.x + rectangle2.width;
            if (n3 < n) {
                n = n3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return n2 - n;
    }

    @Override
    public double getGlyphWidth2D() {
        if (this.contours.isEmpty()) {
            return 0.0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle2D rectangle2D = vectorPath.toGeneralPath().getBounds2D();
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMaxX();
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle2D rectangle2D2 = vectorPath2.toGeneralPath().getBounds2D();
            double d3 = rectangle2D2.getMinX();
            double d4 = rectangle2D2.getMaxX();
            if (d3 < d) {
                d = d3;
            }
            if (!(d4 > d2)) continue;
            d2 = d4;
        }
        return d2 - d;
    }

    @Override
    public int getGlyphHeight() {
        if (this.contours.isEmpty()) {
            return 0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle rectangle = vectorPath.toGeneralPath().getBounds();
        int n = rectangle.y;
        int n2 = rectangle.y + rectangle.height;
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle rectangle2 = vectorPath2.toGeneralPath().getBounds();
            int n3 = rectangle2.y;
            int n4 = rectangle2.y + rectangle2.height;
            if (n3 < n) {
                n = n3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return n2 - n;
    }

    @Override
    public double getGlyphHeight2D() {
        if (this.contours.isEmpty()) {
            return 0.0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle2D rectangle2D = vectorPath.toGeneralPath().getBounds2D();
        double d = rectangle2D.getMinY();
        double d2 = rectangle2D.getMaxY();
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle2D rectangle2D2 = vectorPath2.toGeneralPath().getBounds2D();
            double d3 = rectangle2D2.getMinY();
            double d4 = rectangle2D2.getMaxY();
            if (d3 < d) {
                d = d3;
            }
            if (!(d4 > d2)) continue;
            d2 = d4;
        }
        return d2 - d;
    }

    @Override
    public int getGlyphAscent() {
        if (this.contours.isEmpty()) {
            return 0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle rectangle = vectorPath.toGeneralPath().getBounds();
        int n = rectangle.y;
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle rectangle2 = vectorPath2.toGeneralPath().getBounds();
            int n2 = rectangle2.y;
            if (n2 >= n) continue;
            n = n2;
        }
        return -n;
    }

    @Override
    public double getGlyphAscent2D() {
        if (this.contours.isEmpty()) {
            return 0.0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle2D rectangle2D = vectorPath.toGeneralPath().getBounds2D();
        double d = rectangle2D.getMinY();
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle2D rectangle2D2 = vectorPath2.toGeneralPath().getBounds2D();
            double d2 = rectangle2D2.getMinY();
            if (!(d2 < d)) continue;
            d = d2;
        }
        return -d;
    }

    @Override
    public int getGlyphDescent() {
        if (this.contours.isEmpty()) {
            return 0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle rectangle = vectorPath.toGeneralPath().getBounds();
        int n = rectangle.y + rectangle.height;
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle rectangle2 = vectorPath2.toGeneralPath().getBounds();
            int n2 = rectangle2.y + rectangle2.height;
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public double getGlyphDescent2D() {
        if (this.contours.isEmpty()) {
            return 0.0;
        }
        VectorPath vectorPath = this.contours.iterator().next();
        Rectangle2D rectangle2D = vectorPath.toGeneralPath().getBounds2D();
        double d = rectangle2D.getMaxY();
        for (VectorPath vectorPath2 : this.contours) {
            Rectangle2D rectangle2D2 = vectorPath2.toGeneralPath().getBounds2D();
            double d2 = rectangle2D2.getMaxY();
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public int getCharacterWidth() {
        return (int)Math.ceil(this.advance);
    }

    @Override
    public double getCharacterWidth2D() {
        return this.advance;
    }

    @Override
    public void setCharacterWidth(int n) {
        this.advance = n;
    }

    @Override
    public void setCharacterWidth2D(double d) {
        this.advance = d;
    }

    @Override
    public double paint(Graphics graphics, double d, double d2, double d3) {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(d3, d3);
        for (VectorPath vectorPath : this.contours) {
            GeneralPath generalPath = vectorPath.toGeneralPath();
            Shape shape = affineTransform2.createTransformedShape(generalPath);
            Shape shape2 = affineTransform.createTransformedShape(shape);
            ((Graphics2D)graphics).draw(shape2);
        }
        return this.advance * d3;
    }
}

