/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.GlyphListCodePointModel;
import com.kreative.bitsnpicas.edit.GlyphListFontModel;
import com.kreative.bitsnpicas.edit.GlyphListModel;
import com.kreative.bitsnpicas.edit.glmlicon.GLMLTreeCellRenderer;
import com.kreative.unicode.data.Block;
import com.kreative.unicode.data.BlockList;
import com.kreative.unicode.data.Encoding;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.EncodingTable;
import com.kreative.unicode.data.GlyphList;
import com.kreative.unicode.data.GlyphLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphListModelList
extends JTree {
    private static final long serialVersionUID = 1L;
    public static final int SEQUENCE_MARKER = -54506;
    public static final int SUBTABLE_MARKER = -57683;
    public static final int UNDEFINED_MARKER = -17711;

    public GlyphListModelList(Font<?> font) {
        super(new GlyphListModelRootNode(font));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setLargeModel(true);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new GLMLTreeCellRenderer());
        this.setVisibleRowCount(16);
    }

    public GlyphListModel getSelectedModel() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof GlyphListModelTreeNode)) {
            return null;
        }
        return ((GlyphListModelTreeNode)object).getModel();
    }

    public void setSelectedModel(GlyphListModel glyphListModel, boolean bl) {
        Object object = this.getModel().getRoot();
        if (!(object instanceof GlyphListModelTreeNode)) {
            return;
        }
        GlyphListModelTreeNode glyphListModelTreeNode = (GlyphListModelTreeNode)object;
        TreePath treePath = this.findGlyphListModel(glyphListModel, glyphListModelTreeNode, new TreePath(glyphListModelTreeNode));
        if (treePath != null) {
            this.setSelectionPath(treePath);
            if (bl) {
                this.scrollPathToVisible(treePath);
            }
        }
    }

    private TreePath findGlyphListModel(GlyphListModel glyphListModel, GlyphListModelTreeNode glyphListModelTreeNode, TreePath treePath) {
        if (GlyphListModelList.hasModel(glyphListModel, glyphListModelTreeNode)) {
            return treePath;
        }
        for (GlyphListModelTreeNode glyphListModelTreeNode2 : glyphListModelTreeNode.getChildren()) {
            TreePath treePath2 = this.findGlyphListModel(glyphListModel, glyphListModelTreeNode2, treePath.pathByAddingChild(glyphListModelTreeNode2));
            if (treePath2 == null) continue;
            return treePath2;
        }
        return null;
    }

    private static boolean hasModel(GlyphListModel glyphListModel, GlyphListModelTreeNode glyphListModelTreeNode) {
        GlyphListModel glyphListModel2 = glyphListModelTreeNode.getModel();
        if (glyphListModel == null) {
            return glyphListModel2 == null;
        }
        if (glyphListModel2 == null) {
            return glyphListModel == null;
        }
        return glyphListModel.equals(glyphListModel2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GlyphListModelTreeNode
    implements TreeNode {
        protected final GlyphListModelTreeNode parent;
        protected final GlyphListModel model;
        protected final List<GlyphListModelTreeNode> children;

        public GlyphListModelTreeNode(GlyphListModelTreeNode glyphListModelTreeNode, GlyphListModel glyphListModel) {
            this.parent = glyphListModelTreeNode;
            this.model = glyphListModel;
            this.children = new ArrayList<GlyphListModelTreeNode>();
        }

        @Override
        public final GlyphListModelTreeNode getParent() {
            return this.parent;
        }

        public final GlyphListModel getModel() {
            return this.model;
        }

        public final List<GlyphListModelTreeNode> getChildren() {
            return this.children;
        }

        public final Enumeration<GlyphListModelTreeNode> children() {
            return new Enumeration<GlyphListModelTreeNode>(){
                private final Iterator<GlyphListModelTreeNode> iter;
                {
                    this.iter = GlyphListModelTreeNode.this.children.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iter.hasNext();
                }

                @Override
                public GlyphListModelTreeNode nextElement() {
                    return this.iter.next();
                }
            };
        }

        @Override
        public final boolean getAllowsChildren() {
            return !this.children.isEmpty();
        }

        @Override
        public final GlyphListModelTreeNode getChildAt(int n) {
            return this.children.get(n);
        }

        @Override
        public final int getChildCount() {
            return this.children.size();
        }

        @Override
        public final int getIndex(TreeNode treeNode) {
            return this.children.indexOf(treeNode);
        }

        @Override
        public final boolean isLeaf() {
            return this.children.isEmpty();
        }

        public final String toString() {
            return this.model != null ? this.model.toString() : null;
        }
    }

    private static class GlyphListModelEncodingNode
    extends GlyphListModelTreeNode {
        public GlyphListModelEncodingNode(GlyphListModelTreeNode glyphListModelTreeNode, Encoding encoding) {
            super(glyphListModelTreeNode, GlyphListModelEncodingNode.fromEncodingTable(encoding, false, encoding.getName(), false));
            for (int i = 0; i < 256; ++i) {
                String string;
                GlyphListCodePointModel glyphListCodePointModel;
                EncodingTable encodingTable = encoding.getSubtable(i);
                if (encodingTable == null || (glyphListCodePointModel = GlyphListModelEncodingNode.fromEncodingTable(encodingTable, true, string = "Subtable " + Integer.toHexString(0xFF00 | i).substring(2).toUpperCase(), true)) == null) continue;
                this.children.add(new GlyphListModelEncodingNode(this, encodingTable, glyphListCodePointModel));
            }
        }

        private GlyphListModelEncodingNode(GlyphListModelTreeNode glyphListModelTreeNode, EncodingTable encodingTable, GlyphListCodePointModel glyphListCodePointModel) {
            super(glyphListModelTreeNode, glyphListCodePointModel);
            for (int i = 0; i < 256; ++i) {
                String string;
                GlyphListCodePointModel glyphListCodePointModel2;
                EncodingTable encodingTable2 = encodingTable.getSubtable(i);
                if (encodingTable2 == null || (glyphListCodePointModel2 = GlyphListModelEncodingNode.fromEncodingTable(encodingTable2, true, string = glyphListCodePointModel.toString() + " " + Integer.toHexString(0xFF00 | i).substring(2).toUpperCase(), true)) == null) continue;
                this.children.add(new GlyphListModelEncodingNode(this, encodingTable2, glyphListCodePointModel2));
            }
        }

        private static GlyphListCodePointModel fromEncodingTable(EncodingTable encodingTable, boolean bl, String string, boolean bl2) {
            Integer[] integerArray = new Integer[256];
            for (int i = 0; i < 256; ++i) {
                String string2 = encodingTable.getSequence(i);
                if (string2 != null && string2.length() > 0) {
                    if (string2.codePointCount(0, string2.length()) == 1) {
                        integerArray[i] = string2.codePointAt(0);
                    } else if (string2.length() == 2) {
                        int n = string2.charAt(0) & 0xFFFF;
                        int n2 = string2.charAt(1) & 0xFFFF;
                        integerArray[i] = n < 32 || n > 65533 || n2 < 32 || n2 > 65533 ? -54506 : n << 16 | n2;
                    } else {
                        integerArray[i] = -54506;
                    }
                    bl = false;
                    continue;
                }
                integerArray[i] = encodingTable.getSubtable(i) != null ? Integer.valueOf(-57683) : Integer.valueOf(-17711);
            }
            if (bl) {
                return null;
            }
            return new GlyphListCodePointModel(Arrays.asList(integerArray), string, null, bl2 ? "subtable" : "encoding");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlyphListModelRootNode
    extends GlyphListModelTreeNode {
        public GlyphListModelRootNode(Font<?> font) {
            super(null, null);
            GlyphListModelTreeNode glyphListModelTreeNode = new GlyphListModelTreeNode(this, new GlyphListFontModel(font, true, true, "All Glyphs in Font"));
            glyphListModelTreeNode.children.add(new GlyphListModelTreeNode(this, new GlyphListFontModel(font, true, false, "All Code Points in Font")));
            glyphListModelTreeNode.children.add(new GlyphListModelTreeNode(this, new GlyphListFontModel(font, false, true, "All Named Glyphs in Font")));
            this.children.add(glyphListModelTreeNode);
            Iterator<Block> iterator = BlockList.instance().iterator();
            if (iterator.hasNext()) {
                GlyphListModelTreeNode glyphListModelTreeNode2 = new GlyphListModelTreeNode(this, new GlyphListCodePointModel(iterator.next()));
                while (iterator.hasNext()) {
                    glyphListModelTreeNode2.children.add(new GlyphListModelTreeNode(this, new GlyphListCodePointModel(iterator.next())));
                }
                this.children.add(glyphListModelTreeNode2);
            }
            for (GlyphList comparable : GlyphLists.instance()) {
                this.children.add(new GlyphListModelTreeNode(this, new GlyphListCodePointModel(comparable, comparable.getName(), null, "glyphlist")));
            }
            for (Encoding encoding : EncodingList.instance().encodings()) {
                this.children.add(new GlyphListModelEncodingNode((GlyphListModelTreeNode)this, encoding));
            }
        }
    }
}

