/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.exporter;

import com.kreative.bitsnpicas.IDGenerator;
import com.kreative.bitsnpicas.PointSizeGenerator;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class BitmapExportMacPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JRadioButton macFontIdAuto = new JRadioButton("Auto");
    private final JRadioButton macFontIdManual = new JRadioButton("Manual:");
    private final SpinnerNumberModel macFontId = new SpinnerNumberModel(128, 128, Short.MAX_VALUE, 1);
    private final JRadioButton macFontSizeAutoAny = new JRadioButton("Auto (Unrestricted)");
    private final JRadioButton macFontSizeAutoStandard = new JRadioButton("Auto (Standard Sizes)");
    private final JRadioButton macFontSizeManual = new JRadioButton("Manual:");
    private final SpinnerNumberModel macFontSize = new SpinnerNumberModel(12, 1, 127, 1);
    private final JComboBox macEncoding = new JComboBox<Object>(EncodingList.instance().glyphLists().toArray());

    public BitmapExportMacPanel() {
        this.macFontIdAuto.setSelected(true);
        this.macFontSizeAutoAny.setSelected(true);
        this.macEncoding.setEditable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.macFontIdAuto);
        buttonGroup.add(this.macFontIdManual);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.macFontSizeAutoAny);
        buttonGroup2.add(this.macFontSizeAutoStandard);
        buttonGroup2.add(this.macFontSizeManual);
        JPanel jPanel = new JPanel(new BorderLayout(8, 8));
        jPanel.add((Component)this.macFontIdManual, "Before");
        jPanel.add((Component)new JSpinner(this.macFontId), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(8, 8));
        jPanel2.add((Component)this.macFontSizeManual, "Before");
        jPanel2.add((Component)new JSpinner(this.macFontSize), "Center");
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel3.add(new JLabel("Macintosh Font ID"));
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel("Macintosh Font Size"));
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel(" "));
        jPanel3.add(new JLabel("Encoding"));
        JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel4.add(this.macFontIdAuto);
        jPanel4.add(jPanel);
        jPanel4.add(this.macFontSizeAutoAny);
        jPanel4.add(this.macFontSizeAutoStandard);
        jPanel4.add(jPanel2);
        jPanel4.add(this.macEncoding);
        JPanel jPanel5 = new JPanel(new BorderLayout(8, 8));
        jPanel5.add((Component)jPanel3, "Before");
        jPanel5.add((Component)jPanel4, "Center");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jPanel5, "Before");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel6, "First");
    }

    public GlyphList getSelectedEncoding() {
        return (GlyphList)this.macEncoding.getSelectedItem();
    }

    public void setSelectedEncoding(GlyphList glyphList) {
        this.macEncoding.setSelectedItem(glyphList);
    }

    public IDGenerator getIDGenerator() {
        if (this.macFontIdManual.isSelected()) {
            int n = this.macFontId.getNumber().intValue();
            return new IDGenerator.Sequential(n, 128, 32768);
        }
        return new IDGenerator.HashCode(128, 32768);
    }

    public PointSizeGenerator getPointSizeGenerator() {
        if (this.macFontSizeManual.isSelected()) {
            int n = this.macFontSize.getNumber().intValue();
            return new PointSizeGenerator.Fixed(n);
        }
        if (this.macFontSizeAutoStandard.isSelected()) {
            return new PointSizeGenerator.Standard(9, 10, 12, 14, 18, 24, 36, 48, 72);
        }
        return new PointSizeGenerator.Automatic(4, 127);
    }
}

