/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.IDGenerator;
import com.kreative.bitsnpicas.PointSizeGenerator;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportColorPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportEncodingPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportFONTXPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportFormat;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportGEOSPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportLabelPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportMacPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportOTBPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportOptions;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportPSFPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportPlaydatePanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportTTFPanel;
import com.kreative.bitsnpicas.edit.exporter.BitmapExportU8MPanel;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BitmapExportPanel
extends JPanel
implements BitmapExportOptions {
    private static final long serialVersionUID = 1L;
    private final BitmapFont font;
    private final JComboBox format;
    private final BitmapExportTTFPanel ttfPanel;
    private final BitmapExportOTBPanel otbPanel;
    private final BitmapExportGEOSPanel geosPanel;
    private final BitmapExportMacPanel macPanel;
    private final BitmapExportEncodingPanel encodingPanel;
    private final BitmapExportFONTXPanel fontxPanel;
    private final BitmapExportU8MPanel u8mPanel;
    private final BitmapExportColorPanel colorPanel;
    private final BitmapExportPSFPanel psfPanel;
    private final BitmapExportPlaydatePanel playdatePanel;
    private final JButton exportButton;

    public BitmapExportPanel(BitmapFont bitmapFont) {
        this.font = bitmapFont;
        this.format = new JComboBox<BitmapExportFormat>(BitmapExportFormat.values());
        this.ttfPanel = new BitmapExportTTFPanel();
        this.otbPanel = new BitmapExportOTBPanel();
        this.geosPanel = new BitmapExportGEOSPanel();
        this.macPanel = new BitmapExportMacPanel();
        this.encodingPanel = new BitmapExportEncodingPanel();
        this.fontxPanel = new BitmapExportFONTXPanel();
        this.u8mPanel = new BitmapExportU8MPanel();
        this.colorPanel = new BitmapExportColorPanel();
        this.psfPanel = new BitmapExportPSFPanel();
        this.playdatePanel = new BitmapExportPlaydatePanel();
        this.exportButton = new JButton("Export");
        BitmapExportLabelPanel bitmapExportLabelPanel = new BitmapExportLabelPanel("This format has no options.");
        BitmapExportLabelPanel bitmapExportLabelPanel2 = new BitmapExportLabelPanel("<html><center>Version 1.x only supports basic metrics, names,<br>and mapped characters. Other features, such<br>as named glyphs and kerning pairs, will be lost.</center></html>");
        final CardLayout cardLayout = new CardLayout();
        final JPanel jPanel = new JPanel(cardLayout);
        jPanel.add((Component)this.ttfPanel, "ttf");
        jPanel.add((Component)this.otbPanel, "otb");
        jPanel.add((Component)this.geosPanel, "geos");
        jPanel.add((Component)this.macPanel, "mac");
        jPanel.add((Component)this.encodingPanel, "encoding");
        jPanel.add((Component)this.fontxPanel, "fontx");
        jPanel.add((Component)this.u8mPanel, "u8m");
        jPanel.add((Component)this.colorPanel, "color");
        jPanel.add((Component)this.psfPanel, "psf");
        jPanel.add((Component)this.playdatePanel, "playdate");
        jPanel.add((Component)bitmapExportLabelPanel2, "v1");
        jPanel.add((Component)bitmapExportLabelPanel, "none");
        this.format.setEditable(false);
        this.format.setMaximumRowCount(BitmapExportFormat.values().length);
        this.format.setSelectedItem((Object)BitmapExportFormat.TTF);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.exportButton);
        JPanel jPanel3 = new JPanel(new BorderLayout(8, 8));
        jPanel3.add((Component)this.format, "First");
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "Last");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel3, "Center");
        this.format.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BitmapExportFormat bitmapExportFormat = (BitmapExportFormat)((Object)BitmapExportPanel.this.format.getSelectedItem());
                cardLayout.show(jPanel, bitmapExportFormat.cardName);
                GlyphList glyphList = bitmapExportFormat.defaultEncodingName == null ? null : EncodingList.instance().getGlyphList(bitmapExportFormat.defaultEncodingName);
                BitmapExportPanel.this.macPanel.setSelectedEncoding(glyphList);
                BitmapExportPanel.this.encodingPanel.setSelectedEncoding(glyphList);
                BitmapExportPanel.this.u8mPanel.setSelectedEncoding(glyphList);
                Window window = BitmapExportPanel.this.getMyContainingWindow();
                if (window != null) {
                    window.pack();
                }
            }
        });
        this.exportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BitmapExportFormat bitmapExportFormat = (BitmapExportFormat)((Object)BitmapExportPanel.this.format.getSelectedItem());
                if (bitmapExportFormat == null) {
                    return;
                }
                BitmapFontExporter bitmapFontExporter = bitmapExportFormat.createExporter(BitmapExportPanel.this);
                if (bitmapFontExporter == null) {
                    return;
                }
                File file = Main.getSaveFile(bitmapExportFormat.suffix);
                if (file == null) {
                    return;
                }
                if (bitmapExportFormat.macResFork) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    file = new File(file, "..namedfork");
                    file = new File(file, "rsrc");
                }
                if (Main.saveFont(file, bitmapFontExporter, BitmapExportPanel.this.font)) {
                    if (bitmapExportFormat.macResFork) {
                        file = file.getParentFile().getParentFile();
                    }
                    try {
                        bitmapExportFormat.postProcess(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Window window = BitmapExportPanel.this.getMyContainingWindow();
                    if (window != null) {
                        window.dispose();
                    }
                }
            }
        });
    }

    private Window getMyContainingWindow() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window)) continue;
            return (Window)container;
        }
        return null;
    }

    public Dimension getPixelDimension() {
        return this.ttfPanel.getPixelDimension();
    }

    public boolean getExtendWinMetrics() {
        BitmapExportFormat bitmapExportFormat = (BitmapExportFormat)((Object)this.format.getSelectedItem());
        if (bitmapExportFormat.cardName.equals("otb")) {
            return this.otbPanel.getExtendWinMetrics();
        }
        return this.ttfPanel.getExtendWinMetrics();
    }

    public int getSelectedColor() {
        return this.colorPanel.getSelectedColor();
    }

    public Integer getLoadAddress() {
        return this.u8mPanel.getLoadAddress();
    }

    public GlyphList getSelectedEncoding() {
        BitmapExportFormat bitmapExportFormat = (BitmapExportFormat)((Object)this.format.getSelectedItem());
        if (bitmapExportFormat.cardName.equals("mac")) {
            return this.macPanel.getSelectedEncoding();
        }
        if (bitmapExportFormat.cardName.equals("u8m")) {
            return this.u8mPanel.getSelectedEncoding();
        }
        if (bitmapExportFormat.cardName.equals("fontx")) {
            return this.fontxPanel.getSelectedSingleByteEncoding();
        }
        return this.encodingPanel.getSelectedEncoding();
    }

    public IDGenerator getIDGenerator() {
        BitmapExportFormat bitmapExportFormat = (BitmapExportFormat)((Object)this.format.getSelectedItem());
        if (bitmapExportFormat.cardName.equals("geos")) {
            return this.geosPanel.getIDGenerator();
        }
        return this.macPanel.getIDGenerator();
    }

    public PointSizeGenerator getPointSizeGenerator() {
        BitmapExportFormat bitmapExportFormat = (BitmapExportFormat)((Object)this.format.getSelectedItem());
        if (bitmapExportFormat.cardName.equals("geos")) {
            return this.geosPanel.getPointSizeGenerator();
        }
        return this.macPanel.getPointSizeGenerator();
    }

    public boolean getGEOSMega() {
        return this.geosPanel.getGEOSMega();
    }

    public boolean getGEOSKerning() {
        return this.geosPanel.getGEOSKerning();
    }

    public boolean getGEOSUTF8() {
        return this.geosPanel.getGEOSUTF8();
    }

    public boolean getFONTXDoubleByte() {
        return this.fontxPanel.getSelectedDoubleByte();
    }

    public String getFONTXDoubleByteEncoding() {
        return this.fontxPanel.getSelectedDoubleByteEncoding();
    }

    public int getPSFVersion() {
        return this.psfPanel.getVersion();
    }

    public GlyphList getPSFLowEncoding() {
        return this.psfPanel.getLowEncoding();
    }

    public GlyphList getPSFHighEncoding() {
        return this.psfPanel.getHighEncoding();
    }

    public boolean getPSFUseLowEncoding() {
        return this.psfPanel.getUseLowEncoding();
    }

    public boolean getPSFUseHighEncoding() {
        return this.psfPanel.getUseHighEncoding();
    }

    public boolean getPSFUseAllGlyphs() {
        return this.psfPanel.getUseAllGlyphs();
    }

    public boolean getPSFUnicodeTable() {
        return this.psfPanel.getUnicodeTable();
    }

    public boolean getPlaydateSeparate() {
        return this.playdatePanel.getSeparate();
    }
}

