/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.importer;

import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.importer.RawImportEncodingList;
import com.kreative.bitsnpicas.importer.BinaryBitmapFontImporter;
import com.kreative.unicode.data.NameDatabase;
import com.kreative.unicode.data.NameResolver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class BinaryBitmapFontImporterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final byte[] data;
    private final BinaryBitmapFontImporter importer;
    private List<BufferedImage> previewImages;
    private final RawImportEncodingList eList = new RawImportEncodingList();
    private final EncodingTableModel eTableModel = new EncodingTableModel();
    private final JTable eTable = new JTable(this.eTableModel);
    private final NameDatabase ndb = NameDatabase.instance();

    public BinaryBitmapFontImporterPanel(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[0x100000];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        fileInputStream.close();
        this.file = file;
        this.data = byteArrayOutputStream.toByteArray();
        this.importer = new BinaryBitmapFontImporter();
        this.makeUI();
        this.updatePreview();
    }

    private void makeUI() {
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.importer.offset, 0, this.data.length, 1);
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(this.importer.bytesPerChar, 0, this.data.length, 1);
        final SpinnerNumberModel spinnerNumberModel3 = new SpinnerNumberModel(this.importer.bytesPerRow, 0, this.data.length, 1);
        final SpinnerNumberModel spinnerNumberModel4 = new SpinnerNumberModel(this.importer.cellWidth, 1, this.data.length, 1);
        final SpinnerNumberModel spinnerNumberModel5 = new SpinnerNumberModel(this.importer.cellHeight, 1, this.data.length, 1);
        final SpinnerNumberModel spinnerNumberModel6 = new SpinnerNumberModel(this.importer.ascent, -this.data.length, this.data.length, 1);
        final SpinnerNumberModel spinnerNumberModel7 = new SpinnerNumberModel(this.importer.bitsPerPixel, 1, 8, 1);
        final JCheckBox jCheckBox = new JCheckBox("Invert");
        jCheckBox.setSelected(this.importer.invert);
        final JCheckBox jCheckBox2 = new JCheckBox("Right-Align");
        jCheckBox2.setSelected(this.importer.rightAlign);
        final JCheckBox jCheckBox3 = new JCheckBox("Reverse Bits");
        jCheckBox3.setSelected(this.importer.flipBits);
        final JCheckBox jCheckBox4 = new JCheckBox("Reverse Bytes");
        jCheckBox4.setSelected(this.importer.flipBytes);
        final SpinnerNumberModel spinnerNumberModel8 = new SpinnerNumberModel(this.importer.cellCount, 1, this.data.length, 1);
        JPanel jPanel = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel), "Before");
        JPanel jPanel2 = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel2), "Before");
        JPanel jPanel3 = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel3), "Before");
        JPanel jPanel4 = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel4), "Before");
        JPanel jPanel5 = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel5), "Before");
        JPanel jPanel6 = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel6), "Before");
        JPanel jPanel7 = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel7), "Before");
        JPanel jPanel8 = BinaryBitmapFontImporterPanel.borderLayout(0, 0, BinaryBitmapFontImporterPanel.jSpinner(spinnerNumberModel8), "Before");
        JPanel jPanel9 = BinaryBitmapFontImporterPanel.gridLayout(0, 1, 4, 4, new JLabel("Offset:"), new JLabel("Bytes Per Char.:"), new JLabel("Bytes Per Row:"), new JLabel("Char. Width:"), new JLabel("Char. Height:"), new JLabel("Ascent:"), new JLabel("Bits Per Pixel:"), new JLabel("Bit Format:"), new JLabel(" "), new JLabel(" "), new JLabel(" "), new JLabel("Characters:"));
        JPanel jPanel10 = BinaryBitmapFontImporterPanel.gridLayout(0, 1, 4, 4, jPanel, jPanel2, jPanel3, jPanel4, jPanel5, jPanel6, jPanel7, jCheckBox2, jCheckBox4, jCheckBox3, jCheckBox, jPanel8);
        JPanel jPanel11 = BinaryBitmapFontImporterPanel.borderLayout(8, 8, jPanel9, "Before", jPanel10, "Center");
        this.eTable.setDefaultRenderer(BufferedImage.class, new GlyphCellRenderer());
        BinaryBitmapFontImporterPanel.setColumnWidth(this.eTable.getColumnModel().getColumn(1), 80);
        BinaryBitmapFontImporterPanel.setColumnWidth(this.eTable.getColumnModel().getColumn(2), 80);
        JScrollPane jScrollPane = new JScrollPane(this.eTable);
        JPanel jPanel12 = BinaryBitmapFontImporterPanel.borderLayout(8, 8, new JLabel("Encoding:"), "Before", this.eList, "Center");
        JPanel jPanel13 = BinaryBitmapFontImporterPanel.borderLayout(4, 4, jPanel12, "First", jScrollPane, "Center");
        JButton jButton = new JButton("Create");
        JPanel jPanel14 = BinaryBitmapFontImporterPanel.flowLayout(jButton);
        JPanel jPanel15 = new JPanel(new BorderLayout(12, 12));
        jPanel15.add((Component)jPanel11, "Before");
        jPanel15.add((Component)jPanel13, "Center");
        jPanel15.add((Component)jPanel14, "Last");
        jPanel15.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(jPanel15);
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.offset = spinnerNumberModel.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.bytesPerChar = spinnerNumberModel2.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.bytesPerRow = spinnerNumberModel3.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.cellWidth = spinnerNumberModel4.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.cellHeight = spinnerNumberModel5.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel6.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.ascent = spinnerNumberModel6.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel7.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.bitsPerPixel = spinnerNumberModel7.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.invert = jCheckBox.isSelected();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.rightAlign = jCheckBox2.isSelected();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        jCheckBox3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.flipBits = jCheckBox3.isSelected();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        jCheckBox4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.flipBytes = jCheckBox4.isSelected();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        spinnerNumberModel8.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.cellCount = spinnerNumberModel8.getNumber().intValue();
                BinaryBitmapFontImporterPanel.this.updatePreview();
            }
        });
        this.eList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BinaryBitmapFontImporterPanel.this.eList.applySelectedEncoding(((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding);
                BinaryBitmapFontImporterPanel.this.eTableModel.fireTableRowsUpdated(0, ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size());
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.openFonts(BinaryBitmapFontImporterPanel.this.file, null, BinaryBitmapFontImporterPanel.this.importer.importFont(BinaryBitmapFontImporterPanel.this.data));
            }
        });
    }

    private void updatePreview() {
        int n;
        this.previewImages = this.importer.preview(this.data);
        List<Integer> list = this.eList.getSelectedEncoding();
        if (this.importer.encoding == null) {
            this.importer.encoding = new ArrayList<Integer>();
        }
        int n2 = this.previewImages.size();
        for (n = this.importer.encoding.size(); n < n2; ++n) {
            this.importer.encoding.add(list != null && n < list.size() ? list.get(n) : -1);
        }
        n = this.previewImages.size();
        for (n2 = this.importer.encoding.size(); n < n2; --n2) {
            this.importer.encoding.remove(n);
        }
        this.eTableModel.fireTableDataChanged();
        this.eTable.setRowHeight(Math.max(16, this.importer.cellHeight + 4));
        BinaryBitmapFontImporterPanel.setColumnWidth(this.eTable.getColumnModel().getColumn(0), Math.max(20, this.importer.cellWidth + 8));
    }

    private static JPanel borderLayout(int n, int n2, Component component, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(n, n2));
        jPanel.add(component, string);
        return jPanel;
    }

    private static JPanel borderLayout(int n, int n2, Component component, String string, Component component2, String string2) {
        JPanel jPanel = new JPanel(new BorderLayout(n, n2));
        jPanel.add(component, string);
        jPanel.add(component2, string2);
        return jPanel;
    }

    private static JPanel flowLayout(Component ... componentArray) {
        JPanel jPanel = new JPanel(new FlowLayout());
        for (Component component : componentArray) {
            jPanel.add(component);
        }
        return jPanel;
    }

    private static JPanel gridLayout(int n, int n2, int n3, int n4, Component ... componentArray) {
        JPanel jPanel = new JPanel(new GridLayout(n, n2, n3, n4));
        for (Component component : componentArray) {
            jPanel.add(component);
        }
        return jPanel;
    }

    private static JSpinner jSpinner(SpinnerNumberModel spinnerNumberModel) {
        JSpinner jSpinner = new JSpinner(spinnerNumberModel);
        Dimension dimension = jSpinner.getPreferredSize();
        dimension.width = 80;
        jSpinner.setMinimumSize(dimension);
        jSpinner.setPreferredSize(dimension);
        jSpinner.setMaximumSize(dimension);
        return jSpinner;
    }

    private static void setColumnWidth(TableColumn tableColumn, int n) {
        tableColumn.setMinWidth(n);
        tableColumn.setWidth(n);
        tableColumn.setMaxWidth(n);
    }

    private class GlyphCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private GlyphCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JLabel && object instanceof BufferedImage) {
                JLabel jLabel = (JLabel)component;
                BufferedImage bufferedImage = (BufferedImage)object;
                jLabel.setText(null);
                jLabel.setIcon(new ImageIcon(bufferedImage));
            }
            return component;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EncodingTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private EncodingTableModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return BufferedImage.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Glyph";
                }
                case 1: {
                    return "Code Point";
                }
                case 2: {
                    return "Character";
                }
                case 3: {
                    return "Character Name";
                }
            }
            return null;
        }

        @Override
        public int getRowCount() {
            if (((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding == null) {
                return 0;
            }
            return ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (BinaryBitmapFontImporterPanel.this.previewImages == null) {
                        return null;
                    }
                    if (n < BinaryBitmapFontImporterPanel.this.previewImages.size()) {
                        return BinaryBitmapFontImporterPanel.this.previewImages.get(n);
                    }
                    return null;
                }
                case 1: {
                    if (((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding == null) {
                        return null;
                    }
                    if (n < ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size()) {
                        Integer n3 = ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.get(n);
                        if (n3 == null || n3 < 0) {
                            return null;
                        }
                        String string = Integer.toHexString(n3).toUpperCase();
                        while (string.length() < 4) {
                            string = "0" + string;
                        }
                        return string;
                    }
                    return null;
                }
                case 2: {
                    if (((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding == null) {
                        return null;
                    }
                    if (n < ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size()) {
                        Integer n4 = ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.get(n);
                        if (n4 == null || n4 < 0) {
                            return null;
                        }
                        return String.valueOf(Character.toChars(n4));
                    }
                    return null;
                }
                case 3: {
                    if (((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding == null) {
                        return null;
                    }
                    if (n < ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size()) {
                        Integer n5 = ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.get(n);
                        if (n5 == null || n5 < 0) {
                            return null;
                        }
                        return NameResolver.instance(n5).getName(n5);
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2 || n2 == 3;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 1: {
                    if (((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding == null) {
                        return;
                    }
                    if (n < ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size()) {
                        if (object == null || object.toString().length() == 0) {
                            ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            BinaryBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        } else {
                            try {
                                int n3 = Integer.parseInt(object.toString(), 16);
                                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.set(n, n3);
                                BinaryBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    return;
                }
                case 2: {
                    if (((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding == null) {
                        return;
                    }
                    if (n < ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size()) {
                        if (object == null || object.toString().length() == 0) {
                            ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            BinaryBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        } else {
                            int n4 = object.toString().codePointAt(0);
                            ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.set(n, n4);
                            BinaryBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        }
                    }
                    return;
                }
                case 3: {
                    if (((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding == null) {
                        return;
                    }
                    if (n < ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.size()) {
                        if (object == null || object.toString().length() == 0) {
                            ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            BinaryBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        } else {
                            NameDatabase.NameEntry nameEntry = BinaryBitmapFontImporterPanel.this.ndb.find(object.toString());
                            if (nameEntry == null) {
                                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.set(n, -1);
                            } else {
                                ((BinaryBitmapFontImporterPanel)BinaryBitmapFontImporterPanel.this).importer.encoding.set(n, nameEntry.codePoint);
                            }
                            BinaryBitmapFontImporterPanel.this.eList.setSelectedIndex(0);
                        }
                    }
                    return;
                }
            }
            this.fireTableRowsUpdated(n, n);
        }
    }
}

