/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.edit.importer;

import com.kreative.bitsnpicas.Font;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.importer.PSFEncodingSelectionImporter;
import com.kreative.unicode.data.EncodingList;
import com.kreative.unicode.data.GlyphList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PSFEncodingSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public PSFEncodingSelectionPanel(final File file, final PSFEncodingSelectionImporter pSFEncodingSelectionImporter) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("None");
        arrayList.addAll(EncodingList.instance().glyphLists());
        final JComboBox<Object> jComboBox = new JComboBox<Object>(arrayList.toArray());
        jComboBox.setEditable(false);
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add("None");
        arrayList2.addAll(EncodingList.instance().glyphLists());
        final JComboBox<Object> jComboBox2 = new JComboBox<Object>(arrayList2.toArray());
        jComboBox2.setEditable(false);
        ArrayList<PuaBaseOption> arrayList3 = new ArrayList<PuaBaseOption>();
        arrayList3.add(new PuaBaseOption("None", -1));
        arrayList3.add(new PuaBaseOption("U+0000", 0));
        arrayList3.add(new PuaBaseOption("U+E000", 57344));
        arrayList3.add(new PuaBaseOption("U+F000", 61440));
        arrayList3.add(new PuaBaseOption("U+F0000", 983040));
        arrayList3.add(new PuaBaseOption("U+FE000", 1040384));
        arrayList3.add(new PuaBaseOption("U+FF000", 1044480));
        arrayList3.add(new PuaBaseOption("U+100000", 0x100000));
        arrayList3.add(new PuaBaseOption("U+10E000", 0x10E000));
        arrayList3.add(new PuaBaseOption("U+10F000", 0x10F000));
        final JComboBox<Object> jComboBox3 = new JComboBox<Object>(arrayList3.toArray());
        jComboBox3.setEditable(false);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel.add(new JLabel("Primary Character Set ($000-$0FF):"));
        jPanel.add(new JLabel("Alternate Character Set ($100-$1FF):"));
        jPanel.add(new JLabel("Passthrough Starting Code Point:"));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 4, 4));
        jPanel2.add(jComboBox);
        jPanel2.add(jComboBox2);
        jPanel2.add(jComboBox3);
        JPanel jPanel3 = new JPanel(new BorderLayout(8, 8));
        jPanel3.add((Component)jPanel, "Before");
        jPanel3.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(12, 12));
        jPanel4.add((Component)new JLabel("Select an encoding for " + file.getName() + "."), "First");
        jPanel4.add((Component)jPanel3, "Center");
        JButton jButton = new JButton("Open");
        JPanel jPanel5 = new JPanel(new FlowLayout());
        jPanel5.add(jButton);
        JPanel jPanel6 = new JPanel(new BorderLayout(12, 12));
        jPanel6.add((Component)jPanel4, "Center");
        jPanel6.add((Component)jPanel5, "Last");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.setLayout(new GridLayout(1, 1, 0, 0));
        this.add(jPanel6);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GlyphList glyphList = jComboBox.getSelectedIndex() > 0 ? (GlyphList)jComboBox.getSelectedItem() : null;
                    GlyphList glyphList2 = jComboBox2.getSelectedIndex() > 0 ? (GlyphList)jComboBox2.getSelectedItem() : null;
                    int n = jComboBox3.getSelectedIndex() > 0 ? ((PuaBaseOption)jComboBox3.getSelectedItem()).value : -1;
                    Font[] fontArray = pSFEncodingSelectionImporter.createImporter(glyphList, glyphList2, n).importFont(file);
                    if (fontArray != null && fontArray.length > 0) {
                        Main.openFonts(file, null, fontArray);
                    } else {
                        JOptionPane.showMessageDialog(null, "The selected file did not contain any fonts.", "Open", 0);
                    }
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, "An error occurred while reading the selected file.", "Open", 0);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    JOptionPane.showMessageDialog(null, "The selected file requires KSFL, but KSFL is not in the classpath.", "Open", 0);
                }
            }
        });
    }

    private static final class PuaBaseOption {
        public final String label;
        public final int value;

        public PuaBaseOption(String string, int n) {
            this.label = string;
            this.value = n;
        }

        public String toString() {
            return this.label;
        }
    }
}

