/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

public class BDFBitmapFontExporter
implements BitmapFontExporter {
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
        printWriter.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
        printWriter.close();
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, PrintWriter printWriter) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 0x110000; ++i) {
            if (!bitmapFont.containsCharacter(i)) continue;
            ++n;
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(i);
            if (bitmapFontGlyph.getGlyphOffset() < n2) {
                n2 = bitmapFontGlyph.getGlyphOffset();
            }
            if (bitmapFontGlyph.getGlyphOffset() + bitmapFontGlyph.getGlyphWidth() > n3) {
                n3 = bitmapFontGlyph.getGlyphOffset() + bitmapFontGlyph.getGlyphWidth();
            }
            if (bitmapFontGlyph.getGlyphAscent() > n4) {
                n4 = bitmapFontGlyph.getGlyphAscent();
            }
            if (bitmapFontGlyph.getGlyphDescent() <= n5) continue;
            n5 = bitmapFontGlyph.getGlyphDescent();
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (bitmapFont.containsName(1)) {
            linkedHashMap.put("FAMILY_NAME", bitmapFont.getName(1));
        }
        if (bitmapFont.containsName(2)) {
            linkedHashMap.put("WEIGHT_NAME", bitmapFont.getName(2));
        }
        if (bitmapFont.containsName(5)) {
            linkedHashMap.put("FONT_VERSION", bitmapFont.getName(5));
        }
        if (bitmapFont.containsName(0)) {
            linkedHashMap.put("COPYRIGHT", bitmapFont.getName(0));
        }
        if (bitmapFont.containsName(8)) {
            linkedHashMap.put("FOUNDRY", bitmapFont.getName(8));
        }
        linkedHashMap.put("FONT_ASCENT", Integer.toString(bitmapFont.getLineAscent()));
        linkedHashMap.put("FONT_DESCENT", Integer.toString(bitmapFont.getLineDescent()));
        linkedHashMap.put("POINT_SIZE", Integer.toString(bitmapFont.getEmAscent() + bitmapFont.getEmDescent()));
        linkedHashMap.put("X_HEIGHT", Integer.toString(bitmapFont.getXHeight()));
        linkedHashMap.put("CAP_HEIGHT", Integer.toString(bitmapFont.getCapHeight()));
        printWriter.println("STARTFONT 2.1");
        printWriter.println("FONT -" + bitmapFont.getName(1) + "-" + bitmapFont.getName(2) + "-" + (bitmapFont.isItalicStyle() ? "I" : "R") + "-" + bitmapFont.getName(2) + "--" + (bitmapFont.getLineAscent() + bitmapFont.getLineDescent()) + "-" + (bitmapFont.getLineAscent() + bitmapFont.getLineDescent()) + "-75-75-c-80-iso10646-1");
        printWriter.println("SIZE " + (bitmapFont.getLineAscent() + bitmapFont.getLineDescent()) + " 75 75");
        printWriter.println("FONTBOUNDINGBOX " + (n3 - n2) + " " + (n4 + n5) + " " + n2 + " " + -n5);
        printWriter.println("STARTPROPERTIES " + linkedHashMap.size());
        for (Map.Entry object : linkedHashMap.entrySet()) {
            printWriter.println((String)object.getKey() + " " + BDFBitmapFontExporter.enquote((String)object.getValue()));
        }
        printWriter.println("ENDPROPERTIES");
        printWriter.println("CHARS " + n);
        for (int i = 0; i < 0x110000; ++i) {
            if (!bitmapFont.containsCharacter(i)) continue;
            BitmapFontGlyph bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(i);
            String string = Integer.toHexString(i).toUpperCase();
            while (string.length() < 4) {
                string = "0" + string;
            }
            printWriter.println("STARTCHAR U+" + string);
            printWriter.println("ENCODING " + i);
            printWriter.println("SWIDTH " + 1000 * bitmapFontGlyph.getCharacterWidth() / (n3 - n2) + " 0");
            printWriter.println("DWIDTH " + bitmapFontGlyph.getCharacterWidth() + " 0");
            printWriter.println("BBX " + bitmapFontGlyph.getGlyphWidth() + " " + bitmapFontGlyph.getGlyphHeight() + " " + bitmapFontGlyph.getGlyphOffset() + " " + -bitmapFontGlyph.getGlyphDescent());
            printWriter.println("BITMAP");
            for (byte[] byArray : bitmapFontGlyph.getGlyph()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < byArray.length; j += 8) {
                    int n6 = 0;
                    for (int k = 0; k < 8; ++k) {
                        n6 <<= 1;
                        if (j + k >= byArray.length || byArray[j + k] >= 0) continue;
                        n6 |= 1;
                    }
                    String string2 = "00" + Integer.toHexString(n6).toUpperCase();
                    string2 = string2.substring(string2.length() - 2);
                    stringBuffer.append(string2);
                }
                if (stringBuffer.length() == 0) {
                    stringBuffer.append("00");
                }
                printWriter.println(stringBuffer.toString());
            }
            printWriter.println("ENDCHAR");
        }
        printWriter.println("ENDFONT");
    }

    private static String enquote(String string) {
        if (string.matches("^-?[0-9]+$")) {
            return string;
        }
        return "\"" + string.replaceAll("\"", "\"\"") + "\"";
    }
}

