/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import com.kreative.unicode.data.GlyphList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class FNTBitmapFontExporter
implements BitmapFontExporter {
    private int magic;
    private GlyphList encoding;
    private static final int[] CP1252_C1 = new int[]{8364, 9674, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 321, 381, 305, 8984, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 322, 382, 376};

    public FNTBitmapFontExporter() {
        this.magic = 3;
        this.encoding = null;
    }

    public FNTBitmapFontExporter(GlyphList glyphList) {
        this.magic = 3;
        this.encoding = glyphList;
    }

    public FNTBitmapFontExporter(int n) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("bad magic number");
        }
        this.magic = n;
        this.encoding = null;
    }

    public FNTBitmapFontExporter(int n, GlyphList glyphList) {
        if (n < 1 || n > 3) {
            throw new IllegalArgumentException("bad magic number");
        }
        this.magic = n;
        this.encoding = glyphList;
    }

    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.exportFontImpl(bitmapFont, new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        this.exportFontImpl(bitmapFont, new DataOutputStream(outputStream));
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.exportFontImpl(bitmapFont, new DataOutputStream(fileOutputStream));
        fileOutputStream.close();
    }

    private void exportFontImpl(BitmapFont bitmapFont, DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string;
        int n6;
        int n7 = bitmapFont.getLineAscent();
        int n8 = n7 + bitmapFont.getLineDescent();
        int n9 = bitmapFont.getEmAscent() + bitmapFont.getEmDescent();
        int n10 = bitmapFont.getLineGap();
        String string2 = bitmapFont.getName(2);
        string2 = string2 != null ? string2.toLowerCase() : "";
        int n11 = string2.contains("italic") || string2.contains("oblique") ? 1 : 0;
        int n12 = string2.contains("underline") ? 1 : 0;
        int n13 = n6 = string2.contains("strike") ? 1 : 0;
        int n14 = string2.contains("thin") ? 100 : (string2.contains("light") ? 300 : (string2.contains("bold") ? 700 : (string2.contains("black") ? 900 : 400)));
        String string3 = string = this.encoding != null ? this.encoding.getName().toUpperCase() : "WINDOWS-1252";
        int n15 = string.equals("WINDOWS-1252") ? 0 : (string.equals("X-MACROMAN") ? 77 : (string.equals("SHIFT_JIS") ? 128 : (string.equals("X-MS932_0213") ? 128 : (string.equals("X-SJIS_0213") ? 128 : (string.equals("X-IBM949") ? 129 : (string.equals("X-IBM949C") ? 129 : (string.equals("X-WINDOWS-949") ? 129 : (string.equals("X-JOHAB") ? 130 : (string.equals("GB2312") ? 134 : (string.equals("X-MSWIN-936") ? 134 : (string.equals("BIG5") ? 136 : (string.equals("BIG5-HKSCS") ? 136 : (string.equals("X-BIG5-HKSCS-2001") ? 136 : (string.equals("X-BIG5-SOLARIS") ? 136 : (string.equals("X-IBM950") ? 136 : (string.equals("X-MS950-HKSCS") ? 136 : (string.equals("X-MS950-HKSCS-XP") ? 136 : (string.equals("X-WINDOWS-950") ? 136 : (string.equals("WINDOWS-1253") ? 161 : (string.equals("WINDOWS-1254") ? 162 : (string.equals("WINDOWS-1258") ? 163 : (string.equals("WINDOWS-1255") ? 177 : (string.equals("WINDOWS-1256") ? 178 : (string.equals("WINDOWS-1257") ? 186 : (string.equals("WINDOWS-1251") ? 204 : (string.equals("X-IBM874") ? 222 : (string.equals("X-WINDOWS-874") ? 222 : (string.equals("WINDOWS-1250") ? 238 : (string.equals("IBM437") ? 255 : 2)))))))))))))))))))))))))))));
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = -1;
        int n20 = -1;
        int n21 = -1;
        int n22 = -1;
        int n23 = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, byte[]> hashMap2 = new HashMap<Integer, byte[]>();
        for (n5 = 0; n5 < 256; ++n5) {
            BitmapFontGlyph bitmapFontGlyph;
            int n24;
            int n25 = n24 = this.encoding != null ? this.encoding.get(n5) : FNTBitmapFontExporter.fromCP1252(n5);
            if (n24 < 0) {
                n24 = 61440 + n5;
            }
            if ((bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(n24)) == null) continue;
            n4 = bitmapFontGlyph.getCharacterWidth();
            if (n4 > n16) {
                n16 = n4;
            }
            n17 += n4;
            ++n18;
            if (n24 == 32) {
                n22 = n5;
            }
            if (n19 < 0) {
                n19 = n5;
            }
            n20 = n5;
            n3 = (n4 + 7) / 8;
            n23 += n3;
            byte[] byArray = new byte[n3 * n8];
            byte[][] byArray2 = bitmapFontGlyph.getGlyph();
            int n26 = 0;
            int n27 = bitmapFontGlyph.getGlyphAscent() - n7;
            int n28 = 0;
            while (n28 < n8) {
                if (n27 >= 0 && n27 < byArray2.length) {
                    n2 = n26;
                    n = -bitmapFontGlyph.getGlyphOffset();
                    int n29 = 0;
                    while (n29 < n4) {
                        int n30 = 128;
                        while (n30 != 0 && n29 < n4) {
                            if (n >= 0 && n < byArray2[n27].length && byArray2[n27][n] < 0) {
                                int n31 = n2;
                                byArray[n31] = (byte)(byArray[n31] | n30);
                            }
                            n30 >>= 1;
                            ++n29;
                            ++n;
                        }
                        n2 += n8;
                    }
                }
                ++n28;
                ++n27;
                ++n26;
            }
            hashMap.put(n5, n4);
            hashMap2.put(n5, byArray);
        }
        if ((n17 /= n18) < 1) {
            n17 = 1;
        }
        n5 = (n17 + 7) / 8;
        byte[] byArray = new byte[n5 * n8];
        int n32 = 0;
        n4 = 0;
        while (n4 < n8) {
            if (n4 > 0 && n4 < n8 - 1) {
                n3 = n32;
                int n33 = 0;
                while (n33 < n17) {
                    for (int i = 128; i != 0 && n33 < n17; i >>= 1, ++n33) {
                        if (n33 <= 0) continue;
                        int n34 = n3;
                        byArray[n34] = (byte)(byArray[n34] | i);
                    }
                    n3 += n8;
                }
            }
            ++n4;
            ++n32;
        }
        n32 = 1;
        for (n4 = n19; n4 <= n20; ++n4) {
            if (hashMap.containsKey(n4)) {
                if ((Integer)hashMap.get(n4) == n17) continue;
                n32 = 0;
                continue;
            }
            if (n21 < 0) {
                n21 = n4;
            }
            n23 += n5;
            ++n18;
            hashMap.put(n4, n17);
            hashMap2.put(n4, byArray);
        }
        if (n22 < 0) {
            n22 = n20 + 1;
        }
        if (n21 < 0) {
            n21 = n20 + 1;
        }
        n23 += n5;
        hashMap.put(n20 + 1, n17);
        hashMap2.put(n20 + 1, new byte[n5 * n8]);
        assert (n20 - n19 + 2 == ++n18);
        assert (hashMap.size() == n18);
        assert (hashMap2.size() == n18);
        n4 = n18 * (this.magic >= 3 ? 6 : 4);
        n3 = n4 + (this.magic >= 3 ? 148 : 118);
        int n35 = n3 + n23 * n8;
        String string4 = bitmapFont.getName(0);
        byte[] byArray3 = string4 != null ? string4.getBytes("CP1252") : new byte[]{};
        String string5 = bitmapFont.getName(1);
        byte[] byArray4 = string5 != null ? string5.getBytes("CP1252") : new byte[]{};
        n2 = n35 + byArray4.length + 1;
        dataOutputStream.writeShort(this.magic);
        dataOutputStream.writeInt(Integer.reverseBytes(n2));
        dataOutputStream.write(byArray3, 0, Math.min(byArray3.length, 60));
        for (n = byArray3.length; n < 60; ++n) {
            dataOutputStream.write(0);
        }
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(Short.reverseBytes((short)n9));
        dataOutputStream.writeShort(Short.reverseBytes((short)96));
        dataOutputStream.writeShort(Short.reverseBytes((short)96));
        dataOutputStream.writeShort(Short.reverseBytes((short)n7));
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(Short.reverseBytes((short)n10));
        dataOutputStream.writeByte(n11);
        dataOutputStream.writeByte(n12);
        dataOutputStream.writeByte(n6);
        dataOutputStream.writeShort(Short.reverseBytes((short)n14));
        dataOutputStream.writeByte(n15);
        dataOutputStream.writeShort(Short.reverseBytes((short)(n32 != 0 ? n17 : 0)));
        dataOutputStream.writeShort(Short.reverseBytes((short)n8));
        dataOutputStream.writeByte(n32 != 0 ? 0 : 1);
        dataOutputStream.writeShort(Short.reverseBytes((short)n17));
        dataOutputStream.writeShort(Short.reverseBytes((short)n16));
        dataOutputStream.writeByte(n19);
        dataOutputStream.writeByte(n20);
        dataOutputStream.writeByte(n21 - n19);
        dataOutputStream.writeByte(n22 - n19);
        dataOutputStream.writeShort(Short.reverseBytes((short)n23));
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(Integer.reverseBytes(n35));
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(Integer.reverseBytes(n3));
        dataOutputStream.writeByte(0);
        if (this.magic >= 3) {
            dataOutputStream.writeInt(Integer.reverseBytes(n32 != 0 ? 17 : 18));
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.write(new byte[16]);
        }
        for (n = n19; n <= n20 + 1; ++n) {
            dataOutputStream.writeShort(Short.reverseBytes(((Integer)hashMap.get(n)).shortValue()));
            if (this.magic >= 3) {
                dataOutputStream.writeInt(Integer.reverseBytes(n3));
            } else {
                dataOutputStream.writeShort(Short.reverseBytes((short)n3));
            }
            n3 += ((byte[])hashMap2.get(n)).length;
        }
        assert (n3 == n35);
        for (n = n19; n <= n20 + 1; ++n) {
            dataOutputStream.write((byte[])hashMap2.get(n));
        }
        dataOutputStream.write(byArray4);
        dataOutputStream.write(0);
    }

    private static int fromCP1252(int n) {
        if (n < 128 || n >= 160) {
            return n;
        }
        return CP1252_C1[n - 128];
    }
}

