/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.exporter;

import com.kreative.bitsnpicas.BitmapFont;
import com.kreative.bitsnpicas.BitmapFontExporter;
import com.kreative.bitsnpicas.BitmapFontGlyph;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class HexBitmapFontExporter
implements BitmapFontExporter {
    public byte[] exportFontToBytes(BitmapFont bitmapFont) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
        printWriter.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void exportFontToStream(BitmapFont bitmapFont, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
    }

    public void exportFontToFile(BitmapFont bitmapFont, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8"), true);
        this.exportFont(bitmapFont, printWriter);
        printWriter.close();
        fileOutputStream.close();
    }

    private void exportFont(BitmapFont bitmapFont, PrintWriter printWriter) {
        for (int i = 0; i < 0x110000; ++i) {
            BitmapFontGlyph bitmapFontGlyph;
            int n;
            if (!bitmapFont.containsCharacter(i) || (n = ((bitmapFontGlyph = (BitmapFontGlyph)bitmapFont.getCharacter(i)).getCharacterWidth() + 3) / 4) <= 0) continue;
            byte[][] byArray = bitmapFontGlyph.getGlyph();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = bitmapFontGlyph.getGlyphAscent() - 14;
            int n3 = 0;
            while (n3 < 16) {
                int n4 = -bitmapFontGlyph.getGlyphOffset();
                for (int j = 0; j < n; ++j) {
                    int n5 = 0;
                    char c = '\b';
                    while (c > '\u0000') {
                        if (n2 >= 0 && n2 < byArray.length && n4 >= 0 && n4 < byArray[n2].length && byArray[n2][n4] < 0) {
                            n5 |= c;
                        }
                        c >>= 1;
                        ++n4;
                    }
                    c = Character.forDigit(n5, 16);
                    stringBuffer.append(Character.toUpperCase(c));
                }
                ++n3;
                ++n2;
            }
            String string = Integer.toHexString(i).toUpperCase();
            while (string.length() != 4 && string.length() != 6) {
                string = "0" + string;
            }
            printWriter.println(string + ":" + stringBuffer.toString());
        }
    }
}

