/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.truetype.CmapSubtable;
import com.kreative.bitsnpicas.truetype.CmapTable;
import com.kreative.bitsnpicas.truetype.GlyfTable;
import com.kreative.bitsnpicas.truetype.HeadTable;
import com.kreative.bitsnpicas.truetype.LocaTable;
import com.kreative.bitsnpicas.truetype.MaxpTable;
import com.kreative.bitsnpicas.truetype.PostTable;
import com.kreative.bitsnpicas.truetype.PostTableEntry;
import com.kreative.bitsnpicas.truetype.SbixEntry;
import com.kreative.bitsnpicas.truetype.SbixSubtable;
import com.kreative.bitsnpicas.truetype.SbixTable;
import com.kreative.bitsnpicas.truetype.TrueTypeFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.HashMap;

public class InjectSbix {
    public static void main(String[] stringArray) {
        try {
            System.setProperty("apple.awt.UIElement", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string : stringArray) {
            File file = new File(string);
            System.out.print("Processing " + file.getAbsolutePath() + "... ");
            try {
                File file2 = new File(file.getParent(), file.getName() + ".sbix.d");
                if (!file2.exists() || !file2.isDirectory()) {
                    System.out.println("no sbix directory found.");
                    continue;
                }
                byte[] byArray = new byte[(int)file.length()];
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
                TrueTypeFile trueTypeFile = new TrueTypeFile();
                trueTypeFile.decompile(byArray);
                CmapTable cmapTable = (CmapTable)trueTypeFile.getByTableName("cmap");
                CmapSubtable cmapSubtable = cmapTable == null ? null : cmapTable.getBestSubtable();
                PostTable postTable = (PostTable)trueTypeFile.getByTableName("post");
                MaxpTable maxpTable = (MaxpTable)trueTypeFile.getByTableName("maxp");
                HeadTable headTable = (HeadTable)trueTypeFile.getByTableName("head");
                GlyfTable glyfTable = (GlyfTable)trueTypeFile.getByTableName("glyf");
                LocaTable locaTable = (LocaTable)trueTypeFile.getByTableName("loca");
                SbixTable sbixTable = (SbixTable)trueTypeFile.getByTableName("sbix");
                if (sbixTable == null) {
                    sbixTable = new SbixTable();
                    trueTypeFile.add(sbixTable);
                } else {
                    sbixTable.clear();
                }
                Object object = file2.listFiles();
                int n = ((File[])object).length;
                for (int i = 0; i < n; ++i) {
                    File file3 = object[i];
                    try {
                        int n2 = Integer.parseInt(file3.getName());
                        SbixSubtable sbixSubtable = new SbixSubtable();
                        sbixSubtable.ppem = n2;
                        sbixTable.add(sbixSubtable);
                        HashMap<Integer, SbixEntry> hashMap = new HashMap<Integer, SbixEntry>();
                        for (File file4 : file3.listFiles()) {
                            String string2 = file4.getName();
                            int n3 = string2.lastIndexOf(46);
                            if (n3 <= 0) continue;
                            String string3 = string2.substring(n3 + 1);
                            int n4 = InjectSbix.getGlyphIndex(string2 = string2.substring(0, n3), cmapSubtable, postTable);
                            if (n4 <= 0) continue;
                            byte[] byArray2 = new byte[(int)file4.length()];
                            FileInputStream fileInputStream2 = new FileInputStream(file4);
                            fileInputStream2.read(byArray2);
                            fileInputStream2.close();
                            SbixEntry sbixEntry = new SbixEntry();
                            sbixEntry.setImageTypeString(string3);
                            sbixEntry.imageData = byArray2;
                            hashMap.put(n4, sbixEntry);
                        }
                        for (int j = 0; j < maxpTable.numGlyphs; ++j) {
                            if (hashMap.containsKey(j)) {
                                SbixEntry sbixEntry = (SbixEntry)hashMap.get(j);
                                if (glyfTable != null) {
                                    GlyfInfo glyfInfo = InjectSbix.rewriteGlyf((byte[])glyfTable.get(j));
                                    sbixEntry.offsetX = glyfInfo.xMin * n2 / headTable.unitsPerEm;
                                    sbixEntry.offsetY = glyfInfo.yMin * n2 / headTable.unitsPerEm;
                                    glyfTable.set(j, glyfInfo.data);
                                }
                                sbixSubtable.add(sbixEntry);
                                continue;
                            }
                            sbixSubtable.add(new SbixEntry());
                        }
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (glyfTable != null && locaTable != null) {
                    locaTable.clear();
                    int n5 = 0;
                    for (n = 0; n < maxpTable.numGlyphs; ++n) {
                        locaTable.add(n5);
                        n5 += ((byte[])glyfTable.get(n)).length;
                    }
                    locaTable.add(n5);
                }
                byArray = trueTypeFile.compile();
                object = trueTypeFile.isOpenType() ? ".otf" : ".ttf";
                File file5 = new File(file.getParent(), file.getName() + ".sbix" + (String)object);
                FileOutputStream fileOutputStream = new FileOutputStream(file5);
                fileOutputStream.write(byArray);
                fileOutputStream.flush();
                fileOutputStream.close();
                System.out.println("done.");
            }
            catch (Exception exception) {
                System.out.println("failed (" + exception.getClass().getSimpleName() + ": " + exception.getMessage() + ").");
            }
        }
    }

    private static GlyfInfo rewriteGlyf(byte[] byArray) {
        GlyfInfo glyfInfo = new GlyfInfo();
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            dataInputStream.readShort();
            glyfInfo.xMin = dataInputStream.readShort();
            glyfInfo.yMin = dataInputStream.readShort();
            glyfInfo.xMax = dataInputStream.readShort();
            glyfInfo.yMax = dataInputStream.readShort();
            dataInputStream.close();
            byteArrayInputStream.close();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(glyfInfo.xMin);
            dataOutputStream.writeShort(glyfInfo.yMin);
            dataOutputStream.writeShort(glyfInfo.xMax);
            dataOutputStream.writeShort(glyfInfo.yMax);
            dataOutputStream.writeShort(0);
            dataOutputStream.flush();
            byteArrayOutputStream.flush();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            glyfInfo.data = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            glyfInfo.data = byArray;
        }
        return glyfInfo;
    }

    private static int getGlyphIndex(String string, CmapSubtable cmapSubtable, PostTable postTable) {
        if (string.startsWith("glyph_")) {
            try {
                return Integer.parseInt(string.substring(6));
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (string.startsWith("char_")) {
            if (cmapSubtable == null) {
                return 0;
            }
            try {
                int n = Integer.parseInt(string.substring(5), 16);
                return cmapSubtable.getGlyphIndex(n);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        if (postTable == null) {
            return 0;
        }
        PostTableEntry postTableEntry = PostTableEntry.forCharacterName(InjectSbix.unescape(string));
        if (postTable.contains(postTableEntry)) {
            return postTable.indexOf(postTableEntry);
        }
        return 0;
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            block0 : switch (c) {
                case '!': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('!');
                        break;
                    }
                    stringBuffer.append(Character.toLowerCase(c));
                    break;
                }
                case '^': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('^');
                        break;
                    }
                    stringBuffer.append(Character.toUpperCase(c));
                    break;
                }
                case '#': {
                    c = stringCharacterIterator.next();
                    if (c == '\uffff') {
                        stringBuffer.append('#');
                        break;
                    }
                    stringBuffer.append(Character.toTitleCase(c));
                    break;
                }
                case '=': {
                    c = stringCharacterIterator.next();
                    switch (c) {
                        case '\uffff': {
                            stringBuffer.append('=');
                            break block0;
                        }
                        case 'A': 
                        case 'a': {
                            stringBuffer.append('\'');
                            break block0;
                        }
                        case 'B': 
                        case 'b': {
                            stringBuffer.append('\\');
                            break block0;
                        }
                        case 'C': 
                        case 'c': {
                            stringBuffer.append(':');
                            break block0;
                        }
                        case 'D': 
                        case 'd': {
                            stringBuffer.append('$');
                            break block0;
                        }
                        case 'E': 
                        case 'e': {
                            stringBuffer.append('=');
                            break block0;
                        }
                        case 'F': 
                        case 'f': {
                            stringBuffer.append('/');
                            break block0;
                        }
                        case 'G': 
                        case 'g': {
                            stringBuffer.append('>');
                            break block0;
                        }
                        case 'H': 
                        case 'h': {
                            stringBuffer.append('?');
                            break block0;
                        }
                        case 'I': 
                        case 'i': {
                            stringBuffer.append('[');
                            break block0;
                        }
                        case 'J': 
                        case 'j': {
                            stringBuffer.append(']');
                            break block0;
                        }
                        case 'K': 
                        case 'k': {
                            stringBuffer.append(';');
                            break block0;
                        }
                        case 'L': 
                        case 'l': {
                            stringBuffer.append('<');
                            break block0;
                        }
                        case 'M': 
                        case 'm': {
                            stringBuffer.append('&');
                            break block0;
                        }
                        case 'N': 
                        case 'n': {
                            stringBuffer.append('+');
                            break block0;
                        }
                        case 'O': 
                        case 'o': {
                            stringBuffer.append('#');
                            break block0;
                        }
                        case 'P': 
                        case 'p': {
                            stringBuffer.append('%');
                            break block0;
                        }
                        case 'Q': 
                        case 'q': {
                            stringBuffer.append('\"');
                            break block0;
                        }
                        case 'R': 
                        case 'r': {
                            stringBuffer.append('^');
                            break block0;
                        }
                        case 'S': 
                        case 's': {
                            stringBuffer.append('*');
                            break block0;
                        }
                        case 'T': 
                        case 't': {
                            stringBuffer.append('~');
                            break block0;
                        }
                        case 'U': 
                        case 'u': {
                            stringBuffer.append('_');
                            break block0;
                        }
                        case 'V': 
                        case 'v': {
                            stringBuffer.append('|');
                            break block0;
                        }
                        case 'W': 
                        case 'w': {
                            stringBuffer.append('`');
                            break block0;
                        }
                        case 'X': 
                        case 'x': {
                            stringBuffer.append('!');
                            break block0;
                        }
                        case 'Y': 
                        case 'y': {
                            stringBuffer.append('{');
                            break block0;
                        }
                        case 'Z': 
                        case 'z': {
                            stringBuffer.append('}');
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private static class GlyfInfo {
        public int xMin;
        public int yMin;
        public int xMax;
        public int yMax;
        public byte[] data;

        private GlyfInfo() {
        }
    }
}

