/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.main;

import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.mover.MoverFile;
import com.kreative.bitsnpicas.mover.ResourceBundle;
import com.kreative.rsrc.MacResourceArray;
import com.kreative.rsrc.MacResourceFile;
import com.kreative.rsrc.MacResourceProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class SplitSuit {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            SplitSuit.printHelp();
        } else {
            boolean bl;
            boolean bl2 = true;
            File file = null;
            try {
                bl = System.getProperty("os.name").toUpperCase().contains("MAC OS");
            }
            catch (Exception exception) {
                bl = false;
            }
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n++];
                if (bl2 && string.startsWith("-")) {
                    if (string.equals("--")) {
                        bl2 = false;
                        continue;
                    }
                    if (string.equals("-d") && n < stringArray.length) {
                        file = new File(stringArray[n++]);
                        continue;
                    }
                    if (string.equals("-D")) {
                        bl = false;
                        continue;
                    }
                    if (string.equals("-R")) {
                        bl = true;
                        continue;
                    }
                    if (string.equals("--help")) {
                        SplitSuit.printHelp();
                        continue;
                    }
                    System.err.println("Unknown option: " + string);
                    continue;
                }
                try {
                    System.out.print(string + "...");
                    File file2 = new File(string);
                    File file3 = new File(new File(file2, "..namedfork"), "rsrc");
                    File file4 = file != null ? file : file2.getParentFile();
                    int n2 = 0;
                    MacResourceProvider macResourceProvider = SplitSuit.open(file2);
                    if (macResourceProvider != null) {
                        n2 += SplitSuit.process(file4, bl, macResourceProvider);
                        macResourceProvider.close();
                    }
                    if ((macResourceProvider = SplitSuit.open(file3)) != null) {
                        n2 += SplitSuit.process(file4, bl, macResourceProvider);
                        macResourceProvider.close();
                    }
                    System.out.println(n2 > 0 ? " DONE" : " ERROR: No items found.");
                }
                catch (IOException iOException) {
                    System.out.println(" ERROR: " + iOException.getClass().getSimpleName() + ": " + iOException.getMessage());
                }
            }
        }
    }

    private static MacResourceProvider open(File file) {
        try {
            return new MacResourceFile(file, "r", 0);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static int process(File file, boolean bl, MacResourceProvider macResourceProvider) throws IOException {
        MoverFile moverFile = new MoverFile(macResourceProvider);
        int n = moverFile.size();
        for (int i = 0; i < n; ++i) {
            SplitSuit.export(file, bl, moverFile.get(i));
        }
        return moverFile.size();
    }

    private static void export(File file, boolean bl, ResourceBundle resourceBundle) throws IOException {
        File file2;
        File file3;
        if (bl) {
            file3 = new File(file, resourceBundle.name);
            file3.createNewFile();
            file2 = new File(new File(file3, "..namedfork"), "rsrc");
        } else {
            file2 = file3 = new File(file, resourceBundle.name + ".dfont");
        }
        MacResourceArray macResourceArray = new MacResourceArray();
        MoverFile moverFile = new MoverFile((MacResourceProvider)macResourceArray);
        moverFile.add(resourceBundle);
        macResourceArray.close();
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        fileOutputStream.write(macResourceArray.getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();
        if (bl) {
            MacUtility.setTypeAndCreator(file3, resourceBundle.moverType, "movr");
        }
    }

    private static void printHelp() {
        System.out.println("SplitSuit - Split Macintosh suitcase files into separate mover files.");
        System.out.println("  -d <path>     Specify directory for output files.");
        System.out.println("  -D            Write to data fork. (Default on non-Mac OS systems.)");
        System.out.println("  -R            Write to resource fork. (Default on Mac OS systems.)");
    }
}

