/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.mover.FONDEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FONDResource {
    public String name;
    public int flags;
    public int id;
    public int firstChar;
    public int lastChar;
    public int maxAscent;
    public int maxDescent;
    public int maxLeading;
    public int maxCharWidth;
    public int offsetToGlyphWidthTable;
    public int offsetToKerningTable;
    public int offsetToStyleMappingTable;
    public int extraWidthForPlain;
    public int extraWidthForBold;
    public int extraWidthForItalic;
    public int extraWidthForUnderline;
    public int extraWidthForOutline;
    public int extraWidthForShadow;
    public int extraWidthForCondensed;
    public int extraWidthForExtended;
    public int extraWidthForGroup;
    public int internationalInfo;
    public int version;
    public final SortedSet<FONDEntry> entries = new TreeSet<FONDEntry>();
    public byte[] optionalTables;

    public FONDResource(String string, int n) {
        this.name = string;
        this.flags = 24576;
        this.id = n;
        this.version = 1;
    }

    public FONDResource(FONDResource fONDResource, Iterable<FONDEntry> iterable) {
        this.name = fONDResource.name;
        this.flags = fONDResource.flags;
        this.id = fONDResource.id;
        this.firstChar = fONDResource.firstChar;
        this.lastChar = fONDResource.lastChar;
        this.maxAscent = fONDResource.maxAscent;
        this.maxDescent = fONDResource.maxDescent;
        this.maxLeading = fONDResource.maxLeading;
        this.maxCharWidth = fONDResource.maxCharWidth;
        this.offsetToGlyphWidthTable = fONDResource.offsetToGlyphWidthTable;
        this.offsetToKerningTable = fONDResource.offsetToKerningTable;
        this.offsetToStyleMappingTable = fONDResource.offsetToStyleMappingTable;
        this.extraWidthForPlain = fONDResource.extraWidthForPlain;
        this.extraWidthForBold = fONDResource.extraWidthForBold;
        this.extraWidthForItalic = fONDResource.extraWidthForItalic;
        this.extraWidthForUnderline = fONDResource.extraWidthForUnderline;
        this.extraWidthForOutline = fONDResource.extraWidthForOutline;
        this.extraWidthForShadow = fONDResource.extraWidthForShadow;
        this.extraWidthForCondensed = fONDResource.extraWidthForCondensed;
        this.extraWidthForExtended = fONDResource.extraWidthForExtended;
        this.extraWidthForGroup = fONDResource.extraWidthForGroup;
        this.internationalInfo = fONDResource.internationalInfo;
        this.version = fONDResource.version;
        for (FONDEntry fONDEntry : iterable) {
            this.entries.add(fONDEntry);
        }
        this.optionalTables = fONDResource.optionalTables;
    }

    public FONDResource(String string, DataInput dataInput, int n) throws IOException {
        int n2;
        this.name = string;
        this.flags = dataInput.readUnsignedShort();
        this.id = dataInput.readShort();
        this.firstChar = dataInput.readUnsignedShort();
        this.lastChar = dataInput.readUnsignedShort();
        this.maxAscent = dataInput.readUnsignedShort();
        this.maxDescent = dataInput.readUnsignedShort();
        this.maxLeading = dataInput.readUnsignedShort();
        this.maxCharWidth = dataInput.readUnsignedShort();
        this.offsetToGlyphWidthTable = dataInput.readInt();
        this.offsetToKerningTable = dataInput.readInt();
        this.offsetToStyleMappingTable = dataInput.readInt();
        this.extraWidthForPlain = dataInput.readUnsignedShort();
        this.extraWidthForBold = dataInput.readUnsignedShort();
        this.extraWidthForItalic = dataInput.readUnsignedShort();
        this.extraWidthForUnderline = dataInput.readUnsignedShort();
        this.extraWidthForOutline = dataInput.readUnsignedShort();
        this.extraWidthForShadow = dataInput.readUnsignedShort();
        this.extraWidthForCondensed = dataInput.readUnsignedShort();
        this.extraWidthForExtended = dataInput.readUnsignedShort();
        this.extraWidthForGroup = dataInput.readUnsignedShort();
        this.internationalInfo = dataInput.readInt();
        this.version = dataInput.readUnsignedShort();
        int n3 = dataInput.readShort() + 1;
        for (n2 = 0; n2 < n3; ++n2) {
            this.entries.add(new FONDEntry(dataInput));
        }
        n2 = 54 + 6 * n3;
        if (this.offsetToGlyphWidthTable != 0) {
            this.offsetToGlyphWidthTable -= n2;
        }
        if (this.offsetToKerningTable != 0) {
            this.offsetToKerningTable -= n2;
        }
        if (this.offsetToStyleMappingTable != 0) {
            this.offsetToStyleMappingTable -= n2;
        }
        if (n > n2) {
            this.optionalTables = new byte[n - n2];
            dataInput.readFully(this.optionalTables);
        }
    }

    public FONDResource(String string, byte[] byArray) throws IOException {
        this(string, new DataInputStream(new ByteArrayInputStream(byArray)), byArray.length);
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.flags);
        dataOutput.writeShort(this.id);
        dataOutput.writeShort(this.firstChar);
        dataOutput.writeShort(this.lastChar);
        dataOutput.writeShort(this.maxAscent);
        dataOutput.writeShort(this.maxDescent);
        dataOutput.writeShort(this.maxLeading);
        dataOutput.writeShort(this.maxCharWidth);
        int n = 54 + 6 * this.entries.size();
        dataOutput.writeInt(this.offsetToGlyphWidthTable == 0 ? 0 : this.offsetToGlyphWidthTable + n);
        dataOutput.writeInt(this.offsetToKerningTable == 0 ? 0 : this.offsetToKerningTable + n);
        dataOutput.writeInt(this.offsetToStyleMappingTable == 0 ? 0 : this.offsetToStyleMappingTable + n);
        dataOutput.writeShort(this.extraWidthForPlain);
        dataOutput.writeShort(this.extraWidthForBold);
        dataOutput.writeShort(this.extraWidthForItalic);
        dataOutput.writeShort(this.extraWidthForUnderline);
        dataOutput.writeShort(this.extraWidthForOutline);
        dataOutput.writeShort(this.extraWidthForShadow);
        dataOutput.writeShort(this.extraWidthForExtended);
        dataOutput.writeShort(this.extraWidthForCondensed);
        dataOutput.writeShort(this.extraWidthForGroup);
        dataOutput.writeInt(this.internationalInfo);
        dataOutput.writeShort(this.version);
        dataOutput.writeShort(this.entries.size() - 1);
        for (FONDEntry fONDEntry : this.entries) {
            fONDEntry.write(dataOutput);
        }
        if (this.optionalTables != null) {
            dataOutput.write(this.optionalTables);
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(byteArrayOutputStream));
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public int length() {
        int n = 54 + 6 * this.entries.size();
        if (this.optionalTables != null) {
            n += this.optionalTables.length;
        }
        return n;
    }

    public String toString() {
        if (this.entries.size() == 1) {
            return this.entries.first().toString(this.name);
        }
        return this.name;
    }
}

