/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.bitsnpicas.mover;

import com.kreative.bitsnpicas.MacUtility;
import com.kreative.bitsnpicas.edit.CommonMenuItems;
import com.kreative.bitsnpicas.edit.Main;
import com.kreative.bitsnpicas.edit.SaveChangesDialog;
import com.kreative.bitsnpicas.edit.SaveInterface;
import com.kreative.bitsnpicas.mover.MoverInfoPanel;
import com.kreative.rsrc.MacResourceArray;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;

public class SaveManager
extends WindowAdapter
implements SaveInterface {
    private JFrame frame;
    private File file;
    private File fork;
    private String type;
    private String creator;
    private MacResourceArray rp;
    private MoverInfoPanel ip;
    private boolean changed;

    public SaveManager(JFrame jFrame, File file, File file2, MacResourceArray macResourceArray) {
        this.frame = jFrame;
        this.file = file;
        this.fork = file2;
        if (file != null) {
            this.type = MacUtility.getType(file);
            this.creator = MacUtility.getCreator(file);
            if (this.type == null || this.type.equals("\u0000\u0000\u0000\u0000")) {
                this.type = "FFIL";
            }
            if (this.creator == null || this.creator.equals("\u0000\u0000\u0000\u0000")) {
                this.creator = "DMOV";
            }
        } else {
            this.type = "FFIL";
            this.creator = "DMOV";
        }
        this.rp = macResourceArray;
        this.changed = false;
        this.updateWindow();
    }

    public void setInfoPanel(MoverInfoPanel moverInfoPanel) {
        this.ip = moverInfoPanel;
    }

    public void setChanged() {
        this.changed = true;
        this.updateWindow();
    }

    public boolean save() {
        if (this.file == null || this.fork == null) {
            return this.saveAs();
        }
        boolean bl = this.write();
        if (bl) {
            this.changed = false;
        }
        this.updateWindow();
        return bl;
    }

    public boolean saveAs() {
        File file = Main.getSaveFile("");
        if (file == null) {
            return false;
        }
        this.file = file;
        if (file.getName().toLowerCase().endsWith(".dfont")) {
            this.fork = file;
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            MacUtility.setTypeAndCreator(file, this.type, this.creator);
            this.fork = MacUtility.getResourceFork(file);
        }
        boolean bl = this.write();
        if (bl) {
            this.changed = false;
        }
        this.updateWindow();
        return bl;
    }

    private boolean write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.fork);
            fileOutputStream.write(this.rp.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        Window window = windowEvent.getWindow();
        if (!this.changed) {
            window.dispose();
        } else {
            switch (new SaveChangesDialog(window, this.file.getName()).showDialog()) {
                case SAVE: {
                    if (!this.save()) break;
                    window.dispose();
                    break;
                }
                case DONT_SAVE: {
                    window.dispose();
                    break;
                }
            }
        }
    }

    private void updateWindow() {
        String string;
        String string2 = string = this.file == null ? "Untitled Suitcase" : this.file.getName();
        if (CommonMenuItems.IS_MAC_OS) {
            this.frame.getRootPane().putClientProperty("Window.documentFile", this.file);
            this.frame.getRootPane().putClientProperty("Window.documentModified", this.changed);
            this.frame.setTitle(string);
        } else {
            this.frame.setTitle(this.changed ? string + " \u2022" : string);
        }
        if (this.ip != null) {
            this.ip.setFile(this.file);
        }
    }
}

